<?php

use yii\helpers\Html;
use kartik\grid\GridView;
use yii\helpers\Url;

$this->title = 'Payout Information';
$this->params['breadcrumbs'][] = $this->title;
?>

<div class="payout-info">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title"><?= Html::encode($this->title) ?></h3>
                </div>
                <div class="card-body">
                    <?= GridView::widget([
                        'dataProvider' => new \yii\data\ArrayDataProvider([
                            'allModels' => $payouts,
                            'pagination' => false,
                        ]),
                        'panel' => [
                            'type' => GridView::TYPE_DEFAULT,
                            'heading' => 'Payouts',
                        ],
                        'toolbar' => false,
                        'columns' => [
                            [
                                'attribute' => 'id',
                                'label' => 'Payout ID',
                                'format' => 'raw',
                                'value' => function ($model) use ($selectedPayoutId) {
                                    return Html::a(
                                        Html::encode($model['id']),
                                        ['payout-info', 'payout_id' => $model['id']],
                                        ['class' => $selectedPayoutId === $model['id'] ? 'font-weight-bold' : '']
                                    );
                                },
                            ],
                            [
                                'attribute' => 'amount',
                                'label' => 'Amount',
                                'value' => function ($model) {
                                    return $model['amount'] . ' ' . $model['currency'];
                                },
                            ],
                            [
                                'attribute' => 'created',
                                'label' => 'Created',
                            ],
                            [
                                'attribute' => 'arrival_date',
                                'label' => 'Arrival Date',
                            ],
                            [
                                'attribute' => 'status',
                                'label' => 'Status',
                                'format' => 'raw',
                                'value' => function ($model) {
                                    $badgeClass = match ($model['status']) {
                                        'paid' => 'badge bg-success',
                                        'pending' => 'badge bg-warning',
                                        'failed' => 'badge bg-danger',
                                        default => 'badge bg-secondary'
                                    };
                                    return Html::tag('span', Html::encode($model['status']), ['class' => $badgeClass]);
                                },
                            ],
                            [
                                'attribute' => 'type',
                                'label' => 'Type',
                            ],
                        ],
                    ]); ?>

                    <?php if ($selectedPayoutId && !empty($balanceTransactions)): ?>
                        <?= GridView::widget([
                            'dataProvider' => new \yii\data\ArrayDataProvider([
                                'allModels' => $balanceTransactions,
                                'pagination' => false,
                            ]),
                            'panel' => [
                                'type' => GridView::TYPE_DEFAULT,
                                'heading' => 'Balance Transactions for Payout: ' . $selectedPayoutId,
                            ],
                            'toolbar' => false,
                            'columns' => [
                                [
                                    'attribute' => 'id',
                                    'label' => 'Transaction ID',
                                ],
                                [
                                    'attribute' => 'amount',
                                    'label' => 'Amount',
                                    'value' => function ($model) {
                                        return $model['amount'] . ' ' . $model['currency'];
                                    },
                                ],
                                [
                                    'attribute' => 'created',
                                    'label' => 'Created',
                                ],
                                [
                                    'attribute' => 'type',
                                    'label' => 'Type',
                                ],
                                [
                                    'attribute' => 'status',
                                    'label' => 'Status',
                                    'format' => 'raw',
                                    'value' => function ($model) {
                                        $badgeClass = match ($model['status']) {
                                            'available' => 'badge bg-success',
                                            'pending' => 'badge bg-warning',
                                            default => 'badge bg-secondary'
                                        };
                                        return Html::tag('span', Html::encode($model['status']), ['class' => $badgeClass]);
                                    },
                                ],
                                [
                                    'attribute' => 'fee',
                                    'label' => 'Fee',
                                    'value' => function ($model) {
                                        return $model['fee'] . ' ' . $model['currency'];
                                    },
                                ],
                                [
                                    'attribute' => 'net',
                                    'label' => 'Net',
                                    'value' => function ($model) {
                                        return $model['net'] . ' ' . $model['currency'];
                                    },
                                ],
                                [
                                    'attribute' => 'source.payment_intent',
                                    'label' => 'Payment Intent',
                                ],
                                [
                                    'label' => 'Form',
                                    'format' => 'raw',
                                    'value' => function ($model) {
                                        if (!empty($model['stripe_payment'])) {
                                            return Html::a(
                                                Html::encode($model['stripe_payment']['form_id']),
                                                ['/form/update', 'id' => $model['stripe_payment']['form_id']]
                                            );
                                        }
                                        return null;
                                    },
                                ],
                                [
                                    'label' => 'Submission',
                                    'format' => 'raw',
                                    'value' => function ($model) {
                                        if (!empty($model['stripe_payment'])) {
                                            return Html::a(
                                                Html::encode($model['stripe_payment']['submission_id']),
                                                ['/form/submissions/view', 'id' => $model['stripe_payment']['submission_id']]
                                            );
                                        }
                                        return null;
                                    },
                                ],
                                [
                                    'label' => 'Payment Status',
                                    'format' => 'raw',
                                    'value' => function ($model) {
                                        if (!empty($model['stripe_payment'])) {
                                            $badgeClass = match ($model['stripe_payment']['status']) {
                                                'succeeded' => 'badge bg-success',
                                                'pending' => 'badge bg-warning',
                                                'failed' => 'badge bg-danger',
                                                default => 'badge bg-secondary'
                                            };
                                            return Html::tag('span', Html::encode($model['stripe_payment']['status']), ['class' => $badgeClass]);
                                        }
                                        return null;
                                    },
                                ],
                            ],
                        ]); ?>
                    <?php elseif ($selectedPayoutId): ?>
                        <div class="alert alert-info">No transactions found for this payout.</div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div> 