<?php

use app\components\widgets\ActiveForm;
use yii\captcha\Captcha;
use yii\helpers\Html;

/**
 * @var yii\web\View $this
 * @var Da\User\Form\RegistrationForm $model
 * @var app\models\User $user
 * @var Da\User\Module $module
 */

$this->title = Yii::t('app', 'Sign up');
$this->params['breadcrumbs'][] = $this->title;
?>
<style>
    .text-muted-light {
        color: var(--tblr-secondary-color)!important;
    }
    .field-registrationform-captcha img {
        background-color:#2C382F
    }
</style>
<div class="card card-md" style="background-color:#06402B;">
    <div class="card-body" style="color:white;">
        <h2 class="card-title text-center mb-4">
            <?= Yii::t('app', 'Create new account') ?>
        </h2>
        <?php $form = ActiveForm::begin(
            [
                'id' => $model->formName(),
                'enableAjaxValidation' => false,
                'enableClientValidation' => false,
            ]
        ); ?>
        <div class="mb-3">
            <?= $form->field($model, 'email', [
                'labelOptions' => [
                    'class' => 'form-label',
                ],
            ])->textInput(['autofocus' => true, 'style' => 'background-color:white;color:black;']) ?>
        </div>
        <div class="mb-3">
            <?= $form->field($model, 'username', [
                'labelOptions' => [
                    'class' => 'form-label',
                ],
            ])->textInput(['style' => 'background-color:white;color:black;']) ?>
        </div>
        <?php if ($module->generatePasswords === false): ?>
            <div class="mb-3">
                <?= $form->field($model, 'password', [
                    'labelOptions' => [
                        'class' => 'form-label',
                    ],
                ])->passwordInput(['style' => 'background-color:white;color:black;']) ?>
            </div>
        <?php endif ?>
        <?php if (Yii::$app->settings->get('app.useCaptcha')): ?>
            <div class="mb-3">
                <?= $form->field($model, 'captcha', [
                    'labelOptions' => [
                        'class' => 'form-label',
                    ],
                    'inputOptions' => [
                        'style' => 'background-color:white;color:black;'
                    ],

                ])
                    ->widget(Captcha::class, [
                        'captchaAction' => ['/user/registration/captcha'],
                        'imageOptions' => ['id' => 'my-captcha-image'],
                    ]) ?>

                <?php echo Html::button('Refresh Captcha', ['id' => 'refresh-captcha', 'class' => 'btn btn-primary', 'style' => 'background-color: transparent;color: black;border: 1px solid black;']);?>
                <?php $this->registerJs("
                    $('#refresh-captcha').on('click', function(e){
                        e.preventDefault();
                
                        $('#my-captcha-image').yiiCaptcha('refresh');
                    })
                "); ?>
            </div>
        <?php endif; ?>
        <?php if ($module->enableGdprCompliance): ?>
            <div class="mb-3">
                <?= $form->field($model, 'gdpr_consent')->checkbox(['custom' => true, 'value' => 1]) ?>
            </div>
        <?php endif ?>
        <div class="form-footer">
            <?= Html::submitButton(Yii::t('app', 'Sign up'), ['class' => 'btn btn-primary w-100', 'tabindex' => '3', 'style' => 'background-color:#ffc932;color:black;']) ?>
        </div>
        <?php ActiveForm::end(); ?>
    </div>
</div>
<div class="text-center text-muted mt-3 text-muted">
    <?= Yii::t('app', 'Already have an account?') ?>
    <?= Html::a(Yii::t('app', 'Sign In'), ["/user/security/login"]) ?>
</div>
