<?php

use app\components\widgets\Alert;
use app\components\widgets\SessionTimeout;
use app\helpers\Html;
use app\helpers\IconHelper;
use app\helpers\Language;
use app\themes\next\bundles\AppBundle;
use yii\helpers\Url;
use yii\widgets\Menu;

/* @var $this \yii\web\View */
/* @var $content string */

AppBundle::register($this);

$moduleID = $this->context->module->id;
$controllerID = $this->context->id;
$actionID = $this->context->action->id;
$userModule = Yii::$app->getModule('user');

if (Yii::$app->params['environment'] === 'test')
    Yii::$app->session->setFlash('warning', 'This is a Staging Environment');

// Session Timeout
$timeoutValue = (int) Yii::$app->user->preferences->get('App.User.SessionTimeout.value');
$timeoutWarning = empty(Yii::$app->params['App.User.SessionTimeout.warning']) ? $timeoutValue : ($timeoutValue - (int) Yii::$app->params['App.User.SessionTimeout.warning']);
// Disable with Form Builder
$disabledTimeout = in_array($controllerID, ['form', 'template']) && in_array($actionID, ['create', 'update']);
// Theme
$themeMode = Yii::$app->user->preferences->get('UI.theme.mode', 'theme-light');
$themeDark = $themeMode === 'theme-dark';
?>
<?php $this->beginPage() ?>
<!doctype html>
<html lang="<?= Yii::$app->language ?>" dir="<?php echo Language::dir(); ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <meta name="generator" content="<?= Yii::$app->name ?> <?= Yii::$app->version ?>" />
    <link rel="icon" type="image/png" href="/favicon-96x96.png" sizes="96x96" />
    <link rel="icon" type="image/svg+xml" href="/favicon.svg" />
    <link rel="shortcut icon" href="/favicon.ico?v=2" />
    <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png" />
    <link rel="manifest" href="/site.webmanifest" />
    <?= Html::csrfMetaTags() ?>
    <title><?= Html::encode($this->title) . ' | ' . Yii::$app->settings->get('app.name') ?></title>
    <meta name="msapplication-TileColor" content=""/>
    <meta name="theme-color" content=""/>
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="mobile-web-app-capable" content="yes"/>
    <meta name="HandheldFriendly" content="True"/>
    <meta name="MobileOptimized" content="320"/>
    <!-- CSS files -->
    <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/libs/fontawesome/css/all.css') ?>">
    <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/tabler.min.css') ?>">
    <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/tabler-vendors.min.css') ?>">
    <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/app.min.css') ?>">
    <!-- CSS files -->
    <?php $this->head() ?>
</head>
<body class="main <?= $controllerID ?> <?= $controllerID ?>-<?= $actionID ?>"<?php if ($themeDark): ?> data-bs-theme="dark"<?php endif; ?>>
<?php $this->beginBody() ?>
<div class="page">
    <!-- Navbar -->
    <header class="navbar navbar-expand-md d-print-none bg-light" data-bs-theme="light">
        <div class="container-xl">
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <h1 class="navbar-brand navbar-brand-autodark d-none-navbar-horizontal p-0 pe-md-3">
                <!-- Brand -->
                <?= $this->render('@app/themes/next/views/partials/_brand', [
                    'brandHeight' => '26px',
                    'logoColor' => 'white'
                ]) ?>
            </h1>
            <div class="navbar-nav flex-row order-md-last">
                <div class="d-none d-md-flex" style="display:none !important;">
                    <a href="#" class="nav-link theme-link px-0 hide-theme-dark" title="<?= Yii::t('app', 'Enable dark mode') ?>" data-bs-toggle="tooltip"
                       data-bs-placement="bottom" data-theme-mode="theme-dark">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 3c.132 0 .263 0 .393 0a7.5 7.5 0 0 0 7.92 12.446a9 9 0 1 1 -8.313 -12.454z" /></svg>
                    </a>
                    <a href="#" class="nav-link theme-link px-0 hide-theme-light" title="<?= Yii::t('app', 'Enable light mode') ?>" data-bs-toggle="tooltip"
                       data-bs-placement="bottom" data-theme-mode="theme-light">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0" /><path d="M3 12h1m8 -9v1m8 8h1m-9 8v1m-6.4 -15.4l.7 .7m12.1 -.7l-.7 .7m0 11.4l.7 .7m-12.1 -.7l-.7 .7" /></svg>
                    </a>
                    <div class="nav-item dropdown d-none d-md-flex me-3" style="display:none;">
                        <a id="notification-link" href="#" class="nav-link px-0" data-bs-toggle="dropdown" tabindex="-1" aria-label="Show notifications">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="white" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6" /><path d="M9 17v1a3 3 0 0 0 6 0v-1" /></svg>
                        </a>
                        <div class="dropdown-menu dropdown-menu-arrow dropdown-menu-end dropdown-menu-card">
                            <div id="notification-card" class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <?= Yii::t('app', 'Notifications') ?>
                                    </h3>
                                    <div class="card-actions">
                                        <a id="notification-action-link" class="btn btn-icon" title="<?= Yii::t('app', 'Mark all as read') ?>" href="#">
                                            <?= IconHelper::show('list-check') ?>
                                        </a>
                                    </div>
                                </div>
                                <div id="notification-list" class="list-group list-group-flush list-group-hoverable">
                                    <div class="list-group-item disabled">
                                        <?= Yii::t('app', 'Loading...') ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nav-item dropdown">
                    <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown" aria-label="Open user menu">
<!--                        <span class="avatar avatar-sm" style="background-image: url(--><?php //= Yii::$app->user->identity->profile->getAvatarUrl() ?><!--)"></span>-->
                        <div class="d-none d-xl-block ps-2">
                            <div><?= Yii::$app->user->identity->username ?></div>
                            <div class="mt-1 small text-muted"><?= Yii::$app->user->identity->email ?></div>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow bg-light">
                        <a href="<?= Url::to(['/user/settings/account']) ?>" class="dropdown-item"><?= Yii::t('app', 'Manage Account') ?></a>
                        <a href="<?= Url::to(['/user/settings/profile']) ?>" class="dropdown-item"><?= Yii::t('app', 'Profile') ?></a>
                        <a href="<?= Url::to(['/user/settings/preferences']) ?>" class="dropdown-item"><?= Yii::t('app', 'Preferences') ?></a>
                        <?php if (Yii::$app->user->can("configureSite")): ?>
                            <a href="<?= Url::to(['/settings/site']) ?>" class="dropdown-item"><?= Yii::t('app', 'Site Settings') ?></a>
                        <?php endif; ?>
                        <?php if (Yii::$app->session->has($userModule->switchIdentitySessionKey)): ?>
                            <?= Html::a(Yii::t('app', 'Switch back'), ['/user/admin/switch-identity'], ['data-method' => 'post', 'class' => 'dropdown-item text-orange', 'title' => Yii::t('app', 'Switch back to your account')]) ?>
                        <?php endif; ?>
                        <?= Html::a('<span class="me-2">' .IconHelper::show('logout') . '</span>' . Yii::t('app', 'Logout'), ['/user/security/logout'], ['data-method' => 'post', 'class' => 'dropdown-item text-pink', 'title' => Yii::t('app', 'Logout')]) ?>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <header class="navbar-expand-md">
        <div class="collapse navbar-collapse" id="navbar-menu">
            <div class="navbar navbar-light">
                <div class="container-xl">
                    <?= Menu::widget([
                        'options' => ['class' => 'navbar-nav'],
                        'itemOptions' => ['class' => 'nav-item'],
                        'activeCssClass'=>'active',
                        'activateParents' => true,
                        'encodeLabels' => false,
                        'linkTemplate' => '<a class="nav-link" href="{url}">{label}</a>',
                        'submenuTemplate' => "\n<ul class='dropdown-menu'>\n{items}\n</ul>\n",
//                        'submenuTemplate' => "\n<div class='dropdown-menu'>\n{items}\n</div>\n",
                        'items' => [
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <path d="M5 12l-2 0l9 -9l9 9l-2 0" />
                                            <path d="M5 12v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-7" />
                                            <path d="M9 21v-6a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v6" />
                                        </svg>
                                    </span>
                                    <span class="nav-link-title">'.
                                        Yii::t('app', 'Dashboard').
                                    '</span>',
                                'url' => ['/dashboard/index'],
                            ],
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" >
                                            <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                            <g id="SVGRepo_iconCarrier"> <path d="M20 20H4V4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M4 16.5L12 9L15 12L19.5 7.5" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> </g>
                                        </svg>
                                    </span>
                                    <span class="nav-link-title">'.
                                    Yii::t('app', 'Payments').
                                    '</span>',
                                'template' => '<button class="nav-link dropdown-toggle" data-bs-toggle="dropdown">{label}</button>',
                                'options' => ['class' => 'nav-item dropdown'],
                                'items' => [
                                    ['label' => 'Dashboard', 'url' => ['/dashboard/payments'], 'options' => ['class' => 'dropdown-item'],'visible' => Yii::$app->user->can("viewPaymentDashboard", ['listing' => true]),],
                                    ['label' => 'Payments', 'url' => ['/dashboard/stripe-payments'], 'options' => ['class' => 'dropdown-item'],'visible' => Yii::$app->user->can("viewPaymentsPage", ['listing' => true]),],
                                    ['label' => 'Payouts', 'url' => ['/dashboard/payout-info'], 'options' => ['class' => 'dropdown-item'],'visible' => Yii::$app->user->can("viewPayoutsPage", ['listing' => true]),],
                                ]
                            ],
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                            <path d="M9 11l3 3l8 -8" />
                                            <path d="M20 12v6a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h9" />
                                        </svg>
                                    </span>
                                    <span class="nav-link-title">'.
                                        Yii::t('app', 'Forms').
                                    '</span>',
                                'url' => ['/form/index'],
                                'visible' => Yii::$app->user->can("viewForms", ['listing' => true]),
                                'active' => 'app' === $moduleID && 'form' === $controllerID,
                            ],
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-palette" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M12 21a9 9 0 0 1 0 -18c4.97 0 9 3.582 9 8c0 1.06 -.474 2.078 -1.318 2.828c-.844 .75 -1.989 1.172 -3.182 1.172h-2.5a2 2 0 0 0 -1 3.75a1.3 1.3 0 0 1 -1 2.25"></path>
                                            <path d="M8.5 10.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                            <path d="M12.5 7.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                            <path d="M16.5 10.5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"></path>
                                        </svg>
                                    </span>
                                    <span class="nav-link-title">'.
                                        Yii::t('app', 'Themes').
                                    '</span>',
                                'visible' => Yii::$app->user->can("viewThemes", ['listing' => true]),
                                'url' => ['/theme/index'],
                                'active' => 'app' === $moduleID && 'theme' === $controllerID,
                            ],
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">

                                        <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="22" height="20" stroke="currentColor" viewBox="0 0 38 32" enable-background="new 0 0 38 32" xml:space="preserve" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path fill="#808184" d="M36.5,0h-35C0.673,0,0,0.673,0,1.5v29C0,31.327,0.673,32,1.5,32h35c0.827,0,1.5-0.673,1.5-1.5v-29 C38,0.673,37.327,0,36.5,0z M37,30.5c0,0.275-0.225,0.5-0.5,0.5h-35C1.225,31,1,30.775,1,30.5v-29C1,1.225,1.225,1,1.5,1h35 C36.775,1,37,1.225,37,1.5V30.5z"></path> <path fill="#808184" d="M31.5,14h-25C5.673,14,5,14.673,5,15.5v10C5,26.327,5.673,27,6.5,27h25c0.827,0,1.5-0.673,1.5-1.5v-10 C33,14.673,32.327,14,31.5,14z M32,25.5c0,0.275-0.225,0.5-0.5,0.5h-25C6.225,26,6,25.775,6,25.5v-10C6,15.225,6.225,15,6.5,15h25 c0.275,0,0.5,0.225,0.5,0.5V25.5z"></path> <path fill="#808184" d="M31.5,5h-25C5.673,5,5,5.673,5,6.5v3C5,10.327,5.673,11,6.5,11h25c0.827,0,1.5-0.673,1.5-1.5v-3 C33,5.673,32.327,5,31.5,5z M32,9.5c0,0.275-0.225,0.5-0.5,0.5h-25C6.225,10,6,9.775,6,9.5v-3C6,6.225,6.225,6,6.5,6h25 C31.775,6,32,6.225,32,6.5V9.5z"></path> </g> </g></svg>
                                    </span>
                                    
                                    <span class="nav-link-title">'.
                                    Yii::t('app', 'Templates').
                                    '</span>',
                                'visible' => Yii::$app->user->can("viewTemplates", ['listing' => true]),
                                'url' => ['/templates/index'],
                                'active' => 'app' === $moduleID && 'template' === $controllerID,
                            ],
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-puzzle" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M4 7h3a1 1 0 0 0 1 -1v-1a2 2 0 0 1 4 0v1a1 1 0 0 0 1 1h3a1 1 0 0 1 1 1v3a1 1 0 0 0 1 1h1a2 2 0 0 1 0 4h-1a1 1 0 0 0 -1 1v3a1 1 0 0 1 -1 1h-3a1 1 0 0 1 -1 -1v-1a2 2 0 0 0 -4 0v1a1 1 0 0 1 -1 1h-3a1 1 0 0 1 -1 -1v-3a1 1 0 0 1 1 -1h1a2 2 0 0 0 0 -4h-1a1 1 0 0 1 -1 -1v-3a1 1 0 0 1 1 -1"></path>
                                        </svg>
                                    </span>
                                    <span class="nav-link-title">'.
                                    Yii::t('app', 'Add-Ons').
                                    '</span>',
                                'visible' => Yii::$app->user->can("viewAddons", ['listing' => true]),
                                'url' => ['/addons/admin/index'],
                                'active' => !in_array($moduleID, ['app', 'user', 'subscription']),
                            ],
                            [
                                'label' => '
                                    <span class="nav-link-icon d-md-none d-lg-inline-block">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-users" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M9 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"></path>
                                            <path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path>
                                            <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                            <path d="M21 21v-2a4 4 0 0 0 -3 -3.85"></path>
                                        </svg>
                                    </span>
                                    <span class="nav-link-title">'.
                                    Yii::t('app', 'Users').
                                    '</span>',
                                'visible' => Yii::$app->user->can("viewUsers"),
                                'url' => ['/user/admin/index'],
                                'active' => 'user' === $moduleID && 'settings' !== $controllerID,
                            ],
                        ],
                    ]); ?>
                    <div class="my-2 my-md-0 flex-grow-1 flex-md-grow-0 order-first order-md-last d-none d-sm-block">
                        <div class="dropdown">
                            <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <?= IconHelper::show('plus') ?> <?= Yii::t('app', 'Create New') ?>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <?php if (Yii::$app->user->can('createForms')): ?>
                                    <li><a href="<?= Url::to(['/form/create']) ?>" class="dropdown-item"><?= IconHelper::show('checkbox') ?> <span class="ms-2"><?= Yii::t('app', 'Form') ?></span></a></li>
                                <?php endif; ?>
                                <?php if (Yii::$app->user->can('createThemes')): ?>
                                    <li><a href="<?= Url::to(['/theme/create']) ?>" class="dropdown-item"><?= IconHelper::show('palette') ?> <span class="ms-2"><?= Yii::t('app', 'Theme') ?></span></a></li>
                                <?php endif; ?>
                                <?php if (Yii::$app->user->can('createTemplates')): ?>
                                    <li><a href="<?= Url::to(['/templates/create']) ?>" class="dropdown-item"><?= IconHelper::show('template') ?> <span class="ms-2"><?= Yii::t('app', 'Template') ?></span></a></li>
                                <?php endif; ?>
                                <?php if (Yii::$app->user->can('createUsers')): ?>
                                    <li><a href="<?= Url::to(['/user/admin/create']) ?>" class="dropdown-item"><?= IconHelper::show('user-plus') ?> <span class="ms-2"><?= Yii::t('app', 'User') ?></span></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <div class="page-wrapper">
        <!-- Page alert -->
        <div class="alert-container">
            <div class="container-xl">
                <div class="row">
                    <div class="col">
                        <?= Alert::widget() ?>
                    </div>
                </div>
            </div>
        </div>
        <?= $content ?>
        <footer class="footer footer-transparent d-print-none">
            <div class="container-xl">
                <div class="row text-center align-items-center flex-row-reverse">
                    <div class="col-lg-auto ms-lg-auto">
                        <ul class="list-inline list-inline-dots mb-0">
                            <li class="list-inline-item">
                                <?= Yii::t('app', 'Copyright') ?> &copy; <?= date('Y') ?> <?= Yii::$app->settings->get("app.name") ?>. <?= Yii::t('app', 'All rights reserved.') ?>
                            </li>
                        </ul>
                    </div>
                    <div class="col-12 col-lg-auto mt-3 mt-lg-0">
                        <ul class="list-inline list-inline-dots mb-0">
                            <li class="list-inline-item">
                                v<?= Yii::$app->version ?>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
    </div>
</div>
<?php $this->endBody() ?>

<?php if (!$disabledTimeout && $timeoutValue > 0): ?>
    <?= SessionTimeout::widget([
        'warnAfter' => $timeoutWarning,
        'redirAfter' => $timeoutValue,
    ]) ?>
<?php endif; ?>

<script>
    var timestamp = null;
    var notificationPanel = document.getElementById("notification-card");
    var notificationLink = document.getElementById("notification-link");
    var notificationActionLink = document.getElementById("notification-action-link");

    function countNotifications()
    {
        fetch('<?= Url::to(['/ajax/count-notifications']) ?>', {
            method: "POST",
            body: JSON.stringify({
                _csrf: '<?= Yii::$app->request->csrfToken ?>'
            }),
            headers: {"Content-type": "application/json; charset=UTF-8"}
        })
            .then(function (response) {
                if (response.ok && !response.redirected) {
                    return response.json();
                }
                throw new Error("Invalid response");
            })
            .then(function (response) {
                let notificationIcon = document.getElementById("notification-icon");
                if (notificationIcon) {
                    notificationIcon.remove();
                }
                if (response.timestamp && response.data) {
                    timestamp = response.timestamp;
                    if (response.data.length > 0) {
                        let notificationIcon = document.createElement("span");
                        if (notificationIcon) {
                            notificationIcon.classList.add('badge');
                            notificationIcon.classList.add('bg-red');
                            notificationLink.append(notificationIcon)
                        }
                    }
                }
                setTimeout("countNotifications()", 3000);
            })
            .catch(function (error) {
                console.log(error);
            });
    }

    function loadNotifications()
    {
        fetch('<?= Url::to(['/ajax/load-notifications']) ?>', {
            method: "POST",
            body: JSON.stringify({
                _csrf: '<?= Yii::$app->request->csrfToken ?>'
            }),
            headers: {"Content-type": "application/json; charset=UTF-8"}
        })
            .then(function (response) {
                if (response.ok && !response.redirected) {
                    return response.text();
                }
                throw new Error('Invalid response');
            })
            .then(function (html) {
                let notificationList = document.getElementById("notification-list");
                notificationList.innerHTML = html;
            }).catch(function (error) {
            console.log(error);
        });
    }

    function cleanNotifications()
    {
        fetch('<?= Url::to(['/ajax/clean-notifications']) ?>', {
            method: "POST",
            body: JSON.stringify({
                _csrf: '<?= Yii::$app->request->csrfToken ?>'
            }),
            headers: {"Content-type": "application/json; charset=UTF-8"}
        })
            .then(function (response) {
                if (response.ok && !response.redirected) {
                    let notificationList = document.getElementById("notification-list");
                    notificationList.innerHTML = '';
                    return response.json();
                }
                throw new Error("Invalid response");
            })
            .catch(function (error) {
                console.log(error);
            });

        return false;
    }

    document.addEventListener("DOMContentLoaded", function() {
        //// Theme mode
        //var themeLinks = document.getElementsByClassName('theme-link');
        //for (let i = 0; i < themeLinks.length; ++i) {
        //    themeLinks[i].onclick = function (e) {
        //        e.preventDefault();
        //        let themeMode = themeLinks[i].dataset.themeMode;
        //        if (themeMode === 'theme-dark') {
        //            document.body.dataset.bsTheme = 'dark';
        //        } else {
        //            delete document.body.dataset.bsTheme;
        //        }
        //
        //        fetch('<?php //= Url::to(['/ajax/theme-settings']) ?>//', {
        //            method: "POST",
        //            body: JSON.stringify({
        //                mode: themeMode,
        //                _csrf: '<?php //= Yii::$app->request->csrfToken ?>//'
        //            }),
        //            headers: {"Content-type": "application/json; charset=UTF-8"}
        //        })
        //            .then(function (response) {
        //                if (response.ok && !response.redirected) {
        //                    return response.json();
        //                }
        //                throw new Error("Invalid response");
        //            })
        //            .catch(function (error) {
        //                console.log(error);
        //            });
        //
        //        return false;
        //    };
        //}
        //
        //notificationLink.addEventListener("click", function (e) {
        //    e.preventDefault();
        //    loadNotifications();
        //});
        //
        //notificationActionLink.addEventListener("click", function (e) {
        //    e.preventDefault();
        //    cleanNotifications();
        //});
        //
        //countNotifications();

    });
</script>
</body>
</html>
<?php $this->endPage() ?>