<?php

/* @var $this yii\web\View */
/* @var $submissionModel \app\models\FormSubmission */


use app\components\widgets\ActiveForm;
use app\models\Form;
use app\modules\addons\modules\stripe\helpers\Client;
use app\modules\addons\modules\stripe\models\Stripe;

$event = new \yii\base\ViewEvent();
$event->output = '<html><body><div id="replace_with_checkout" style="display:flex;justify-content:center;align-items:center;padding:20px;">This field will enable users to checkout and pay.</div></body></html>';
// Add code only to app/embed view

//$formModel = $event->sender->context->getFormModel();
//$model = Stripe::findOne(['form_id' => $formModel->id, 'status' => 1]);
$model = \app\modules\addons\modules\stripe\models\Stripe::findOne(['id' => 33]);


if ($model) {
    $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);

    if (!empty($publishableKey)) {
        Client::displayCheckout($event, $model);
    }
}

$form = ActiveForm::begin();


echo $event->output;

?>

<input type="hidden" name="<?= $model->cardholder_name ?>" value="Sohaib Sheikh" />
<input type="hidden" name="<?= $model->receipt_email ?>" value="sohaib12@gmail.com" />

<script>
    window.onload = function () {

        const total = calculateTotal();

        $('#checkoutTable_total').html('$' + numberWithCommas(total));

        //var iframe = $('#c<?php //= $formModel->hashId ?>//i<?php //= $formModel->hashId ?>//');
        //var iframeWindow = iframe[0].contentWindow ? iframe[0].contentWindow : iframe[0].contentDocument.defaultView;

        // var html = '';

        const lineItems = $('#checkoutTable_line_items > div:visible').toArray();

        updateCheckoutLineItems(lineItems);
        updateCheckoutNumbers(total);
    };

    function calculateTotal() {
        var total = 0;

        $('#checkoutTable_line_items > div:visible').each(function(index, element) {
            $(this).find("div[id$='_amount']").each(function(index2, amountDiv) {
                console.log(amountDiv.innerHTML);
                var amount = amountDiv.innerHTML;
                amount = amount.replace("$","").replace(",","");
                if (amount.startsWith("-")) {
                    if (amount.endsWith("%"))
                        total = total - (total * parseInt(amount.replace("-", "").replace("%", ""))  / 100);
                    else
                        total = total - parseInt(amount.replace("-", ""));
                }
                else
                    total = total + parseInt(amount);
            });
        });
        total = (total < 0 ? 0 : total);

        return total;
    }
</script>
<div id="checkoutTable_line_items" class="card-body" style="visibility:hidden;height:0px;width:0px;flex-wrap:wrap;"><div id="checkoutTable_radio_7_0" style="width: 100%; display: flex;"><div style="display:flex;flex-basis:100%">
    <div class="line-icon">
        <i class="fas fa-bed fa-2x"></i>
    </div>
    <div class="line-item">Room<input type="hidden" name="lineItem[0][description]" value="Room"></div>
    <div class="line-price" id="checkoutTable_radio_7_0_amount">$500.00<input type="hidden" name="lineItem[0][price]" value="500"></div>
</div></div><div id="checkoutTable_radio_7_1" style="width: 100%; display: none;"><div style="display:flex;flex-basis:100%">
    <div class="line-icon">
        <i class="fas fa-bed fa-2x"></i>
    </div>
    <div class="line-item">Room<input type="hidden" name="lineItem[0][description]" value="Room"></div>
    <div class="line-price" id="checkoutTable_radio_7_1_amount">$600.00<input type="hidden" name="lineItem[0][price]" value="600"></div>
</div></div><div id="checkoutTable_radio_7_2" style="width: 100%; display: none;"><div style="display:flex;flex-basis:100%">
    <div class="line-icon">
        <i class="fas fa-bed fa-2x"></i>
    </div>
    <div class="line-item">Room<input type="hidden" name="lineItem[0][description]" value="Room"></div>
    <div class="line-price" id="checkoutTable_radio_7_2_amount">$700.00<input type="hidden" name="lineItem[0][price]" value="700"></div>
</div></div><div id="checkoutTable_radio_2_0" style="width: 100%; display: none;"><div style="display:flex;flex-basis:100%">
    <div class="line-icon">
        <i class="fas fa-car fa-2x"></i>
    </div>
    <div class="line-item">Transportation<input type="hidden" name="lineItem[1][description]" value="Transportation"></div>
    <div class="line-price" id="checkoutTable_radio_2_0_amount">$1,000.00<input type="hidden" name="lineItem[1][price]" value="1000"></div>
</div></div><div id="checkoutTable_radio_2_1" style="width: 100%; display: flex;"><div style="display:flex;flex-basis:100%">
    <div class="line-icon">
        <i class="fas fa-car fa-2x"></i>
    </div>
    <div class="line-item">Transportation<input type="hidden" name="lineItem[1][description]" value="Transportation"></div>
    <div class="line-price" id="checkoutTable_radio_2_1_amount">$0.00<input type="hidden" name="lineItem[1][price]" value="0"></div>
</div></div></div>

<?php ActiveForm::end(); ?>