<?php

use app\components\widgets\ActiveForm;
use app\components\widgets\Alert;
use app\helpers\Html;
use app\models\Form;
use app\modules\addons\modules\stripe\helpers\Client;
use app\modules\addons\modules\stripe\models\Stripe;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $model Stripe */
/* @var $name string */
/* @var $email string */
/* @var $e string encoded string */
/* @var $validationModel \yii\base\DynamicModel
 * @var $connected_account_id string
 */

$this->title = 'Manual Payment';

$publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);

$this->registerCssFile('@web/themes/next/assets/css/checkout.min.css');
$this->registerJsFile('https://code.jquery.com/ui/1.14.0/jquery-ui.js');
$this->registerJsFile('@web/static_files/js/buttonstrip.min.js');
$this->registerJs('
    
    // Validate form fields and toggle submit button
    function validateForm() {
        var name = $("input[name=\'cardholder_name\']").val();
        var email = $("input[name=\'receipt_email\']").val();
        var amount = $("#manual-payment-amount").val();
        
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        var isEmailValid = emailRegex.test(email);
        var isAmountValid = !isNaN(amount) && amount > 0;
        
        if (name && email && amount && isEmailValid && isAmountValid) {
            $("#submitPaymentButton").prop("disabled", false);
        } else {
            $("#submitPaymentButton").prop("disabled", true);
        }
    }

    // display correct checkout   
    function updateCheckout() {
        // check which payment option was selected and which payment method was selected
        var paymentOption = $("#payment-options").find(".Tab--selected").find(".TabLabel").html();
        var paymentMethod = $("#payment-methods").find(".Tab--selected").find(".TabLabel").html();
        
        $("#full-ach").removeClass("showSection");
        $("#full-card").removeClass("showSection");
        $("#subscribe-ach").removeClass("showSection");
        $("#subscribe-card").removeClass("showSection");
        
        if (paymentOption == "Pay Now" && paymentMethod == "ACH Transfer") {
            $("#full-ach").addClass("showSection");
        }
        else if (paymentOption == "Pay Now" && paymentMethod == "Card") {
            $("#full-card").addClass("showSection");
        }
        else if (paymentOption == "Pay in Installments" && paymentMethod == "ACH Transfer") {
            $("#subscribe-ach").addClass("showSection");
        }
        else if (paymentOption == "Pay in Installments" && paymentMethod == "Card") {
            $("#subscribe-card").addClass("showSection");
        }
        
        var previousSubtotal = Number($("#checkout_subtotal").html().replace(/[^0-9.-]+/g,""));
        updateCheckoutNumbers(previousSubtotal);
    }
    
    function updatePaymentOptionButton(updatedPaymentOption) {
        if (updatedPaymentOption == "full") {
            $("#payment-options").find("#pay-now").addClass("Tab--selected");
            $("#payment-options").find("#pay-plan").removeClass("Tab--selected");
            $("#payment-options").find("#pay-now").find("svg").addClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-plan").find("svg").removeClass("p-TabIcon--selected");
        
        }
        else if (updatedPaymentOption == "plan") {
            $("#payment-options").find("#pay-plan").addClass("Tab--selected");
            $("#payment-options").find("#pay-now").removeClass("Tab--selected");
            $("#payment-options").find("#pay-plan").find("svg").addClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-now").find("svg").removeClass("p-TabIcon--selected");
        }
        
        updateCheckout();
    }
    
    function updatePaymentMethodButton(updatedPaymentMethod) {
        if (updatedPaymentMethod == "ach") {
            $("#payment-methods").find("#ach").addClass("Tab--selected");
            $("#payment-methods").find("#card").removeClass("Tab--selected");
            $("#payment-methods").find("#ach").find("svg").addClass("p-TabIcon--selected");
            $("#payment-methods").find("#card").find("svg").removeClass("p-TabIcon--selected");
        }
        else if (updatedPaymentMethod == "card") {
            $("#payment-methods").find("#card").addClass("Tab--selected");
            $("#payment-methods").find("#ach").removeClass("Tab--selected");
            $("#payment-methods").find("#card").find("svg").addClass("p-TabIcon--selected");
            $("#payment-methods").find("#ach").find("svg").removeClass("p-TabIcon--selected");
        }
        
        updateFeeTable();
        updateCheckout();
    }
    
    function handleError() {
        $(\'.payment_alert\').show();
        $(\'#submitPaymentButton\').buttonLoader(\'stop\');
    }
    function clearError() {
        $(\'.payment_alert\').hide();
    }
    
    function handleError() {
        $(\'#submitPaymentButton\').buttonLoader(\'stop\');
    }
    
    function handleSuccess() {
        console.log(\'success\');
        
        var hiddenInput = document.createElement(\'input\');
        hiddenInput.setAttribute(\'type\', \'hidden\');
        hiddenInput.setAttribute(\'name\', \'paymentIntentStatus\');
        hiddenInput.setAttribute(\'value\', \'success\');
        formEl.find(\'[name="paymentIntentStatus"]\').remove();
        formEl.append(hiddenInput);
    }
    
    function handleProcessing() {
        console.log(\'processing\');
        
        var hiddenInput = document.createElement(\'input\');
        hiddenInput.setAttribute(\'type\', \'hidden\');
        hiddenInput.setAttribute(\'name\', \'paymentIntentStatus\');
        hiddenInput.setAttribute(\'value\', \'processing\');
        formEl.find(\'[name="paymentIntentStatus"]\').remove();
        formEl.append(hiddenInput);
    }
    
    function handleRequiresAction() {
        console.log(\'requires action\');
        
        var hiddenInput = document.createElement(\'input\');
        hiddenInput.setAttribute(\'type\', \'hidden\');
        hiddenInput.setAttribute(\'name\', \'paymentIntentStatus\');
        hiddenInput.setAttribute(\'value\', \'requires_action\');
        formEl.find(\'[name="paymentIntentStatus"]\').remove();
        formEl.append(hiddenInput);
    }
    
', View::POS_HEAD);

$event = new \yii\base\ViewEvent();
$event->output = '<html><body></body></html>';


if ($model) {
    $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);

    if (!empty($publishableKey)) {
        Client::displayCreditCardCodeOnView($event, $model, $connected_account_id);
        Client::displayACHCodeOnView($event, $model, $connected_account_id);
        Client::displaySubscribeCreditCard($event, $model, $connected_account_id);
        Client::displaySubscribeACH($event, $model, $connected_account_id);
    }
}

$form = ActiveForm::begin([
    'options' => ['style' => 'display:flex;justify-content:center;'],
    'validateOnBlur'=>false,
    'validateOnChange'=>false,
]);

echo $event->output;

$payment_options = ['full'];
$payment_methods = ['card','ach'];

$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, maximum-scale=1']);

?>

<script src="https://js.stripe.com/v3/"></script>
<style>
    .stripe-promo-form {
        --tblr-card-spacer-y: 1.25rem;
        --tblr-card-spacer-x: 1.25rem;
        --tblr-card-title-spacer-y: 1.25rem;
        --tblr-card-title-color: ;
        --tblr-card-subtitle-color: ;
        --tblr-card-border-width: var(--tblr-border-width);
        --tblr-card-border-color: var(--tblr-border-color-translucent);
        --tblr-card-border-radius: var(--tblr-border-radius);
        --tblr-card-box-shadow: var(--tblr-shadow-card);
        --tblr-card-inner-border-radius: calc(var(--tblr-border-radius) -(var(--tblr-border-width)));
        --tblr-card-cap-padding-y: 1.25rem;
        --tblr-card-cap-padding-x: 1.25rem;
        --tblr-card-cap-bg: var(--tblr-bg-surface-tertiary);
        --tblr-card-cap-color: inherit;
        --tblr-card-height: ;
        --tblr-card-color: inherit;
        --tblr-card-bg: white;
        --tblr-card-img-overlay-padding: 1rem;
        --tblr-card-group-margin: 1.5rem;
        position: relative;
        display: flex;
        flex-direction: column;
        min-width: 0;
        height: var(--tblr-card-height);
        color: var(--tblr-body-color);
        word-wrap: break-word;
        background-color: var(--tblr-card-bg);
        background-clip: border-box;
        border: var(--tblr-card-border-width) solid var(--tblr-card-border-color);
        border-radius: var(--tblr-card-border-radius);
        box-shadow: var(--tblr-card-box-shadow);
        margin-top:20px;
        width:unset;
    }
    #checkout {
        margin-bottom:0px;
    }

    .stripe-promo-form {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        background-color:#FFFFFF;
        border:none;
        max-height:100%;
    }

    @media (min-width: 500px) {
        .stripe-promo-form {
            padding:50px;
        }
        .stripe-promo-form > div {
            padding:0px;
            width:500px;
        }
        .alert p {
            padding: 10px;
        }
    }

    @media (max-width: 500px) {
        body {
            overflow-x: hidden;
        }
        .stripe-promo-form {
            padding:0px;
            padding-bottom:20px;
        }
        .stripe-promo-form > div, .stripe-promo-form #checkout{

            margin:0px;
            padding:0 20px;
        }
        .Tab {
            min-width: 150px;
        }
        .alert .fa-check, .alert .btn-close {
            display:none;
        }
        .alert {
            padding: 10px 15px;
            margin-bottom: 20px !important;
        }
        .alert p {
            padding: 10px 0px;
        }
    }
</style>

<!--<input type="hidden" name="cardholder_name" value="--><?php //= $name ?><!--" />-->
<!--<input type="hidden" name="receipt_email" value="--><?php //= $email ?><!--" />-->
<input type="hidden" id="amountTotal" name="amountTotal" value="100" />
<input type="hidden" id="amountSubTotal" name="amountSubTotal" value="100" />
<input type="hidden" id="amountFees" name="amountFees" value="0" />
<input type="hidden" id="amountDiscount" name="amountDiscount" value="0" />
<!-- Add hidden fields to store values for form submission -->
<?php //= Html::hiddenInput('amountSubTotal', '0') ?>
<?php //= Html::hiddenInput('amountFees', '0') ?>
<?php //= Html::hiddenInput('amountTotal', '0') ?>





<div class="stripe-promo-form">
    <div class="text-center mb-4">
        <img src="/static_files/uploads/app/site/thinlogoblack.png" style="max-height:40px;">
    </div>

    <?= Alert::widget() ?>

        <div style="font-size:1.5rem;font-weight:bold;padding-bottom:20px;">
            Manual Payment Details
        </div>
        <div class="payment_alert">
            Payment encountered an unexpected error. Please try another payment method or contact support for additional help.
        </div>
        <div style="margin-bottom:20px;">
            <?= $form->field($validationModel, 'full_name', ['inputOptions' => ['name' => 'cardholder_name']])->label('Full Name', ['class' => 'checkout-title has-star', 'style' => 'flex-basis:100%;font-weight:bold;padding-bottom:20px;']) ?>
        </div>
        <div style="margin-bottom:20px;">
            <?= $form->field($validationModel, 'email_address', ['inputOptions' => ['name' => 'receipt_email']])->label('Email Address', ['class' => 'checkout-title has-star', 'style' => 'flex-basis:100%;font-weight:bold;padding-bottom:20px;']) ?>
        </div>
        <div id="manual-payment" style="margin-bottom:20px;">
            <?= $form->field($validationModel, 'manual_payment_amount', ['inputOptions' => ['name' => 'manualAmount','onkeyup' => 'updateFeeTable()','id' => 'manual-payment-amount']])->label('Manual Payment Amount', ['class' => 'checkout-title has-star', 'style' => 'flex-basis:100%;font-weight:bold;padding-bottom:20px;']) ?>


            <!-- Update the fee breakdown table -->
            <div class="mt-3" id="fee-breakdown" style="display:none;">
                <table class="table table-bordered">
                    <tbody>
                        <tr>
                            <td>Subtotal</td>
                            <td class="text-end" id="subtotal-amount">$0.00</td>
                        </tr>
                        <tr>
                            <td>Fees</td>
                            <td class="text-end" id="fee-amount">$0.00</td>
                        </tr>
                        <tr id="ach-discount-row" style="display:none;">
                            <td>ACH Discount</td>
                            <td class="text-end" id="ach-discount-amount">$0.00</td>
                        </tr>
                        <tr class="table-active fw-bold">
                            <td>Total</td>
                            <td class="text-end" id="total-amount">$0.00</td>
                        </tr>
                    </tbody>
                </table>
            </div>

<!--            <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">-->
<!--                Manual Payment Amount-->
<!--            </div>-->
<!---->
<!--            --><?php //= Html::textInput('manualAmount', null, ['class' => 'form-control']) ?>
        </div>

        <div id="payment-options" style="margin-bottom:20px;">
            <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                Select Payment Option
            </div>

            <div role="tablist" aria-label="Payment Options" aria-orientation="horizontal" class="p-PaymentMethodSelector">
                <button type="button" id="pay-now" class="p-Tab Tab Tab--selected" onclick="updatePaymentOptionButton('full')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon p-TabIcon--selected" fill="#000000" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M16 0c-8.836 0-16 7.163-16 16s7.163 16 16 16c8.837 0 16-7.163 16-16s-7.163-16-16-16zM16 30.032c-7.72 0-14-6.312-14-14.032s6.28-14 14-14 14 6.28 14 14-6.28 14.032-14 14.032zM22.386 10.146l-9.388 9.446-4.228-4.227c-0.39-0.39-1.024-0.39-1.415 0s-0.391 1.023 0 1.414l4.95 4.95c0.39 0.39 1.024 0.39 1.415 0 0.045-0.045 0.084-0.094 0.119-0.145l9.962-10.024c0.39-0.39 0.39-1.024 0-1.415s-1.024-0.39-1.415 0z"></path> </g></svg>
                    </div>
                    <span class="p-TabLabel TabLabel">Pay Now</span>
                </button>
            </div>
        </div>

        <div id="payment-methods" style="margin-bottom:20px;">
            <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                Select Payment Method
            </div>

            <div role="tablist" aria-label="Payment Methods" aria-orientation="horizontal" class="p-PaymentMethodSelector">
                <button type="button" id="ach" class="p-Tab Tab Tab--selected" onclick="updatePaymentMethodButton('ach')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon p-TabIcon--selected"  viewBox="0 0 24 24" fill="var(--colorIcon)" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M3 21.0001H21M4 18.0001H20M6 18.0001V13.0001M10 18.0001V13.0001M14 18.0001V13.0001M18 18.0001V13.0001M12 7.00695L12.0074 7.00022M21 10.0001L14.126 3.88986C13.3737 3.2212 12.9976 2.88688 12.5732 2.75991C12.1992 2.64806 11.8008 2.64806 11.4268 2.75991C11.0024 2.88688 10.6263 3.2212 9.87404 3.88986L3 10.0001H21Z" stroke="var(--colorIcon)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                    </div>
                    <span class="p-TabLabel TabLabel">ACH Transfer</span>

                </button>
                <button type="button" id="card" class="p-Tab Tab" onclick="updatePaymentMethodButton('card')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon" role="presentation" fill="var(--colorIcon)" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 4a2 2 0 012-2h12a2 2 0 012 2H0zm0 2v6a2 2 0 002 2h12a2 2 0 002-2V6H0zm3 5a1 1 0 011-1h1a1 1 0 110 2H4a1 1 0 01-1-1z"></path></svg>
                    </div>
                    <span class="p-TabLabel TabLabel TabLabel--selected">Card</span>
                </button>

            </div>
        </div>

        <div id="checkout">
            <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                Payment Details
            </div>
            <div id="full-ach" class="showSection">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="ach-payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div id="full-card">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div id="subscribe-ach">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="subscription-ach-payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div id="subscribe-card">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="subscription-payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div>
                <button id="submitPaymentButton" type="submit" class="btn btn-primary has-spinner" style="width:100%;">Submit Payment</button>
            </div>
        </div>
</div>

<?php ActiveForm::end(); ?>

<script>

    (function($) {
        $.fn.buttonLoader = function(action) {
            var self = $(this);
            //start loading animation
            if (action == 'start') {
                if ($(self).attr("disabled") == "disabled") {
                    e.preventDefault();
                }
                //disable buttons when loading state
                $('.has-spinner').attr("disabled", "disabled");
                $(self).attr('data-btn-text', $(self).text());
                //binding spinner element to button and changing button text
                $(self).html('<span class="spinner"><i class="fa fa-spinner fa-spin"></i></span>Loading');
                $(self).addClass('active');
            }
            //stop loading animation
            if (action == 'stop') {
                $(self).html($(self).attr('data-btn-text'));
                $(self).removeClass('active');
                //enable buttons after finish loading
                $('.has-spinner').removeAttr("disabled");
            }
        }
    })(jQuery);

    var formEl;

    $(document).ready(function(){
        formEl = $("form");

        // $('input[name=manualAmount]').on('change',function(e){
        //     $('#amountTotal').val($(this).val() * 100);
        //     $('#amountSubTotal').val($(this).val() * 100);
        // });

        $('#submitPaymentButton').click(function() {
            var btn = $(this);
            $(btn).buttonLoader('start');
            // setTimeout(function() {
            //     $(btn).buttonLoader('stop');
            // }, 3000);
        });

        var element = $('input[name=cardholder_name]');
        element.trigger("change");
    });
</script>

<!-- Update the JavaScript for calculations -->
<?php $this->registerJs(<<<JS
    function updateFeeTable() {
        const amount = parseFloat($('#manual-payment-amount').val()) || 0;
        if (amount <= 0) {
            $('#fee-breakdown').hide();
            return;
        }
        
        // Get selected payment method
        const isACH = $("#payment-methods").find("#ach").hasClass("Tab--selected");
        
        // Calculate fees based on payment method
        let feePercent, feeFixed;
        feePercent = Math.round(amount * 0.0338 * 100); // Convert to cents
        feeFixed = 0;
        
        if (isACH) {
            $('#ach-discount-row').show();
        } else {
            $('#ach-discount-row').hide();
        }
        
        const totalFee = feePercent + feeFixed;
        const achDiscount = isACH ? Math.round(amount * 0.0238 * 100) : 0; // 2% discount for ACH in cents
        const total = Math.round(amount * 100) + totalFee - achDiscount; // All in cents
        
        // Update table values (display in dollars)
        $('#subtotal-amount').text('$' + (amount).toFixed(2));
        $('#fee-amount').text('$' + (totalFee/100).toFixed(2));
        $('#ach-discount-amount').text('-$' + (achDiscount/100).toFixed(2));
        $('#total-amount').text('$' + (total/100).toFixed(2));
        
        // Show the table
        $('#fee-breakdown').show();
        
        // Update hidden fields for form submission (in cents)
        $('input[name="amountSubTotal"]').val(Math.round(amount * 100));
        $('input[name="amountFees"]').val(totalFee);
        $('input[name="amountDiscount"]').val(achDiscount);
        $('input[name="amountTotal"]').val(total);
    }
JS
    , View::POS_HEAD
);

$this->registerJs('
    // Add event listeners for payment method changes
    $(document).ready(function() {
        $("#payment-methods button").click(function() {
            updateFeeTable();
        });
        updateFeeTable(); // Initial calculation on page load
        
        $("#submitPaymentButton").prop("disabled", true);
        
        $("input[name=\'cardholder_name\']").on("input", validateForm);
        $("input[name=\'receipt_email\']").on("input", validateForm);
        $("#manual-payment-amount").on("input", validateForm);
        
        validateForm();
    });
');


?>

