<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\ArrayHelper;
use app\helpers\EventHelper;
use app\modules\addons\modules\stripe\helpers\Client;
use app\modules\addons\modules\stripe\models\Stripe;
use app\modules\addons\modules\stripe\models\StripeItem;
use app\modules\addons\modules\stripe\models\StripeCoupon;
use kartik\date\DatePicker;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\stripe\models\Stripe */
/* @var $itemModel app\modules\addons\modules\stripe\models\StripeItem */
/* @var $formModel \app\models\Form */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

$itemModel2 = new StripeItem();
$couponModel = new StripeCoupon();

$url = Url::to(['/form/fields']);
$stripeFieldsUrl = Url::to(['/form/stripe-fields']);
$currencyUrl = Url::to(['/form/currency-fields']);

$this->registerJsFile('/static_files/js/fontawesome-iconpicker.js');
$this->registerCssFile('/static_files/css/fontawesome-iconpicker.min.css');

$this->registerJs('

// Create instance if not exists (returns a jQuery object)
$(\'.my\').iconpicker();
//$(\'.my\').iconpicker({ /*options*/ }); // you can also specify options via data-* attributes

// For the first matched element, access to a plugin property value
//$(\'.my\').data(\'iconpicker\').iconpickerUpdated;

// For the first matched element, call a plugin instance method with the given args
//$(\'.my\').data(\'iconpicker\').iconpickerMethod(\'methodArg1\', \'methodArg2\' /* , other args */);

// Call and apply a plugin method to EACH matched element.
//$.iconpicker.batch(\'.my\', \'iconpickerMethod\', \'methodArg1\', \'methodArg2\' /* , other args */);
$(\'.icp-dd\').iconpicker({
});
');

?>
<style>
    legend {
        border-top:var(--tblr-card-border-width) solid var(--tblr-border-color-translucent);;
        display: block;
        padding-top:20px;
        font-size: 1rem;
        font-weight: var(--tblr-font-weight-medium);
        color: inherit;
        line-height: 1.5rem;
    }
     .table-striped>tbody>tr>*,.table tr td, .table tr {
         --tblr-table-accent-bg: transparent !important;
         --tblr-table-striped-bg: transparent !important;
     }
    .table tr:hover {
        background-color: rgba(6,64,43,0.1);
        cursor:pointer;
    }
</style>
<script>
    function generatePaymentSchedule() {
        var numberInstallments = $('#stripe-num_installments').val();
        var paymentFrequency = $('#stripe-installment_interval').val();
        var depositRule = $('#stripe-deposit_rule').val();
        var customDepositAmount = $('#stripe-custom_deposit_amount').val();
        var total = $('#stripe-sampletotal').val();

        var dt = new Date();
        var tripDate = $('#stripe-trip_date').val();
        if (tripDate) {
            var tripDt = new Date(tripDate);
            
            // Calculate days between now and trip date
            var diffTime = Math.abs(tripDt - dt);
            var diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
            
            // Calculate max possible installments based on payment frequency
            var maxInstallments = 1; // Start with 1 for initial payment
            
            if (paymentFrequency == 'day') {
                maxInstallments += diffDays;
            }
            else if (paymentFrequency == 'week') {
                maxInstallments += Math.floor(diffDays / 7);
            }
            else if (paymentFrequency == '2weeks') {
                maxInstallments += Math.floor(diffDays / 14); 
            }
            else if (paymentFrequency == '3weeks') {
                maxInstallments += Math.floor(diffDays / 21);
            }
            else if (paymentFrequency == '4weeks') {
                maxInstallments += Math.floor(diffDays / 28);
            }
            else if (paymentFrequency == 'month') {
                maxInstallments += Math.floor(diffDays / 30);
            }
            
            // Cap at selected number of installments
            numberInstallments = Math.min(numberInstallments, maxInstallments);
        }
        var denominator = (depositRule == 'default' ? numberInstallments : numberInstallments - 1);


        console.log('generating payment schedule');
        console.log(numberInstallments);

        var html = "";

        html += '<table class="table-vcenter card-table kv-grid-table table table-striped" style="width:unset;border-style:solid;border-width:2px;margin:20px;">';
        html += '<thead class="kv-table-header form-grid">';
        html += '<tr>';
        html += '<th style="width:200px;">Payment Number</th>';
        html += '<th style="width:200px;" class="kv-align-center kv-nowrap kv-align-middle">Payment Amount</th>';
        html += '<th style="width:200px;" class="kv-align-center kv-nowrap kv-align-middle">Sample Amount</th>';
        html += '<th style="width:400px;" class="kv-nowrap" data-col-seq="4">Date</th>';
        html += '<th style="width:200px;" class="kv-nowrap" data-col-seq="4">Sample Date</th>';
        html += '</thead>';

        html += '<tbody>';

        html += '<tr class="form-grid">';
        html += '<td class="skip-export kv-align-center kv-align-middle form-grid" style="width:100px;" data-col-seq="7">First Payment</td>';
        if (depositRule == 'default')
            html += '<td>Checkout Total / ' + denominator + '</td>';
        else
            html += '<td>Custom Initial Deposit</td>';
        if (depositRule == 'default')
            html += '<td>$' + total / denominator + '</td>';
        else
            html += '<td>$' + customDepositAmount + '</td>';
        html += '<td>Paid at Checkout</td>';
        html += '<td>Today</td>'
        html += '</tr>';

        if (numberInstallments >= 2) {
            var interval = '';
            if (paymentFrequency == 'day') {
                interval = '1 Day';
                dt.setDate(dt.getDate() + 1);
            }
            else if (paymentFrequency == 'week') {
                interval = '1 Week';
                dt.setDate(dt.getDate() + 7);
            }
            else if (paymentFrequency == '2weeks') {
                interval = '2 Weeks';
                dt.setDate(dt.getDate() + 14);
            }
            else if (paymentFrequency == '3weeks') {
                interval = '3 Weeks';
                dt.setDate(dt.getDate() + 21);
            }
            else if (paymentFrequency == '4weeks') {
                interval = '4 Weeks';
                dt.setDate(dt.getDate() + 28);
            }
            else if (paymentFrequency == 'month') {
                interval = '1 Month';
                dt.setDate(dt.getDate() + 30);
            }

            html += '<tr class="form-grid">';
            html += '<td class="skip-export kv-align-center kv-align-middle form-grid" style="width:100px;" data-col-seq="7">Second Payment</td>';
            if (depositRule == 'default')
                html += '<td>Checkout Total / ' + denominator + '</td>';
            else
                html += '<td>(Checkout Total - Initial Deposit) / ' + denominator + '</td>';
            if (depositRule == 'default')
                html += '<td>$' + total / denominator + '</td>';
            else
                html += '<td>$' + (total - customDepositAmount) / denominator + '</td>';
            html += '<td>Automatically Paid ' + interval + ' After Checkout</td>';
            html += '<td>' + dt.toLocaleDateString() + '</td>';



            html += '</tr>';
        }

        if (numberInstallments >= 3) {
            var interval = '';
            if (paymentFrequency == 'day') {
                interval = '2 Days';
                dt.setDate(dt.getDate() + 1);
            }
            else if (paymentFrequency == 'week') {
                interval = '2 Weeks';
                dt.setDate(dt.getDate() + 7);
            }
            else if (paymentFrequency == '2weeks') {
                interval = '4 Weeks';
                dt.setDate(dt.getDate() + 14);
            }
            else if (paymentFrequency == '3weeks') {
                interval = '6 Weeks';
                dt.setDate(dt.getDate() + 21);
            }
            else if (paymentFrequency == '4weeks') {
                interval = '8 Weeks';
                dt.setDate(dt.getDate() + 28);
            }
            else if (paymentFrequency == 'month') {
                interval = '2 Months';
                dt.setDate(dt.getDate() + 30);
            }

            html += '<tr class="form-grid">';
            html += '<td class="skip-export kv-align-center kv-align-middle form-grid" style="width:100px;">Third Payment</td>';
            if (depositRule == 'default')
                html += '<td>Checkout Total / ' + denominator + '</td>';
            else
                html += '<td>(Checkout Total - Initial Deposit) / ' + denominator + '</td>';
            if (depositRule == 'default')
                html += '<td>$' + total / denominator + '</td>';
            else
                html += '<td>$' + (total - customDepositAmount) / denominator + '</td>';
            html += '<td>Automatically Paid ' + interval + ' After Checkout</td>';
            html += '<td>' + dt.toLocaleDateString() + '</td>';
            html += '</tr>';
        }

        if (numberInstallments >= 4) {
            var interval = '';
            if (paymentFrequency == 'day') {
                interval = '3 Days';
                dt.setDate(dt.getDate() + 1);
            }
            else if (paymentFrequency == 'week') {
                interval = '3 Weeks';
                dt.setDate(dt.getDate() + 7);
            }
            else if (paymentFrequency == '2weeks') {
                interval = '6 Weeks';
                dt.setDate(dt.getDate() + 14);
            }
            else if (paymentFrequency == '3weeks') {
                interval = '9 Weeks';
                dt.setDate(dt.getDate() + 21);
            }
            else if (paymentFrequency == '4weeks') {
                interval = '12 Weeks';
                dt.setDate(dt.getDate() + 28);
            }
            else if (paymentFrequency == 'month') {
                interval = '3 Months';
                dt.setDate(dt.getDate() + 30);
            }

            html += '<tr class="form-grid">';
            html += '<td class="skip-export kv-align-center kv-align-middle form-grid" style="width:100px;" data-col-seq="7">Fourth Payment</td>';
            if (depositRule == 'default')
                html += '<td>Checkout Total / ' + denominator + '</td>';
            else
                html += '<td>(Checkout Total - Initial Deposit) / ' + denominator + '</td>';
            if (depositRule == 'default')
                html += '<td>$' + total / denominator + '</td>';
            else
                html += '<td>$' + (total - customDepositAmount) / denominator + '</td>';
            html += '<td>Automatically Paid ' + interval + ' After Checkout</td>';
            html += '<td>' + dt.toLocaleDateString() + '</td>';
            html += '</tr>';
        }

        if (numberInstallments == 5) {
            var interval = '';
            if (paymentFrequency == 'day') {
                interval = '4 Days';
                dt.setDate(dt.getDate() + 1);
            }
            else if (paymentFrequency == 'week') {
                interval = '4 Weeks';
                dt.setDate(dt.getDate() + 7);
            }
            else if (paymentFrequency == '2weeks') {
                interval = '8 Weeks';
                dt.setDate(dt.getDate() + 14);
            }
            else if (paymentFrequency == '3weeks') {
                interval = '12 Weeks';
                dt.setDate(dt.getDate() + 21);
            }
            else if (paymentFrequency == '4weeks') {
                interval = '16 Weeks';
                dt.setDate(dt.getDate() + 28);
            }
            else if (paymentFrequency == 'month') {
                interval = '4 Months';
                dt.setDate(dt.getDate() + 30);
            }

            html += '<tr class="form-grid">';
            html += '<td class="skip-export kv-align-center kv-align-middle form-grid" style="width:100px;" data-col-seq="7">Fifth Payment</td>';
            if (depositRule == 'default')
                html += '<td>Checkout Total / ' + denominator + '</td>';
            else
                html += '<td>(Checkout Total - Initial Deposit) / ' + denominator + '</td>';
            if (depositRule == 'default')
                html += '<td>$' + total / denominator + '</td>';
            else
                html += '<td>$' + (total - customDepositAmount) / denominator + '</td>';
            html += '<td>Automatically Paid ' + interval + ' After Checkout</td>';
            html += '<td>' + dt.toLocaleDateString() + '</td>';
            html += '</tr>';
        }

        html += '</tbody>';
        html += '</table>';

        $('#generatedPaymentSchedule').html(html);
    }

    function showPriceChoices(elem) {
        // alert($(elem).find(":selected").text());

        const val = $(elem).find(":selected").val();
        if (val == "") {
            $(elem).closest('fieldset').find("#values").html("");
            return;
        }

        $.get("/index.php?r=form/formatted-labels&row_num=" + $(elem).closest('fieldset').attr('id').replace("item_","") + "&form_id=<?= $formModel->id ?>&price_id=" + val,function(data){
            console.log(data);
            $(elem).closest('fieldset').find("#values").html(data);
            // $('#item_values').html(data);
        });
    }
</script>

<div class="stripe-form">

    <?php $form = ActiveForm::begin(); ?>

    <?php echo $form->errorSummary($model); ?>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'name')->textInput([
                'maxlength' => true,
                'readonly' => 'readonly',
            ])->label('Form Name') ?>
            <?= $form->field($model, 'form_id')->hiddenInput()->label(false) ?>

        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'payment_options')->widget(Select2::class, [
                'data' => ['full' => 'Pay Now', 'plan' => 'Pay in Installments', 'deposit' => 'Pay Deposit Only'],
                'options' => ['placeholder' => Yii::t('app', 'Select Payment Options...'), 'multiple' => true],
            ]); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'payment_methods')->widget(Select2::class, [
                'data' => ['ach' => 'ACH Transfer', 'card' => 'Card'],
                'options' => ['placeholder' => Yii::t('app', 'Select Payment Methods...'), 'multiple' => true],
            ]); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
<!--        <div class="col-sm-3" style="display:none;">-->
<!--            --><?php //= Html::hiddenInput('currency', $model->currency, ['id'=>'currency']) ?>
<!--            --><?php //= $form->field($model, 'currency')->widget(DepDrop::class, [
//                'type' => DepDrop::TYPE_SELECT2,
//                'pluginOptions' => [
//                    'depends' => ['stripe-form_id'],
//                    'placeholder' => Yii::t('app', 'Select...'),
//                    'url' => $currencyUrl,
//                    'initialize' => !$model->isNewRecord,
//                    'params'=>['currency'],
//                ]
//            ]) ?>
<!--        </div>-->
    </div>

    <div class="row">

        <div class="col-sm-6">
            <?= $form->field($model, 'description')->textInput(['maxlength' => true])->hint(Yii::t('app', 'Text which you can attach to a charge. Your receipt emails will include it.')) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'statement_descriptor')->textInput(['maxlength' => true])->hint(Yii::t('app', 'Up to 22 characters to be displayed on your customer\'s credit card statement.')) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12" style="display:flex;flex-wrap:wrap;column-gap:60px;">
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->environment = Stripe::TEST; } ?>
                <?= $form->field($model, 'environment')->widget(Select2::class, [
                    'data' => [
                        Stripe::TEST => ucfirst(Stripe::TEST),
                        Stripe::LIVE => ucfirst(Stripe::LIVE),
                    ],
                    'options' => ['placeholder' => Yii::t('app', 'Select an environment...')],
                ]); ?>
            </div>

<!--            <div>-->
<!--                --><?php //= $form->field($model, 'required')->widget(SwitchInput::class) ?>
<!--            </div>-->
<!--            <div>-->
<!---->
<!--                --><?php //= $form->field($model, 'deposit')->widget(SwitchInput::class) ?>
<!--            </div>-->
            <div>
                <?= $form->field($model, 'surcharge')->widget(SwitchInput::class) ?>
            </div>
            <div>
                <?= $form->field($model, 'enable_promo')->widget(SwitchInput::class) ?>
            </div>
<!--            <div>-->
<!---->
<!--                --><?php //= $form->field($model, 'checkout_summary')->widget(SwitchInput::class) ?>
<!--            </div>-->
<!--            <div class="col-sm-3">-->
<!--                --><?php //if ($model->isNewRecord) { $model->status = true; } ?>
<!--                --><?php //= $form->field($model, 'status')->widget(SwitchInput::class) ?>
<!--            </div>-->
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend>Payment Items</legend>
        </div>
    </div>
    
    <?php if ($model->isNewRecord || empty($model->items)): ?>

        <fieldset class="item" id="item_0">
            <div class="row">
                <div class="col-sm-4">
                    <?= $form->field($itemModel, '[0]description')->textInput([
                        'maxlength' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, '[0]price')->widget(DepDrop::class, [
                        'options' => ['onchange' => 'showPriceChoices(this)'],
                        'pluginOptions' => [
                            'depends' => ['stripe-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => Url::to(['/form/stripe-fields']),
                            'params'=>['stripe-item_1']
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, '[0]quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['stripe-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => Url::to(['/addons/stripe/admin/fields']),
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <div style="display:flex;column-gap:10px;align-items:end;">
                        <?= $form->field($itemModel, '[0]icon')->textInput([
                            'maxlength' => true,
                            'readonly' => 'readonly',
                            'style' => 'display:inline-block;flex-grow:1',
                            'class' => 'my form-control'
                        ]) ?>
                        <button type="button" class="mb-3 btn btn-primary iconpicker-component iconpicker-element" style="width:40px;height:40px;"><i class="fa fa-fw fa-heart"></i></button>
                    </div>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div id="values"></div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-4">
                    <?= $form->field($itemModel, 'description')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                        'options' => ['onchange' => 'showPriceChoices(this)'],
                        'pluginOptions' => [
                            'depends' => ['stripe-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $stripeFieldsUrl,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['stripe-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) {
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <div style="display:flex;column-gap:10px;align-items:end;">
                        <?= $form->field($itemModel, 'icon')->textInput([
                            'disabled' => true,
                            'readonly' => 'readonly',
                            'style' => 'display:inline-block;flex-grow:1',
                            'class' => 'my form-control'
                        ]) ?>
                        <button type="button" class="mb-3 btn btn-primary iconpicker-component iconpicker-element" style="width:40px;height:40px;"><i class="fa fa-fw fa-heart"></i></button>
                    </div>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div id="values"></div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item" id="item_<?= $i ?>">
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($item, '['.$i.']description')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-'.$i.'-price',
                            $item->price, ['id'=>'item-'.$i.'-price']) ?>
                        <?= $form->field($item, '['.$i.']price')->widget(DepDrop::class, [
                            'options' => ['onchange' => 'showPriceChoices(this)'],
                            'pluginOptions' => [
                                'depends' => ['stripe-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $stripeFieldsUrl,
                                'params'=>['item-'.$i.'-price'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-'.$i.'-quantity', $item->quantity, ['id'=>'item-'.$i.'-quantity']) ?>
                        <?= $form->field($item, '['.$i.']quantity')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['stripe-form_id'],
                                'initialize' => true,
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-'.$i.'-quantity'],
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <div style="display:flex;column-gap:10px;align-items:end;">
                            <?= $form->field($item, '['.$i.']icon')->textInput([
                                'maxlength' => true,
                                'readonly' => 'readonly',
                                'style' => 'display:inline-block;flex-grow:1',
                                'class' => 'my form-control'
                            ]) ?>
                            <button type="button" class="mb-3 btn btn-primary iconpicker-component iconpicker-element" style="width:40px;height:40px;"><i class="fa fa-fw fa-heart"></i></button>
                        </div>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
                <div id="values">
                <?php
                    $itemAmounts = $item->getAmounts();

                    $fields = ArrayHelper::filter($formModel->formData->getFields(), $item->price, 'name');
                    $key = array_key_first($fields);

                    if (count($fields) > 1) {
                        foreach ($fields as $field) {
                            echo '<div class="row mb-3">';
                            echo '<div class="col-sm-4"></div>';
                            echo '<div class="col-sm-2">' . Html::textInput('', $field['label'], ['readonly' => 'readyonly', 'class' => 'form-control']) . '</div>';
                            echo '<div class="col-sm-1">' . Html::textInput('StripeItem[' . $i . '][amounts][' . $field['id'] . ']', $itemAmounts[$field['id']] ?? '', ['class' => 'form-control', 'placeholder' => '$ Price']) . '</div>';
                            echo '</div>';
                        }
                    }
                ?>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-4">
                    <?= $form->field($itemModel, 'description')->textInput([
                        'maxlength' => true,
                        'disabled' => true,
                    ]) ?>
                </div>
                <div class="col-sm-3">
                    <?= Html::hiddenInput('item-price', '', ['id'=>'item-price']) ?>
                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                        'options' => ['onchange' => 'showPriceChoices(this)'],
                        'pluginOptions' => [
                            'depends' => ['stripe-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $stripeFieldsUrl,
                            'params'=>['item-price'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true);
                                console.log('dep changed');
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <?= Html::hiddenInput('item-quantity', '', ['id'=>'item-quantity']) ?>
                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['stripe-form_id'],
                            'initialize' => true,
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $url,
                            'params'=>['item-quantity'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) {
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-2">
                    <div style="display:flex;column-gap:10px;align-items:end;">
                        <?= $form->field($itemModel, 'icon')->textInput([
                            'disabled' => true,
                            'readonly' => 'readonly',
                            'style' => 'display:inline-block;flex-grow:1',
                            'class' => 'my form-control'
                        ]) ?>
                        <button type="button" class="mb-3 btn btn-primary iconpicker-component iconpicker-element" style="width:40px;height:40px;"><i class="fa fa-fw fa-heart"></i></button>
                    </div>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div id="values"></div>
        </fieldset>
    
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12">
            <p class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Notes') ?></span>
            </p>
            <ul class="help-block">
                <li><?= Yii::t(
                        'app',
                        'Specify in each item the information of your product or service.'
                    ) ?></li>
                <li><?= Yii::t(
                        'app',
                        'Checkout total will be calculated by selected price * quantity.'
                    ) ?></li>
            </ul>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend>Promo Codes</legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || empty($model->coupons)): ?>

    <fieldset class="promo" id="promo_0">
        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($couponModel, '[0]description')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($couponModel, '[0]code')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($couponModel, '[0]price')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-1">
                <button type="button" class="btn btn-icon btn-default btn-addpromo" style="margin-top: 28px;padding-left: 10px;padding-right: 10px;">
                    <i class="fas fa-plus" style="padding-right:10px;"></i> Add Promo Code
                </button>
            </div>
        </div>
    </fieldset>

    <?php else: ?>

        <?php foreach($model->coupons as $i => $coupon): ?>
            <fieldset class="item" id="promo_<?= $i ?>">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($coupon, '['.$i.']description')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($coupon, '['.$i.']code')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($coupon, '['.$i.']price')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-removepromo" style="margin-top: 28px;padding-left: 10px;padding-right: 10px;">
                            <i class="fas fa-minus" style="padding-right:10px;"></i> Remove Promo Code
                        </button>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

    <?php endif; ?>


    <fieldset id="promoTemplate" class="d-none">
        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($couponModel, 'description')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($couponModel, 'code')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($couponModel, 'price')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-1">
                <button type="button" class="btn btn-icon btn-default btn-removepromo" style="margin-top: 28px;padding-left: 10px;padding-right: 10px;">
                    <i class="fas fa-minus" style="padding-right:10px;"></i> Remove Promo Code
                </button>
            </div>
        </div>
    </fieldset>

    <div class="row">
        <div class="col-sm-12">
            <legend>Pay in Installments - Settings</legend>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'trip_date')->widget(DatePicker::class, [
                'options' => ['placeholder' => Yii::t('app', 'Select Trip Date')],
                'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'autoclose' => true,
                ]
            ])->label('Trip Date'); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'num_installments')->widget(Select2::class, [
                'data' => ['1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5'],
                'options' => ['placeholder' => Yii::t('app', 'Select Number of Installments')],
            ])->label('Number of Installments'); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'installment_interval')->widget(Select2::class, [
                'data' => ['day' => 'Every Day', 'week' => 'Every Week', '2weeks' => 'Every 2 Weeks', '3weeks' => 'Every 3 Weeks', '4weeks' => 'Every 4 Weeks', 'month' => 'Every Month'],
                'options' => ['placeholder' => Yii::t('app', 'Select Payment Frequency')],
            ])->label('Payment Frequency'); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'deposit_rule')->widget(Select2::class, [
                'data' => ['default' => 'Default Initial Payment', 'custom' => 'Custom Deposit as Initial Payment'],
                'options' => ['placeholder' => Yii::t('app', 'Select Deposit Rule')],
            ])->label('Deposit Rule'); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'custom_deposit_amount')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= Html::hiddenInput('custom_deposit_quantity', $model->custom_deposit_quantity, ['id'=>'custom_deposit_quantity']) ?>
            <?= $form->field($model, 'custom_deposit_quantity')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['custom_deposit_quantity'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'sampleTotal')->textInput([
                'maxlength' => true,
            ])->label('Sample Checkout Payment Total') ?>
        </div>
        <div class="col-sm-3" style="display:flex;align-items:center">
            <?= Html::button('Generate Sample Payment Schedule', ['class' => 'btn btn-primary', 'onclick' => 'generatePaymentSchedule()']) ?>
        </div>
    </div>

    <div class="row" id="generatedPaymentSchedule" style="justify-content: center">

    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Additional Fields') ?></legend>
        </div>
    </div>

    <?php if (!$model->isNewRecord): ?>
        <?= Html::hiddenInput('receipt_email', $model->receipt_email, ['id'=>'receipt_email']) ?>
        <?= Html::hiddenInput('cardholder_name', $model->cardholder_name, ['id'=>'cardholder_name']) ?>
        <?= Html::hiddenInput('address_line1', $model->address_line1, ['id'=>'address_line1']) ?>
        <?= Html::hiddenInput('address_line2', $model->address_line2, ['id'=>'address_line2']) ?>
        <?= Html::hiddenInput('address_city', $model->address_city, ['id'=>'address_city']) ?>
        <?= Html::hiddenInput('address_state', $model->address_state, ['id'=>'address_state']) ?>
        <?= Html::hiddenInput('address_zip', $model->address_zip, ['id'=>'address_zip']) ?>
        <?= Html::hiddenInput('address_country', $model->address_country, ['id'=>'address_country']) ?>
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'receipt_email')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['receipt_email'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'cardholder_name')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['cardholder_name'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3" style="display:none">
            <?= $form->field($model, 'address_line1')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_line1'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3" style="display:none">
            <?= $form->field($model, 'address_line2')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_line2'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
    </div>

    <div class="row" style="display:none;">
        <div class="col-sm-3">
            <?= $form->field($model, 'address_city')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_city'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'address_state')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_state'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'address_zip')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_zip'],
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'address_country')->widget(DepDrop::class, [
                'pluginOptions' => [
                    'depends' => ['stripe-form_id'],
                    'placeholder' => Yii::t('app', 'Select...'),
                    'url' => $url,
                    'params'=>['address_country'],
                    'initialize' => !empty($model->form_id),
                ],
                'pluginEvents' => [
                    "depdrop:afterChange" => "function(event, id, value) { 
                    }",
                ],
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
                <span class="help-block">
                    <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                    <?= Yii::t(
                        'app',
                        'Although these fields are optional, this information can be used to perform a number of verifications, such as CVC, ZIP, and address verification. Also, we will use the Receipt Email to prefill the customer email on the Checkout page.'
                    ) ?>
                </span>
        </div>
    </div>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Enable Payments') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Field Mapping
 */

if ($model->isNewRecord) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .attr('id', 'item_' + item)
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="StripeItem[description]"]')
                    .attr('name', 'StripeItem[' + item + '][description]')
                    .attr('id', 'stripeitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="StripeItem[price]"]')
                    .attr('name', 'StripeItem[' + item + '][price]')
                    .attr('id', 'stripeitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['stripe-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="StripeItem[quantity]"]')
                    .attr('name', 'StripeItem[' + item + '][quantity]')
                    .attr('id', 'stripeitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['stripe-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="StripeItem[icon]"]')
                    .attr('name', 'StripeItem[' + item + '][icon]')
                    .attr('id', 'stripeitem-' + item + '-icon')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });
    
    // Subscription settings
    $('#stripe-subscription').on('init.bootstrapSwitch', function(event, state) {
        if (this.checked) {
            $('.subscription-settings').show();
        } else {
            $('.subscription-settings').hide();
        }
    });
})

JS;

} else {


    $script = <<<JS

$(window).on('load', function() {
    $('#stripe-form_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');
    
    $('#promo_0').find('.btn-removepromo').removeClass('btn-removepromo').addClass('btn-addpromo')
        .html('<i class="fas fa-plus" style="padding-right:10px;"></i> Add Promo Code');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .attr('id', 'item_' + item)
                    .insertBefore(template);

            // Update the name attributes
            cloned
                .find('[name="StripeItem[description]"]')
                    .attr('name', 'StripeItem[' + item + '][description]')
                    .attr('id', 'stripeitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="StripeItem[price]"]')
                    .attr('name', 'StripeItem[' + item + '][price]')
                    .attr('id', 'stripeitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['stripe-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-price')
                    .attr('name', 'item-' + item + '-price')
                    .attr('id', 'item-' + item + '-price')
                    .end()
                .find('[name="StripeItem[quantity]"]')
                    .attr('name', 'StripeItem[' + item + '][quantity]')
                    .attr('id', 'stripeitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['stripe-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('#item-quantity')
                    .attr('name', 'item-' + item + '-quantity')
                    .attr('id', 'item-' + item + '-quantity')
                    .end()
                .find('[name="StripeItem[icon]"]')
                    .attr('name', 'StripeItem[' + item + '][icon]')
                    .attr('id', 'stripeitem-' + item + '-icon')
                    .removeAttr('disabled')
                    .end()

            $('.my').iconpicker();


            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        })
        .on('click', '.btn-addpromo', function() {
            var template = $('#promoTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('promo')
                    .attr('id', 'promo_' + item)
                    .insertBefore(template);
            
            cloned
                .find('[name="StripeCoupon[description]"]')
                    .attr('name', 'StripeCoupon[' + item + '][description]')
                    .attr('id', 'stripecoupon-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="StripeCoupon[code]"]')
                    .attr('name', 'StripeCoupon[' + item + '][code]')
                    .attr('id', 'stripecoupon-' + item + '-code')
                    .removeAttr('disabled')
                    .end()
                .find('[name="StripeCoupon[price]"]')
                    .attr('name', 'StripeCoupon[' + item + '][price]')
                    .attr('id', 'stripecoupon-' + item + '-price')
                    .removeAttr('disabled')
                    .end()
        })
        .on('click', '.btn-removepromo', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });
    
    // Subscription settings
    $('#stripe-subscription').on('init.bootstrapSwitch', function(event, state) {
        if (this.checked) {
            $('.subscription-settings').show();
        } else {
            $('.subscription-settings').hide();
        }
    });
});

JS;
}

$this->registerJs($script, $this::POS_END);

?>

