<?php

use app\helpers\ArrayHelper;
use app\helpers\Html;
use app\helpers\IconHelper;
use app\models\Form;
use app\models\FormSubmission;
use app\modules\addons\modules\stripe\models\Stripe;
use app\modules\addons\modules\stripe\models\StripePayment;
use app\modules\addons\modules\stripe\models\StripePaymentSearch;
use yii\helpers\StringHelper;
use yii\helpers\Url;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $startDate string */
/* @var $endDate string */
/* @var $client_secret string */

$this->title = Yii::t('app', 'Stripe Payouts');

$publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);

?>
<script src="https://connect-js.stripe.com/v1.0/connect.js" async></script>
<script>
    window.StripeConnect = window.StripeConnect || {};

    StripeConnect.onLoad = () => {
        const stripeConnectInstance = StripeConnect.init({
            // This is your test publishable API key.
            publishableKey: "<?= $publishableKey ?>",
            clientSecret: "<?= $client_secret ?>",
            appearance: {
                variables: {
                    spacingUnit: "14px",
                    fontFamily: "avenir",
                },
            },
        });
        const balances = stripeConnectInstance.create('balances');
        $('#balances').append(balances);

        const payoutsList = stripeConnectInstance.create('payouts-list');
        $('#payoutsList').append(payoutsList);

    };
</script>

    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?= Yii::t('app', 'Overview') ?>
                    </div>
                    <h2 class="page-title">
                        <?= $this->title ?>
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-deck row-cards">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="p-4" id="balances">

                            </div>
                            <div id="payoutsList">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>

