<?php

use app\components\widgets\GridView;
use app\helpers\ArrayHelper;
use app\helpers\Html;
use app\helpers\IconHelper;
use app\models\Form;
use app\models\FormSubmission;
use app\modules\addons\modules\stripe\models\Stripe;
use app\modules\addons\modules\stripe\models\StripePayment;
use app\modules\addons\modules\stripe\models\StripePaymentSearch;
use yii\helpers\StringHelper;
use yii\helpers\Url;
use yii\web\View;
use yii\bootstrap5\Modal;

/* @var $this yii\web\View */
/* @var $startDate string */
/* @var $endDate string */
/* @var $client_secret string */

$this->title = Yii::t('app', 'Stripe Payments');

$publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);

?>


<style>
    .table tr:nth-child(even){
        background-color: #F4F8FB;
    }
    .table tr:nth-child(odd){
        background-color: white;
    }
    .table tr:hover {
        background-color: #D6E2EC;
        cursor:pointer;
    }
    .table tr td {
        background-color:inherit !important;
        border:none;
    }

    input[type=date] {
        -moz-appearance: none; -webkit-appearance: none; appearance: none;
    }

    .table>* {
        box-shadow:none;
    }

    .table {
        border-radius: 8px;
        border: 1px solid #dddee4;
        box-shadow: 0px 1px 4px rgba(19,126,199,0.2);
        border-spacing: 0;
        border-collapse: inherit;
        display: block;
        overflow-x: auto;
        white-space: nowrap;
    }

    .table th {
        background-color: #152b4b;
        padding:15px 15px 15px 0.5rem;
        font-weight:normal;
        border:none;
    }

    .table th a, .table th {
        color:white;
        text-decoration:none;
    }

    .table tr th:last-child {
        border-top-right-radius: 8px;
    }

    .table tr:last-child td:last-child {
        border-bottom-right-radius: 8px;
    }

    .table tr th:first-child {
        border-top-left-radius: 8px;
    }

    .table tr:last-child td:first-child {
        border-bottom-left-radius: 8px;
    }

    .table tr td:first-child, .table tr th:first-child {
        padding-left:20px;
    }

    .table tr td:last-child, .table tr th:last-child {
        padding-right:25px;
    }

    .table td {
        vertical-align:middle;
    }

    .select2-container .select2-selection--multiple .select2-selection__rendered {
        white-space: normal;
    }

    .table tr:nth-child(even) td {
        background-color: #F4F8FB;
    }
    .markdown>table>:not(caption)>*>*,.table>:not(caption)>*>* {
        box-shadow:none;
    }
    .modal-title {
        width: 100%;
    }
</style>

    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?= Yii::t('app', 'Overview') ?>
                    </div>
                    <h2 class="page-title">
                        <?= $this->title ?>
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-deck row-cards">

                <?= $this->render('_search', ['model' => $searchModel, 'dataProvider' => $dataProvider]) ?>

                <?php Modal::begin([
                    'id' => 'payment-details-modal',
                    'size' => 'modal-lg',
                    'title' => 'Payment Details',
                ]); ?>
                <div id="payment-details-content"></div>
                <?php Modal::end(); ?>

                <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'export' => false,
                                'tableOptions' => ['class' => 'table', 'style' => ''],
                                'layout' => '{items}{pager}{summary}',
                                'pager' => ['linkOptions' => ['class' => 'button']],
                                'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                                'rowOptions' => function ($model) {
                                    return [
                                        'id' => $model['id'],
                                        'onclick' => 'showPaymentDetails(' . $model['id'] .',' . $model['form_id'] . ',' . $model['submission_id'] . ',' . (Yii::$app->user->can("refundPayments", ['model' => $model['form_id']]) && $model['status'] == 'Complete' && str_starts_with($model['payment_id'], "pi_") ? 'true' : 'false') . ', "' . $model->total . '")'
                                    ];
                                },
                                'columns' => [
                                    [
                                        'attribute' => 'created_at',
                                        'contentOptions'=> ['style' => 'width:150px;'],
                                        'format' => 'html',
                                        'label' => 'Payment Date',
                                        'value' => function ($model) {
                                            return Yii::$app->formatter->asDate($model->created_at,  'php:m/d/Y') . '<br />' .
                                                Yii::$app->formatter->asDate($model->created_at, 'php:h:i a');
                                        }
                                    ],
                                    [
                                        'attribute' => 'form.name',
                                        'value' => function ($model) {
                                            return empty($model->form->name) ? 'Manual Payment' : $model->form->name;
                                        }
                                    ],
                                    [
                                        'attribute' => 'payment_method',
                                        'contentOptions'=> ['style' => 'width:150px;'],
                                        'value' => function ($model) {
                                            return $model->payment_method == 'us_bank_account' ? 'ACH' : ucfirst($model->payment_method ?? '');
                                        },
                                    ],
                                    'customer_name',
                                    'customer_email',
                                    [
                                        'label' => 'Total',
                                        'headerOptions' => ['style' => 'text-align:right;padding-right:20px;'],
                                        'contentOptions'=> ['style' => 'text-align: right;padding-right:20px;'],
                                        'value' => function ($model) {
                                            return Yii::$app->formatter->asCurrency($model->subtotal / 100.0);
                                        },
                                        'attribute' => 'subtotal',
                                    ],
                                    [
                                        'label' => 'Fees',
                                        'headerOptions' => ['style' => 'text-align:right;padding-right:20px;'],
                                        'contentOptions'=> ['style' => 'text-align: right;padding-right:20px;'],
                                        'value' => function ($model) {
                                            return Yii::$app->formatter->asCurrency(($model->total - $model->subtotal) / 100.0);
                                        },
                                        'attribute' => 'fees',
                                    ],
                                    [
                                        'format' => 'html',
                                        'label' => 'Status',
                                        'value' => function ($model) {
                                            return '<span style="' . (in_array($model->status, ['Complete','Processing']) ? 'color:green' : ($model->status == 'Failed' ? 'color:red;' : 'color:darkorange')) . '">' . $model->status . '</span>';
                                        },
                                        'attribute' => 'status',
                                    ],
                                ],
                            ]); ?>

            </div>
        </div>

    </div>

<?php


    $js = <<<JS
function showPaymentDetails(id, form_id, submission_id, canRefund, amount) {
    $.get('index.php?r=dashboard/payment-details&id=' + id, function(data) {
        $('#payment-details-content').html(data);
        
        var refundText = '';
        var refundUrl = 'index.php?r=form/refund&id=' + form_id + '&submission_id=' + submission_id +  '&stripe_payment_id=' + id;
        if (canRefund) {
            refundText += ' <a style="color:red; float:right;" href="javascript:;" onclick="showRefundConfirm(\'' + refundUrl + '\', \'' + amount + '\')">Refund Payment</a>';
        }
        $('#payment-details-modal .modal-title').html('Payment Details' + refundText);
        
        $('#payment-details-modal').modal('show');
    });
}

function showRefundConfirm(refundUrl, amount) {
    // Create confirmation modal if it doesn't exist
    if (!$('#refund-confirm-modal').length) {
        // Convert amount from cents to dollars
        const amountInDollars = (parseInt(amount.replace(/[^0-9]/g, '')) / 100).toFixed(2);
        
        $('body').append(`
            <div class="modal-backdrop fade show" id="refund-backdrop" style="z-index:1059"></div>
            <div class="modal fade" id="refund-confirm-modal" tabindex="-1" style="z-index:1060">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Confirm Refund</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label class="form-label">Refund Amount (Max: $` + amountInDollars + `)</label>
                                <input type="number" class="form-control" id="refund-amount" 
                                    min="0" max="` + amountInDollars + `" 
                                    step="0.01" value="` + amountInDollars + `">
                            </div>
                            <div>Are you sure you want to proceed with this refund?</div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button onclick="$.post('` + refundUrl + `&amount=' + $('#refund-amount').val())" class="btn btn-danger">Refund</button>
                        </div>
                    </div>
                </div>
            </div>
        `);
    }
    
    // Show confirmation modal
    const modal = new bootstrap.Modal($('#refund-confirm-modal'));
    modal.show();
    
    // Remove backdrop when modal is hidden
    $('#refund-confirm-modal').on('hidden.bs.modal', function () {
        $('#refund-backdrop').remove();
    });
}

JS;
    $this->registerJs($js, View::POS_HEAD);


?>
