<?php

/* @var $client_secret string */


use app\modules\addons\modules\stripe\models\Stripe;
use yii\helpers\Html;
use kartik\grid\GridView;
use yii\helpers\Url;

$this->title = 'Payout Information';

$publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);


// Add this JavaScript at the top of the file
$this->registerJs(<<<JS
    // Function to load balance transactions
    function loadBalanceTransactions(payoutId) {
        $.get('index.php?r=dashboard/get-balance-transactions', { payout_id: payoutId }, function(response) {
            $('#balanceTransactionsGrid').html(response);
            $('#transactionsModal').modal('show');
        });
    }

    // Add click handler to table rows
    $('.payout-row').on('click', function() {
        const payoutId = $(this).data('payout-id');
        loadBalanceTransactions(payoutId);
    });
JS
);
?>
<script src="https://connect-js.stripe.com/v1.0/connect.js" async></script>
<script>
    window.StripeConnect = window.StripeConnect || {};

    StripeConnect.onLoad = () => {
        const stripeConnectInstance = StripeConnect.init({
            // This is your test publishable API key.
            publishableKey: "<?= $publishableKey ?>",
            clientSecret: "<?= $client_secret ?>",
            appearance: {
                variables: {
                    spacingUnit: "14px",
                    fontFamily: "avenir",
                },
            },
        });
        const balances = stripeConnectInstance.create('balances');
        $('#balances').append(balances);

    };
</script>
<style>
    .grid-view {
        width:100%;
    }
    .table tr:nth-child(even){
        background-color: #F4F8FB;
    }
    .table tr:nth-child(odd){
        background-color: white;
    }
    .table tr:hover {
        background-color: #D6E2EC;
        cursor:pointer;
    }
    .table tr td {
        background-color:inherit !important;
        border:none;
    }

    input[type=date] {
        -moz-appearance: none; -webkit-appearance: none; appearance: none;
    }

    .table>* {
        box-shadow:none;
    }

    .table {
        border-radius: 8px;
        border: 1px solid #dddee4;
        box-shadow: 0px 1px 4px rgba(19,126,199,0.2);
        border-spacing: 0;
        border-collapse: inherit;
        display: block;
        overflow-x: auto;
        white-space: nowrap;
    }

    .table th {
        background-color: #152b4b;
        padding:15px 15px 15px 0.5rem;
        font-weight:normal;
        border:none;
    }

    .table th a, .table th {
        color:white;
        text-decoration:none;
    }

    .table tr th:last-child {
        border-top-right-radius: 8px;
    }

    .table tr:last-child td:last-child {
        border-bottom-right-radius: 8px;
    }

    .table tr th:first-child {
        border-top-left-radius: 8px;
    }

    .table tr:last-child td:first-child {
        border-bottom-left-radius: 8px;
    }

    .table tr td:first-child, .table tr th:first-child {
        padding-left:20px;
    }

    .table tr td:last-child, .table tr th:last-child {
        padding-right:25px;
    }

    .table td {
        vertical-align:middle;
    }

    .select2-container .select2-selection--multiple .select2-selection__rendered {
        white-space: normal;
    }

    .table tr:nth-child(even) td {
        background-color: #F4F8FB;
    }
    .markdown>table>:not(caption)>*>*,.table>:not(caption)>*>* {
        box-shadow:none;
        /*box-shadow:inset 0 0 0 9999px var(--tblr-table-bg-state, var(--tblr-table-bg-type, var(--tblr-table-accent-bg))); */
    }
</style>

<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <div class="page-pretitle">
                    <?= Yii::t('app', 'Overview') ?>
                </div>
                <h2 class="page-title">
                    <?= $this->title ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row row-deck row-cards" style="margin-bottom:10px;">
            <div class="col-lg-4" style="display:block">
                <div class="card" style="position: sticky;top: 20px;">
                    <div class="card-body">
                        <div id="balances">

                        </div>
                    </div>
                </div>
            </div>
<!--        </div>-->
<!--        <div class="row row-deck row-cards">-->
            <div class="col-lg-8">
            <?= GridView::widget([
                'dataProvider' => new \yii\data\ArrayDataProvider([
                    'allModels' => $payouts,
                    'pagination' => false,
                ]),
                'export' => false,
                'tableOptions' => ['class' => 'table', 'style' => 'width:100%;'],
                'layout' => '{items}',
                'pager' => ['linkOptions' => ['class' => 'button']],
                'formatter' => ['class' => 'yii\i18n\Formatter','nullDisplay' => ''],
                'rowOptions' => function ($model) {
                    return [
                        'class' => 'payout-row',
                        'data-payout-id' => $model['id'],
                    ];
                },
                'columns' => [
//                    [
//                        'attribute' => 'id',
//                        'label' => 'Payout ID',
//                        'value' => function ($model) {
//                            return $model['id'];
//                        },
//                    ],
                    [
                        'attribute' => 'created',
                        'label' => 'Created',
                        'value' => function ($model) {
                            return date('M jS, Y h:i A', strtotime($model['created']));
                        },
                    ],
                    [
                        'attribute' => 'arrival_date',
                        'label' => 'Arrival Date',
                        'value' => function ($model) {
                            return date('M jS, Y h:i A', strtotime($model['arrival_date']));
                        },
                    ],
                    [
                        'attribute' => 'destination',
                        'label' => 'Destination',
                        'value' => function ($model) {
                            return $model['destination'];
                        },
                    ],
                    [
                        'attribute' => 'amount',
                        'label' => 'Amount',
                        'contentOptions' => ['style' => 'text-align: right'],
                        'headerOptions' => ['style' => 'text-align: right'],
                        'value' => function ($model) {
                            return Yii::$app->formatter->asCurrency($model['amount'], $model['currency']);
                        },
                    ],
                    [
                        'attribute' => 'status',
                        'label' => 'Status',
                        'format' => 'raw',
                        'value' => function ($model) {
                            $colorClass = match ($model['status']) {
                                'paid' => 'text-success',
                                'pending' => 'text-warning', 
                                'failed' => 'text-danger',
                                default => 'text-secondary'
                            };
                            return Html::tag('span', ucwords(str_replace("_", " ", $model['status'])) ?? null, ['class' => $colorClass]);
                        },
                    ],
                ],
            ]); ?>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal modal-blur fade" id="transactionsModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Balance Transactions</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="balanceTransactionsGrid" style="width: 100%"></div>
            </div>
        </div>
    </div>
</div> 