<?php

use app\helpers\ArrayHelper;
use app\helpers\Html;
use app\helpers\IconHelper;
use app\models\Form;
use app\models\FormSubmission;
use app\modules\addons\modules\stripe\models\StripePayment;
use app\modules\addons\modules\stripe\models\StripePaymentSearch;
use yii\helpers\StringHelper;
use yii\helpers\Url;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $startDate string */
/* @var $endDate string */

$this->title = Yii::t('app', 'Payment Dashboard');

//print_r($latestPayments);

$paymentDataText = '';
foreach ($paymentData as $key => $value) {
    $paymentDataText .= '{t: \'' . $key . '\', y: ' . $value . '},';
}

$submissionDataText = '';
foreach ($submissionData as $key => $value) {
    $submissionDataText .= '{t: \'' . $key . '\', y: ' . $value . '},';
}

$this->registerJsFile('https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js');
$this->registerJsFile('https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.bundle.js');
$this->registerJs("

new Chart(document.getElementById(\"paymentChart\").getContext(\"2d\"), {
  type: 'line',
  options: {
    legend: {
            display: false
    },
    responsive: true,
    maintainAspectRatio: false,
    scales: {
      yAxes: [{
        display: true,
        ticks: {
            beginAtZero: true,
            callback: function(value, index, ticks) {
                return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'usd'
                    }).format(value);
            }
        },
        gridLines: {
            display:true
        }
      }],
      xAxes: [{
        " . ($paymentDataText == '' ? 'display: false,' : '') . "
        ticks: {
            min: '" . date('Y-m-d', strtotime('-30 days')) . "',
            max: '" . date('Y-m-d', time()) . "',
            maxRotation: 0,
            autoSkip: true,
            autoSkipPadding: 15,
            fontSize: 12
        },
        type: 'time',
        time: {
          tooltipFormat:'MM-DD-YYYY',
        },
        gridLines: {
            display:false
        }
      }]
    },
    datasets: {
      line: {fill:false,tension:0.2},
    },
    tooltips: {
        displayColors: false,
        callbacks: {
            label: function(tooltipItem, data) {
                return new Intl.NumberFormat('en-US', {
                        style: 'currency',
                        currency: 'usd'
                    }).format(tooltipItem.value);
//                return \"$\" + tooltipItem.value;
            }
        }
    }
  },
  data: {
    datasets: [{
      label: 'Demo',
      data: [
      " . $paymentDataText . "
      ],
      backgroundColor: '#0054a6',
      borderColor: '#0054a6',
      borderWidth: 1.5,
      pointRadius: 3,
            
    }]
  }
});

new Chart(document.getElementById(\"submissionChart\").getContext(\"2d\"), {
  type: 'line',
  options: {
    legend: {
        display: false
    },
    responsive: true,
    maintainAspectRatio: false,
    scales: {
      yAxes: [{
        display: true,
        ticks: {
            beginAtZero: true,
            callback: function(value, index, ticks) {
                return value;
            }
        },
        gridLines: {
            display:true
        }
      }],
      xAxes: [{
        " . ($submissionDataText == '' ? 'display: false,' : '') . "
        ticks: {
            min: '" . date('Y-m-d', strtotime('-30 days')) . "',
            max: '" . date('Y-m-d', time()) . "',
            maxRotation: 0,
            autoSkip: true,
            autoSkipPadding: 15,
            fontSize: 12
        },
        type: 'time',
        time: {
          tooltipFormat:'MM-DD-YYYY',
        },
        gridLines: {
            display:false
        }
      }]
    },
    datasets: {
      line: {fill:false,tension:0.2},
    },
    tooltips: {
          displayColors: false,
        callbacks: {
            label: function(tooltipItem, data) {
                return tooltipItem.value;
            }
        }
    }
  },
  data: {
    datasets: [{
      label: 'Demo',
      data: [
      " . $submissionDataText . "
      ],
      backgroundColor: '#0054a6',
      borderColor: '#0054a6',
      borderWidth: 1.5,
      pointRadius: 3,
            
    }]
  }
});

Chart.plugins.register({
	afterDraw: function(chart) {
  	if (chart.data.datasets.length === 0) {
    	// No data is present
      var ctx = chart.chart.ctx;
      var width = chart.chart.width;
      var height = chart.chart.height
      chart.clear();
      
      ctx.save();
      ctx.textAlign = 'center';
      ctx.textBaseline = 'middle';
      
      ctx.fillText('No data to display', width / 2, height / 2);
      ctx.restore();
    }
  }
});");

?>

    <!-- Page header -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?= Yii::t('app', 'Overview') ?>
                    </div>
                    <h2 class="page-title">
                        <?= $this->title ?>
                    </h2>
                </div>
            </div>
        </div>
    </div>
    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <?= Html::beginForm(['/dashboard/payments'], 'get') ?>
            <div class="row">
                <div class="col-sm-3">
                    <div class="mb-3">
                        <div class="input-icon mb-2">
                            <input class="form-control" placeholder="<?= Yii::t('app', 'Select a date') ?>" id="start_date" name="start_date" value="<?= $startDate ?>"/>
                            <span class="input-icon-addon">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z" /><path d="M16 3l0 4" /><path d="M8 3l0 4" /><path d="M4 11l16 0" /><path d="M11 15l1 0" /><path d="M12 15l0 3" /></svg>
                    </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="mb-3">
                        <div class="input-icon mb-2">
                            <input class="form-control" placeholder="<?= Yii::t('app', 'Select a date') ?>" id="end_date" name="end_date" value="<?= $endDate ?>"/>
                            <span class="input-icon-addon">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 5m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z" /><path d="M16 3l0 4" /><path d="M8 3l0 4" /><path d="M4 11l16 0" /><path d="M11 15l1 0" /><path d="M12 15l0 3" /></svg>
                    </span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="mb-3">
                        <button type="submit" class="btn btn-primary"><?= Yii::t('app', 'Go!') ?></button>
                    </div>
                </div>
                <?php if(Yii::$app->user->can("addManualPayment", ['listing' => true])) : ?>
                <div class="col-sm-3" style="text-align:right;">
                    <div class="mb-3">
                        <a href="<?= Url::to(['form/generate-manual-checkout']) ?>" class="btn btn-primary">Add a Manual Payment</a>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?= Html::endForm() ?>
            <div class="row row-deck row-cards">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="card-title">Payments in the last 30 days</h3>
                            <div class="chart-lg" style="min-height:240px;display:block">
                                <canvas id="paymentChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="card-title">Submissions in the last 30 days</h3>
                            <div class="chart-lg" style="min-height:240px;display:block">
                                <canvas id="submissionChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?= Yii::t('app', 'Latest Payments') ?></h3>
                        </div>
                        <div class="table-responsive">
                            <table class="table card-table table-vcenter">
                                <?php if (count($latestPayments) === 0) : ?>
                                    <tr>
                                        <td colspan="2" class="w-100">
                                            <?= Yii::t('app', 'No data') ?>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($latestPayments as $payment) : ?>
                                        <tr>
                                            <td class="text-nowrap text-muted">
                                                <?= $payment['formName'] ?>
                                            </td>
<!--                                            <td class="w-100">-->
<!--                                                --><?php //= $payment->submission->data['text_1'] ?? 'Name' ?>
<!--                                                <a href="--><?php //= Url::to(['form/view', 'id' => $form['id']]) ?><!--" class="text-reset">-->
<!--                                                    --><?php //= Html::encode($form['name']) ?>
<!--                                                </a>-->
<!--                                            </td>-->
                                            <td class="text-nowrap text-muted text-sm-end">
                                                <?= Yii::$app->formatter->asCurrency($payment['subtotal'] / 100) ?>
                                            </td>
                                            <td class="text-nowrap text-muted">
                                                <?= Yii::$app->formatter->asDate($payment['created_at'], 'php:M jS') ?>
                                            </td>

                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?= Yii::t('app', 'Revenue by Form') ?></h3>
                        </div>
                        <div class="table-responsive">
                            <table class="table card-table table-vcenter">
                                <?php if (count($revenueByForm) === 0) : ?>
                                    <tr>
                                        <td colspan="2" class="w-100">
                                            <?= Yii::t('app', 'No data') ?>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($revenueByForm as $revenue) : ?>
                                        <tr>
                                            <td class="w-100">
                                                <?= $revenue['name'] ?? 'Form Name' ?>
                                                <!--                                                <a href="--><?php //= Url::to(['form/view', 'id' => $form['id']]) ?><!--" class="text-reset">-->
                                                <!--                                                    --><?php //= Html::encode($form['name']) ?>
                                                <!--                                                </a>-->
                                            </td>
                                            <td class="text-nowrap text-muted text-sm-end">
                                                <?= Yii::$app->formatter->asCurrency(str_replace(',', '', $revenue['total'] ?? '')) ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title"><?= Yii::t('app', 'Revenue Collection Rate') ?></h3>
                        </div>
                        <div class="table-responsive">
                            <table class="table card-table table-vcenter">
                                <?php if (count($collectionRate) === 0) : ?>
                                    <tr>
                                        <td colspan="2" class="w-100">
                                            <?= Yii::t('app', 'No data') ?>
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($collectionRate as $rate) : ?>
                                        <tr>
                                            <td class="w-100">
                                                <?= $rate['name'] ?? 'Name' ?>
                                                <!--                                                <a href="--><?php //= Url::to(['form/view', 'id' => $form['id']]) ?><!--" class="text-reset">-->
                                                <!--                                                    --><?php //= Html::encode($form['name']) ?>
                                                <!--                                                </a>-->
                                            </td>
                                            <td class="text-nowrap text-muted text-sm-end">
                                                <?= Yii::$app->formatter->asCurrency($rate['totalPaid'] / 100) ?>
                                            </td>
                                            <td class="text-nowrap text-muted text-sm-end">
                                                <?= Yii::$app->formatter->asCurrency($rate['totalDue'] / 100) ?>
                                            </td>
                                            <td class="text-nowrap text-muted text-sm-end">
                                                <?= Yii::$app->formatter->asPercent(empty($rate['totalPaid']) ? 0 : $rate['totalPaid'] /  $rate['totalDue']) ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
    </div>

<?php
$script = <<<JS
    document.addEventListener("DOMContentLoaded", function () {
        window.Litepicker && (new Litepicker({
            element: document.getElementById('start_date'),
            buttonText: {
                previousMonth: `<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 6l-6 6l6 6" /></svg>`,
                nextMonth: `<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>`,
            },
        }));
    });
    document.addEventListener("DOMContentLoaded", function () {
        window.Litepicker && (new Litepicker({
            element: document.getElementById('end_date'),
            buttonText: {
                previousMonth: `<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 6l-6 6l6 6" /></svg>`,
                nextMonth: `<svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>`,
            },
        }));
    });
    
JS;

$this->registerJs($script, View::POS_END);
$this->registerJsFile("@web/themes/next/assets/libs/litepicker/dist/litepicker.min.js");
