<?php

use baluart\tomselect\TomSelectDropDownList;
use kartik\export\ExportMenu;
use yii\helpers\Html;
use yii\helpers\ArrayHelper;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var \app\modules\addons\modules\stripe\models\StripePaymentSearch $model */
/** @var yii\widgets\ActiveForm $form */
$user = \Da\User\Model\User::findOne(['id' => Yii::$app->user->id]);

?>
<style>
    .form-group {
        display:inline-block;
    }
    select.form-control {
        background-color:white;
        /*text-align:center;*/
        background: url("data:image/svg+xml,%3Csvg viewBox='-10 -8 40 40' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cg id='SVGRepo_bgCarrier' stroke-width='0'%3E%3C/g%3E%3Cg id='SVGRepo_tracerCarrier' stroke-linecap='round' stroke-linejoin='round'%3E%3C/g%3E%3Cg id='SVGRepo_iconCarrier'%3E%3Cpath d='M7 10L12 15L17 10' stroke='%23000000' stroke-width='1.5' stroke-linecap='round' stroke-linejoin='round'%3E%3C/path%3E%3C/g%3E%3C/svg%3E") no-repeat 100% 50%;
    }
    .ts-wrapper {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        -webkit-tap-highlight-color: transparent;

    }

    .ts-control {
        -webkit-tap-highlight-color: transparent;
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
    }
    .ts-control:focus {
        outline: none !important;
    }

    .ts-control {
        /*display: block;*/
        /*width: 100%;*/
        /*padding: 0.5625rem 0.75rem !important;*/
        /*font-family: var(--tblr-font-sans-serif);*/
        font-size: 0.875rem;
        font-weight: 400;
        line-height: 1.4285714286;
        color: var(--tblr-body-color);
        background: url("data:image/svg+xml,%3Csvg viewBox='-10 -8 40 40' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cg id='SVGRepo_bgCarrier' stroke-width='0'%3E%3C/g%3E%3Cg id='SVGRepo_tracerCarrier' stroke-linecap='round' stroke-linejoin='round'%3E%3C/g%3E%3Cg id='SVGRepo_iconCarrier'%3E%3Cpath d='M7 10L12 15L17 10' stroke='%23000000' stroke-width='1.5' stroke-linecap='round' stroke-linejoin='round'%3E%3C/path%3E%3C/g%3E%3C/svg%3E") no-repeat 100% 50% !important;
        height:40px;
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        -webkit-tap-highlight-color: transparent;

        /*background-color: var(--tblr-bg-forms);*/
        /*background-clip: padding-box;*/
        /*border: var(--tblr-border-width) solid var(--tblr-border-color);*/
        /*border-radius: var(--tblr-border-radius);*/
        /*box-shadow: var(--tblr-box-shadow-input);*/
        /*transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;*/
    }

    .export-menu .dropdown-item {
        column-gap:10px;
    }


</style>
<div>

    <?php $form = ActiveForm::begin([
        'action' => ['dashboard/stripe-payments'],
        'method' => 'get',
        'options' => ['class' => 'wrap_vertical', 'style' => 'display:flex;'],
    ]); ?>

    <div style="flex-grow:1">

        <?= $form->field($model, 'status')->widget(TomSelectDropDownList::class, [
            'items' => ['Complete' => 'Complete', 'Scheduled' => 'Scheduled', 'Processing' => 'Processing', 'Failed' => 'Failed', 'Requires Action' => 'Requires Action', 'Refunded' => 'Refunded', 'Partially Refunded' => 'Partially Refunded'],
            'options' => [
                'create' => false,
                'multiple' => true,
                'prompt' => 'Payment Statuses',
                'class' => 'form-control'
            ],
            'clientOptions' => [
                'create' => false,
                'multiple' => true,
                'selectOnTab' => true,
            ],
        ])->label(false) ?>


        <?= $form->field($model, 'payment_method')->widget(TomSelectDropDownList::class, [
            'items' => ['us_bank_account' => 'ACH', 'Card' => 'Card'],
            'options' => [
                'create' => false,
                'multiple' => true,
                'prompt' => 'Payment Methods',

            ],
            'clientOptions' => [
                'create' => false,
                'multiple' => true,
                'selectOnTab' => true,
                'class' => 'form-control',
                'style' => 'margin-left:10px;'
            ],
        ])->label(false) ?>

        <?= $form->field($model, 'createdFrom', ['options' => ['class' => 'wrap_vertical', 'style'=> 'display:inline-block'], 'template' => '<div style="display:inline-block;padding-right:10px;padding-left:10px;flex-grow:1">{label}</div><div style="display:inline-block;">{input}</div>{error}{hint}'])->input('date')->label('Payment From') ?>

        <?= $form->field($model, 'createdTo', ['options' => ['class' => 'wrap_vertical', 'style' => 'display:inline-block'], 'template' => '<div style="display:inline-block;padding-right:10px;padding-left:10px;flex-grow:1">{label}</div><div style="display:inline-block;">{input}</div>{error}{hint}',])->input('date')->label('Payment To') ?>

        <?= $form->field($model, 'searchName', ['inputOptions' => ['class' => 'form-control', 'placeholder' => 'Customer Name or Email', 'style' => 'width:280px;']])->label(false) ?>

    </div>
    <div style="display:flex;align-items:start;flex-wrap:wrap;column-gap:10px;row-gap:15px;align-content:start;max-width:200px;">

        <?= Html::submitButton('Search', ['class' => 'btn btn-primary', 'style' => 'flex-grow:1']) ?>
        <?= Html::a('Reset', ['dashboard/stripe-payments'], ['class' => 'btn btn-default', 'style'=> 'flex-grow:1']) ?>
        <?php
        $gridColumns = [
            ['class' => 'yii\grid\SerialColumn'],
            [
                'attribute' => 'created_at',
                'contentOptions'=> ['style' => 'width:150px;'],
                'format' => 'html',
                'label' => 'Payment Date',
                'value' => function ($model) {
                    return Yii::$app->formatter->asDate($model->created_at,  'php:m/d/Y') . '<br />' .
                        Yii::$app->formatter->asDate($model->created_at, 'php:h:i a');
                    //return $model->created['datetime', 'php:m/d/Y h:i a']
                }
            ],
            'form.name',
            [
                'attribute' => 'payment_method',
                'contentOptions'=> ['style' => 'width:150px;'],
                'value' => function ($model) {
                    return $model->payment_method == 'us_bank_account' ? 'ACH' : ucfirst($model->payment_method ?? '');
                },
            ],
            'customer_name',
            'customer_email',
            [
                'label' => 'Total',
                'headerOptions' => ['style' => 'text-align:right;padding-right:20px;'],
                'contentOptions'=> ['style' => 'text-align: right;padding-right:20px;'],
                'value' => function ($model) {
                    return Yii::$app->formatter->asCurrency($model->subtotal / 100.0);
                },
                'attribute' => 'subtotal',
            ],
            [
                'label' => 'Fees',
                'headerOptions' => ['style' => 'text-align:right;padding-right:20px;'],
                'contentOptions'=> ['style' => 'text-align: right;padding-right:20px;'],
                'value' => function ($model) {
                    return Yii::$app->formatter->asCurrency(($model->total - $model->subtotal) / 100.0);
                },
                'attribute' => 'fees',
            ],
            [
                'format' => 'html',
                'label' => 'Status',
                'value' => function ($model) {
                    return '<span style="' . (in_array($model->status, ['Complete','Processing']) ? 'color:green' : ($model->status == 'Failed' ? 'color:red;' : 'color:darkorange')) . '">' . $model->status . '</span>';
                },
                'attribute' => 'status',
            ],
        ];

        // Renders a export dropdown menu
        echo ExportMenu::widget([
            'dataProvider' => $dataProvider,
            'columns' => $gridColumns,
            'showColumnSelector' => false,
            'container' => [
                'class' => 'export-menu',
                'style' => 'width:100%;',
            ],
            'dropdownOptions' => [
                'icon' => false,
                'label' => 'Export All',
                'class' => 'btn btn-primary',
                'style' => '--tblr-btn-color: var(--tblr-primary-fg);--tblr-btn-bg: var(--tblr-primary);width:100%;',
            ],
            'exportContainer' => [
                'style' => 'width:100%',
            ],
            'exportConfig' => [
                ExportMenu::FORMAT_PDF => false
            ],
            'filename' => 'payments_export.'.date('m-d-y'),
            'clearBuffers' => true, //optional
        ]);
        ?>

    </div>

    <?php ActiveForm::end(); ?>

</div>
