<?php
use yii\helpers\Html;
use app\modules\addons\modules\stripe\models\StripePayment;
use yii\helpers\Url;

/* @var $model StripePayment */
?>
<style>
    .table th {
        background-color: var(--tblr-primary);;
    }
    .table td, .table tr, .table th {
        cursor:default;
</style>

<div class="modal-body" style="z-index:100">
    <div class="table-responsive">
        <table class="table" style="width: 100%;">
            <tbody>
                <tr>
                    <th style="width: 200px; border-radius: 0;"><?= Yii::t('app', 'Payment Date') ?></th>
                    <td style="border-radius: 0; width: 100%;">
                        <?= Yii::$app->formatter->asDatetime($model->created_at, 'php:F jS, Y h:i A') ?>
                    </td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Status') ?></th>
                    <td style="border-radius: 0; width: 100%;">
                        <span style="<?= in_array($model->status, ['Complete','Processing']) ? 'color:green' : ($model->status == 'Failed' ? 'color:red;' : 'color:darkorange') ?>">
                            <?= Html::encode($model->status) ?>
                        </span>
                    </td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Payment Method') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Html::encode($model->payment_method == 'us_bank_account' ? 'ACH' : ucfirst($model->payment_method ?? '')) ?></td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Customer Name') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Html::encode($model->customer_name) ?></td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Customer Email') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Html::encode($model->customer_email) ?></td>
                </tr>
                <?php if ($model->transfer_amount > 0) : ?>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Package Total') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency($model->subtotal / 100.0) ?></td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Amount Received') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency($model->transfer_amount / 100.0) ?></td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Fees') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency(($model->total - $model->subtotal) / 100.0) ?></td>
                </tr>
                <?php else: ?>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Subtotal') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency($model->subtotal / 100.0) ?></td>
                </tr>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Fees') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency(($model->total - $model->subtotal) / 100.0) ?></td>
                </tr>
                <?php endif; ?>
                <?php if ($model->refunded_amount > 0): ?>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Refunded Amount') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency($model->refunded_amount / 100.0) ?></td>
                </tr>
                <?php endif; ?>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Total') ?></th>
                    <td style="border-radius: 0; width: 100%;"><?= Yii::$app->formatter->asCurrency(($model->total - $model->refunded_amount) / 100.0) ?></td>
                </tr>
                <?php if ($model->form_id): ?>
                <tr>
                    <th style="border-radius: 0;"><?= Yii::t('app', 'Form') ?></th>
                    <td style="border-radius: 0; width: 100%;">
                    <?= Html::encode($model->form->name) ?>
                    
                    <?php if ($model->submission_id): ?>
                        <?= Html::a(
                                Yii::t('app', 'View Submission'),
                            ['/form/submissions', 'id' => $model->form_id, '#' => 'view/' . $model->submission_id],
                            ['class' => 'pull-right', 'style' => 'float:right;']
                        ) ?>
                    <?php endif; ?>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>