<?php

use kartik\grid\GridView;
use kartik\helpers\Html;

?>
<?= GridView::widget([
    'dataProvider' => new \yii\data\ArrayDataProvider([
        'allModels' => $balanceTransactions,
        'pagination' => false,
    ]),
    'export' => false,
    'tableOptions' => ['class' => 'table', 'style' => ''],
    'layout' => '{items}{pager}{summary}',
    'columns' => [
//        [
//            'label' => 'Payment Intent',
//            'value' => function ($model) {
//                return ucfirst($model['payment_intent']) ?? null;
//            },
//        ],
        [
            'attribute' => 'created',
            'label' => 'Payment Date',
            'value' => function ($model) {
                return date('M jS, Y h:i A', strtotime($model['created']));
            },
        ],
        [
            'label' => 'Type',
            'value' => function ($model) {
                return ucwords(str_replace("_", " ", $model['type'])) ?? null;
            },
        ],
        [
            'label' => 'Form Name',
            'contentOptions' => ['style' => 'width: 100%'],
            'value' => function ($model) {
                return !empty($model['stripe_payment']) ? $model['stripe_payment']['form_name'] : null;
            },
        ],
        [
            'label' => 'Payment Method',
            'value' => function ($model) {
                return !empty($model['stripe_payment']) ? ($model['stripe_payment']['payment_method'] == 'us_bank_account' ? 'ACH' : ucfirst($model['stripe_payment']['payment_method'] ?? ''))  : null;
            },
        ],
        [
            'label' => 'Customer Name',
            'value' => function ($model) {
                return !empty($model['stripe_payment']) ? $model['stripe_payment']['customer_name'] : null;
            },
        ],
        [
            'label' => 'Customer Email',
            'value' => function ($model) {
                return !empty($model['stripe_payment']) ? $model['stripe_payment']['customer_email'] : null;
            },
        ],
        [
            'label' => 'Total',
            'contentOptions' => ['style' => 'text-align: right'],
            'headerOptions' => ['style' => 'text-align: right'],
            'value' => function ($model) {
                return Yii::$app->formatter->asCurrency($model['net']);
            },
        ],
//        [
//            'label' => 'Status',
//            'format' => 'raw',
//            'value' => function ($model) {
//                $badgeClass = match ($model['status']) {
//                    'succeeded' => 'badge bg-success',
//                    'pending' => 'badge bg-warning',
//                    'failed' => 'badge bg-danger',
//                    default => 'badge bg-secondary'
//                };
//                return Html::tag('span', ucfirst($model['status']), ['class' => $badgeClass]);
//            },
//        ],
    ],
]); ?>