<?php

use app\helpers\Html;
use app\helpers\Liquid;
use app\helpers\SubmissionHelper;
use yii\web\View;

/* @var $this View view component instance */
/* @var $payment \app\modules\addons\modules\stripe\models\StripePayment */

$this->title = 'DS Travel - Payment Receipt';


// $receipt_date
// booking_reference?
// $payment_amount
// description/line items
// subtotal
// fees/discounts
// total
// generation date/time

$submissionModel = \app\models\FormSubmission::findOne(['id' => $payment->submission_id]);
$submissionData = !empty($submissionModel) ? $submissionModel->getSubmissionData() : [];

$stripeModel = \app\modules\addons\modules\stripe\models\Stripe::findOne(['form_id' => $payment->form_id]);

// payment info: method, transaction_id?, status


?>

    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 20px;
        }
        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            border: 1px solid #ddd;
            padding: 20px;
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #06402B;
            padding-bottom: 20px;
            margin-bottom: 20px;
        }
        .logo {
            max-width: 200px;
            margin-bottom: 10px;
        }
        .receipt-title {
            color: #06402B;
            font-size: 24px;
            margin: 10px 0;
        }
        .receipt-number {
            font-size: 14px;
            color: #666;
        }
        .company-info {
            text-align: left;
            float: left;
            font-size: 12px;
        }
        .receipt-date {
            text-align: right;
            float: right;
            font-size: 12px;
        }
        .clearfix::after {
            content: "";
            clear: both;
            display: table;
        }
        .customer-details {
            margin: 20px 0;
            padding: 25px;
            background-color: #f9f9f9;
            border-radius: 5px;
        }
        .payment-details {
            margin: 20px 0;
            width: 100%;
            border-collapse: collapse;
        }
        .payment-details th {
            background-color: #06402B;
            color: white;
            padding: 10px;
            text-align: left;
        }
        .payment-details td {
            padding: 10px;
            border-bottom: 1px solid #ddd;
        }
        .total-row {
            font-weight: bold;
            background-color: #f5f5f5;
        }
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 12px;
            text-align: center;
        }
        .payment-summary {
            margin: 20px 0;
            display:flex;
            justify-content:right;
            width:100%;
        }
        .payment-summary table {
            width: 300px;
        }
        .payment-summary td {
            padding: 5px;
        }
        .payment-summary .total {
            font-weight: bold;
            border-top: 2px solid #06402B;
        }
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 100px;
            color: rgba(0, 104, 56, 0.05);
            z-index: -1;
        }
    </style>

<div class="receipt-container">
    <div class="header">
        <img src="<?= Yii::getAlias('@web'); ?>static_files/uploads/app/site/thinlogoblack.png" alt="Dar El Salam Travel Logo" class="logo">
        <h1 class="receipt-title">Payment Receipt</h1>
<!--        <div class="receipt-number">Receipt #: --><?php //= \app\helpers\Hashids::encode($payment->id) ?><!--</div>-->
    </div>

    <div class="clearfix">
        <div class="company-info">
            <strong>Dar El Salam Travel</strong><br>
            280 Madison Ave #500<br>
            New York, NY 10016<br>
            Phone: 1-866-327-7252<br>
            Email: info@darelsalam.com<br>
        </div>
        <div class="receipt-date">
            <strong>Date:</strong> <?= Yii::$app->formatter->asDate($payment->created_at, 'php:D M d, Y h:i a') ?><br>
<!--            <strong>Booking Ref:</strong> {Booking_Reference}-->
        </div>
    </div>

    <div class="customer-details">
        <h3 style="margin-top:0px;">Bill To:</h3>
        <strong>Customer: <?= $payment->customer_name ?></strong><br>
        Email: <?= $payment->customer_email ?>
    </div>

    <table class="payment-details">
        <thead>
        <tr>
            <th>Description</th>
            <th style="text-align:right;">Amount</th>
        </tr>
        </thead>
        <tbody>
        <?php
            if (!empty($submissionModel)) {
                $line_items = json_decode($submissionModel->line_items, true);
                if ($line_items) {
                    foreach ($line_items as $line_item) {
                        echo '<tr><td>' . $line_item['description'] . '</td><td style="text-align:right;">' . Yii::$app->formatter->asCurrency($line_item['total']) . '</td></tr>';
                    }
                }
            }
            else {
                echo '<tr><td>Manual Payment</td><td style="text-align:right;">' . Yii::$app->formatter->asCurrency($payment->subtotal / 100) . '</td></tr>';
            }
        ?>
<!--        <tr>-->
<!--            <td>{Item_Description}</td>-->
<!--            <td>${Payment_Amount}</td>-->
<!--        </tr>-->
        </tbody>
    </table>

    <div class="payment-summary">
        <div width="100%"></div>
        <table>
            <tr>
                <td>Subtotal:</td>
                <td align="right"><?= Yii::$app->formatter->asCurrency($payment->subtotal/100) ?></td>
            </tr>
            <tr>
                <td>Processing Fee:</td>
                <td align="right"><?= Yii::$app->formatter->asCurrency($payment->fees/100) ?></td>
            </tr>
            <?php if($payment->discount != 0): ?>
            <tr>
                <td>ACH Discount:</td>
                <td align="right">- <?= Yii::$app->formatter->asCurrency($payment->discount/100) ?></td>
            </tr>
            <?php endif; ?>
            <tr class="total">
                <td>Total Paid:</td>
                <td align="right"><?= Yii::$app->formatter->asCurrency($payment->total/100) ?></td>
            </tr>
        </table>
    </div>

    <div class="footer">
        <p>This is an official receipt of payment. Please keep this document for your records.</p>
        <p>For any questions about this receipt, please contact our billing department at info@darelsalam.com</p>
        <p>Thank you for choosing Dar El Salam Travel.</p>
        <p><small>This receipt was generated on <?= Yii::$app->formatter->asDateTime(strtotime('now'), 'php:D M d, Y h:i a') ?></small></p>
    </div>
</div>
</body>
</html>
