<?php

use app\helpers\Pager;
use app\modules\addons\modules\stripe\models\Stripe;
use app\modules\addons\modules\stripe\services\StripeService;
use yii\helpers\Html;
use yii\helpers\Url;
use app\helpers\UrlHelper;
use yii\web\JqueryAsset;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $formModel app\models\Form */
/* @var $submissionModel array */
/* @var $showTheme boolean */
/* @var $showBox boolean */
/* @var $customJS boolean */
/* @var $page int */
/* @var $reset int */

// Home URL
$homeUrl = Url::home(true);

// Base URL without schema
$baseUrl = UrlHelper::removeScheme($homeUrl);

$this->title = $formModel->name;

//$this->registerJsFile('', ['position' => View::POS_HEAD, 'depends' => JqueryAsset::class]);


// Add body background to show box design
if ($showBox) {
    ;//$this->registerCss("body { background-color: #EFF3F6; } iframe { border-radius: 0 0 4px 4px; } ");
} else if ($showTheme && !empty($formModel->theme->css)) {
    // Add theme
    $this->registerCss($formModel->theme->css);
}

// Allow / Disallow Edit a Form Submission
$sid = $submissionModel['id'] ?? 0;

$stripeModels = Stripe::findAll(['form_id' => $formModel->id, 'status' => 1]);

$formDataModel = $formModel->formData;
// Pager
$pager = new Pager(Html::decode($formDataModel->html));
$numPages = $pager->getNumberOfPages();

$output_array = [];

preg_match_all('/class=&quot;title&quot;&gt;(.*)&lt;/', $formDataModel->html, $output_array);

$hashId = str_replace('.', '\\\\.', $formModel->hashId);

?>
<link href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script>
    function loadModal(message) {
        const html = '<div class="jquery-modal blocker" style="display: flex;justify-content: center;align-items: center;"><div class="modal" style="display: inline-block;">' + message + '</div></div>';

        $('body').append(html);
        // $('.blocker', document).on('click',function(e){ if (e.target === this) $('.blocker').remove() });
    }
</script>
<style>
    .progress {
        height:auto !important;
    }
    #checkoutTable_line_items .line-item {
        flex-grow:1;
        padding-left:10px;
    }
    #checkoutTable_line_items > div {
        height:50px;
        align-items:center;
    }
    #checkoutTable_line_items .line-icon svg {
        width:20px !important;
        height:20px !important;
    }
    html, body {
        height:100% !important;
    }
    .app-embed {
        overflow:scroll;
    }
    .modal {
        position:relative;
        overflow-x:unset;
        overflow-y:unset;
        top:inherit;
        left:inherit;
        max-height:750px;
        height:unset;
        font-size:1.5rem;
        padding:50px;
    }
    .blocker {
        background-color: rgba(0, 0, 0, .5);
        position: absolute;
        top: 0;
        height: 100%;
        width: 100%;
        z-index: 21;
    }
    .was-validated .invalid-feedback {
        display:block;
    }
</style>
    <?php if ($showBox) : ?>
    <div class="main-container" style="height:100%;display:flex;flex-flow:column;">
        <div id="header" class="card-header bg-muted" style="height:auto;display:flex;justify-content: center">
            <div style="display: flex;justify-content: center;align-items: center;column-gap: 50px;flex-wrap:wrap;row-gap:10px;">
                <div class="card-title">
                    <h3 style="margin:0px;">
                        <!-- Brand -->
                        <?php
                        if (empty($logo)) {
                            echo $this->render('@app/themes/next/views/partials/_brand', [
                                'brandHeight' => '40px',
                            ]);
                        } else {
                            echo '<img src="/static_files/uploads/' . $logo . '" style="max-height:40px;" />';
                        }?>
                    </h3>
                </div>
                <div id="form-steps" class="component component-form-steps">
                    <!-- Steps -->
                    <div class="steps_top" style="display: flex;flex-wrap: wrap;row-gap: 10px;">
<!--                        <div class="step current">-->
<!--                            <div class="stage">1</div> <div class="title">Traveler Information</div>-->
<!--                        </div>-->
<!--                        <div class="step">-->
<!--                            <div class="stage">2</div> <div class="title">Checkout</div>-->
<!--                        </div>-->
                        <?php
                            $i = 1;
                            foreach ($output_array[1] as $step) {
                                echo '<div class="step' . ($i == 1 ? ' current' : '') . '"><div class="stage">' . $i . '</div> <div class="title">' . $step . '</div></div>';
                                $i++;
                            }
                        ?>
                    </div>
                </div>
            </div>


        </div>
        <div id="content" style="flex-grow:1">
<!--            <div class="">-->
<!--                <div >-->
                    <div class="form-view" style="height:100%">
                        <div class="card" style="border:none;height:100%;">
                            <div class="card-body" style="padding: 0; line-height: 0;min-height:100%;">
                                <div id="c<?= $formModel->hashId ?>" style="height:100%">
                                    <main class="p-5 d-flex justify-content-center align-items-center flex-wrap">
                                        <div class="spinner-border"></div>
                                    </main>
                                </div>
                                <script type="text/javascript">
                                    window.currencyFormatter = new Intl.NumberFormat('en-US', {
                                        style: 'currency',
                                        currency: 'usd',
                                        minimumFractionDigits: 0,
                                        maximumFractionDigits: 2
                                    });

                                    <?php
                                        $formURL = UrlHelper::removeScheme(Url::to(['/app/embed'], true));
                                        $formWidgetURL = Url::to('@web/static_files/js/form.widget.js', true);
                                    $js = <<<JS
                                    (function(d, t) {
                                        var s = d.createElement(t), options = {
                                            'id': '{$formModel->hashId}',
                                            'sid': {$sid},
                                            'page': {$page},
                                            'theme': {$showTheme},
                                            'customJS': {$customJS},
                                            'reset': {$reset},
                                            'container': 'c{$formModel->hashId}',
                                            'height': '{$formModel->formData->height}px',
                                            'form': '{$formURL}'
                                        };
                                        s.type= 'text/javascript';
                                        s.src = '{$formWidgetURL}';
                                        s.onload = s.onreadystatechange = function() {
                                            var rs = this.readyState; if (rs) if (rs !== 'complete') if (rs !== 'loaded') return;
                                            try {
                                                (new EasyForms()).initialize(options).display();
JS;

                                    if ($stripeModels != null) {
                                        $js .= <<<JS

                                                    $('#c{$hashId}i{$hashId}').on('load', () => {
                                                    var iframe = $('#c{$hashId}i{$hashId}');
                                                    var iframeContent = iframe.contents();
                                                    var iframeWindow = iframe[0].contentWindow ? iframe[0].contentWindow : iframe[0].contentDocument.defaultView;

                                                    var initialVal = "";
JS;
                                                    if (!empty($stripeModels) && !empty($stripeModels[0])) {
                                                        $model = $stripeModels[0];
                                                        foreach ($model->items as $stripeItem) {
                                                            foreach ($formModel->formData->getLabels() as $field_name => $field_title) {
                                                                if ($field_name == $stripeItem->price) {

                                        $js .= <<<JS

                                                    var selected = iframeContent.find("input[type='radio'][name={$field_name}]");

                                                    // INIT
                                                    $.each(selected, function( key, radio ) {
                                                        initCheckoutSummary(radio);
                                                    });

                                                    var {$field_name} = iframeContent.find("input[name='{$field_name}']").change(function () {
                                                        if ("{$field_name}".startsWith("text")) {
                                                            var amount = {$field_name}.val();
    
                                                            parsedAmount = amount.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');
                                                            //parsedAmount = parseFloat(parsedAmount);
                                            
                                                            if (parsedAmount == null || isNaN(parsedAmount))
                                                                parsedAmount = 0;
                                                            
                                                            
                                                            {$field_name}.val(window.currencyFormatter.format(parsedAmount));
                                                            updateCheckoutSummary({$field_name}, parsedAmount);
                                                        }
                                                        else
                                                            updateCheckoutSummary({$field_name}, this.value);
                                                    });

                                                    if ("{$stripeItem->quantity}" != "")
                                                        updateCheckoutQuantity('{$field_name}', iframeContent.find("input[name='{$stripeItem->quantity}']").val());
JS;
                                        if (!empty($stripeItem->quantity)) {
                                            $js .= <<<JS

                                                    var {$stripeItem->quantity} = iframeContent.find("input[name='{$stripeItem->quantity}']").change(function () {
                                                        updateCheckoutQuantity('{$field_name}', this.value);
                                                    });
JS;
                                        }


                                                                }
                                                            }
                                                        }
                                                    }
                                    $js .= <<<JS
                                                })
JS;
                                    }
                                    $js .= <<<JS
                                           } catch (e) { }

                                       };
                                       var scr = d.getElementsByTagName(t)[0], par = scr.parentNode; par.insertBefore(s, scr);
                                   })(document, 'script');
JS;

                                    $this->registerJs($js, View::POS_HEAD);

                                    ?>




                                    function numberWithCommas(x) {
                                        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                                    }

                                    function format_number(n) {
                                        return n.toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, "$1,");
                                    }

                                    function formatCurrency(amount, currencyCode) {
                                        return new Intl.NumberFormat('en-US', {
                                            style: 'currency',
                                            currency: currencyCode
                                        }).format(amount);
                                    }

                                    function initCheckoutSummary(radio) {
                                        var total = 0;

                                        if (radio.checked) {
                                            $('#checkoutTable_' + radio.id).addClass('show');
                                            total += parseInt($('#checkoutTable_' + radio.id + '_amount').text().replace("$", ""));
                                        }
                                        else
                                            $('#checkoutTable_' + radio.id).removeClass('show');

                                        $('#checkoutTable_total').html('$' + numberWithCommas(total));
                                    }

                                    function updateCheckoutSummary(field_name, choice_value = "") {
                                        $.each(field_name, function (key, radio) {
                                            if (radio.id.startsWith('radio')) {
                                                if (radio.checked && radio.value != 0 && $('#checkoutTable_' + radio.id + '_amount').html() != '$0.00') {
                                                    $('#checkoutTable_' + radio.id).addClass('show');
                                                    //$('#checkoutTable_' + radio.id).find('#item-details').html(choice_value);
                                                    $('#checkoutTable_' + radio.id).find('#item-quantity-display').html('Quantity: ' + $('#checkoutTable_' + radio.id).find('#item-quantity').val());
                                                    // console.log($(field_name))
                                                } else
                                                    $('#checkoutTable_' + radio.id).removeClass('show');
                                            }
                                            else {
                                                var checkoutRow = $('#checkoutTable_' + radio.id);
                                                $('#checkoutTable_' + radio.id + '_amount').html(formatCurrency(choice_value, 'usd'));
                                                checkoutRow.find('#item-price').val(choice_value);
                                                checkoutRow.addClass('show');
                                            }
                                        });

                                        const total = calculateTotal();

                                        $('#checkoutTable_total').html('$' + numberWithCommas(total));

                                        var iframe = $('#c<?= $hashId ?>i<?= $hashId ?>');
                                        var iframeWindow = iframe[0].contentWindow ? iframe[0].contentWindow : iframe[0].contentDocument.defaultView;

                                        const lineItems = $('#checkoutTable_line_items > .show').toArray();
                                        iframeWindow.updateCheckoutLineItems(lineItems);

                                        iframeWindow.updateCheckoutNumbers(total);
                                    }

                                    // line_item: the line item that this quantity corresponds to
                                    function updateCheckoutQuantity(line_item, value) {
                                        const line_items = $('div[id^=checkoutTable_' + line_item + ']:not([id$=_amount])');

                                        var quantities = line_items.find('#item-quantity');
                                        quantities.val(value);

                                        var quantityDisplays = line_items.find('#item-quantity-display');
                                        quantityDisplays.html('Quantity: ' + value);

                                        $.each(line_items, function (key, line) {
                                            var itemPrice = $(line).find("#item-price").val();
                                            var itemQuantity = $(line).find("#item-quantity").val()
                                            $(line).find("#item-total").val(itemPrice * itemQuantity);
                                            $(line).find("[id$=_amount]").html(formatCurrency(itemPrice * itemQuantity, 'usd'));
                                            // console.log();
                                            // console.log($(line).find("#item-quantity").val());
                                            // console.log($(line).find(".line-price").html());
                                        });

                                        // var amountDisplays = line_items.find() $('div[id^=checkoutTable_' + line_item + '_][id$=amount]');
                                        // amountDisplays.html('$' + value);

                                        updateCheckoutSummary(null);
                                    }

                                    // use the checkout summary to calculate total
                                    function calculateTotal() {
                                        var total = 0;

                                        $('#checkoutTable_line_items > .show').each(function(index, element) {
                                            var amount = $(this).find('#item-price').val();
                                            var quantity = $(this).find("#item-quantity").val();

                                            // var amountDiv = $(this).find("div[id$='_amount']")[0];
                                            //var iframe = $('#c<?= $hashId ?>i<?= $hashId ?>');
                                            // var iframeWindow = iframe[0].contentWindow ? iframe[0].contentWindow : iframe[0].contentDocument.defaultView;
                                            // var inputs = $('input', iframeWindow);
                                            // var variable = $(quantityDiv).find('.line-quantity');
                                            // var quantity = quantityDiv.value;// $(iframe).contents().find('input[name="' + quantityDiv.innerHTML + '"]:checked').val();
                                            // var quantity = $(iframe).contents().find("input[name='"  "'][checked]'").val();

                                            // $(this).find("div[id$='_amount']").each(function(index2, amountDiv) {

                                            amount = amount.replace("$","").replace(",","");
                                            if (amount.startsWith("-")) {
                                                if (amount.endsWith("%"))
                                                    total = total - (total * parseInt(amount.replace("-", "").replace("%", ""))  / 100);
                                                else
                                                    total = total - parseInt(amount.replace("-", ""));
                                            }
                                            else
                                                total = total + (parseInt(amount) * parseInt(quantity));

                                            // });
                                        });
                                        total = (total < 0 ? 0 : total);

                                        return total;
                                    }



                                    //(function(d, t) {
                                    //    var s = d.createElement(t), options = {
                                    //        'id': '<?php //= $formModel->hashId ?>//',
                                    //        'sid': <?php //= $sid ?>//,
                                    //        'page': <?php //= $page ?>//,
                                    //        'theme': <?php //= $showTheme ?>//,
                                    //        'customJS': <?php //= $customJS ?>//,
                                    //        'reset': <?php //= $reset ?>//,
                                    //        'container': 'c<?php //= $formModel->hashId ?>//',
                                    //        'height': '<?php //= $formModel->formData->height ?>//px',
                                    //        'form': '<?php //= UrlHelper::removeScheme(Url::to(['/app/embed'], true)) ?>//'
                                    //    };
                                    //    s.type= 'text/javascript';
                                    //    s.src = '<?php //= Url::to('@web/static_files/js/form.widget.js', true) ?>//';
                                    //    s.onload = s.onreadystatechange = function() {
                                    //        var rs = this.readyState; if (rs) if (rs !== 'complete') if (rs !== 'loaded') return;
                                    //        try {
                                    //            (new EasyForms()).initialize(options).display();
                                    //
                                    //            <?php
                                    //            if ($stripeModels != null) :
                                    //            ?>
                                    //
                                    //            $('#c<?php //= $hashId ?>//i<?php //= $hashId ?>//').on('load', () => {
                                    //                var iframe = $('#c<?php //= $hashId ?>//i<?php //= $hashId ?>//');
                                    //                var iframeContent = iframe.contents();
                                    //                var iframeWindow = iframe[0].contentWindow ? iframe[0].contentWindow : iframe[0].contentDocument.defaultView;
                                    //
                                    //                var initialVal = "";
                                    //
                                    //                <?php
                                    //
                                    //                if (!empty($stripeModels) && !empty($stripeModels[0])) {
                                    //                    $model = $stripeModels[0];
                                    //                    foreach ($model->items as $stripeItem) {
                                    //                        foreach ($formModel->formData->getLabels() as $field_name => $field_title) {
                                    //                            if ($field_name == $stripeItem->price) {
                                    //                ?>
                                    //
                                    //                var selected = iframeContent.find("input[type='radio'][name=<?php //= $field_name ?>//]");
                                    //
                                    //                // INIT
                                    //                $.each(selected, function( key, radio ) {
                                    //                    initCheckoutSummary(radio);
                                    //                });
                                    //
                                    //                var $<?php //= $field_name ?>// = iframeContent.find("input[type='radio'][name='<?php //= $field_name ?>//']").change(function () {
                                    //                    updateCheckoutSummary($<?php //= $field_name ?>//, this.value);
                                    //                });
                                    //
                                    //
                                    //                updateCheckoutQuantity('<?php //= $field_name ?>//', iframeContent.find("input[type='radio'][name='<?php //= $stripeItem->quantity ?>//']").val());
                                    //
                                    //                var $<?php //= $stripeItem->quantity ?>// = iframeContent.find("input[type='radio'][name='<?php //= $stripeItem->quantity ?>//']").change(function () {
                                    //                    updateCheckoutQuantity('<?php //= $field_name ?>//', this.value);
                                    //                });
                                    //
                                    //
                                    //                <?php
                                    //                            }
                                    //                        }
                                    //                    }
                                    //                }
                                    //                ?>
                                    //
                                    //            })
                                    //
                                    //            <?php
                                    //            endif;
                                    //            ?>
                                    //
                                    //        } catch (e) { }
                                    //
                                    //    };
                                    //    var scr = d.getElementsByTagName(t)[0], par = scr.parentNode; par.insertBefore(s, scr);
                                    //})(document, 'script');
                                </script>
                            </div>
                        </div>
                    </div>
<!--                </div>-->
<!--            </div>-->
        </div>
    </div>
    <?php else : ?>
    <div class="container-fluid">
        <div class="row row-no-gutters">
            <div class="col-12">
                <div id="c<?= $formModel->hashId ?>">
                    <main class="p-5 d-flex justify-content-center align-items-center flex-wrap">
                        <div class="spinner-border"></div>
                    </main>
                </div>
                <script type="text/javascript">
                    (function(d, t) {
                        var s = d.createElement(t), options = {
                            'id': '<?= $formModel->hashId ?>',
                            'sid': <?= $sid ?>,
                            'page': <?= $page ?>,
                            'theme': <?= $showTheme ?>,
                            'customJS': <?= $customJS ?>,
                            'reset': <?= $reset ?>,
                            'container': 'c<?= $formModel->hashId ?>',
                            'height': '<?= $formModel->formData->height ?>px',
                            'form': '<?= UrlHelper::removeScheme(Url::to(['/app/embed'], true)) ?>'
                        };
                        s.type= 'text/javascript';
                        s.src = '<?= Url::to('@web/static_files/js/form.widget.js', true) ?>';
                        s.onload = s.onreadystatechange = function() {
                            var rs = this.readyState; if (rs) if (rs !== 'complete') if (rs !== 'loaded') return;
                            try {
                                (new EasyForms()).initialize(options).display();


                            } catch (e) { }

                            //$("c<?php //= $formModel->hashId ?>//i<?php //= $formModel->hashId ?>//").on('load', function() {
                            //    // Handler for "load" called.
                            //    alert("loaded");
                            //});
                        };
                        var scr = d.getElementsByTagName(t)[0], par = scr.parentNode; par.insertBefore(s, scr);
                    })(document, 'script');
                </script>
            </div>
        </div>
    </div>
    <?php endif; ?>

<?php


if ($stripeModels != null && !empty($stripeModels[0])) {
    $model = $stripeModels[0];

    $this->registerCssFile($this->theme->getUrl('assets/css/stripe.css'));

    echo '<div style="justify-content: center;' . (!$stripeModels[0]->checkout_summary ? 'display:none;visibility:hidden;width:0px;height:0px' : '')  . '">';
    echo '<div class="stripe-checkout-container" style="flex-grow:1">';

    echo '<div class="card col-12 col-xl-8 offset-xl-2 col-xll-10 col-xll-1">';
    echo '<div id="checkoutTable_header" class="card-header bg-muted" style="padding: 10px 20px;font-weight:bold;background-color:white!important;display:inline;font-size:1.5rem">';
    echo '<div style="float:left;">Subtotal</div>';
    echo '<div id="checkoutTable_total" style="float:right;">$0</div>';
    echo '</div>';
    echo '<div id="checkoutTable_line_items" class="card-body" style="display:flex;flex-wrap:wrap;">';
//    foreach ($stripeModels as $model) {

        //$url = Url::to(['/addons/stripe/check/webhook', 'id' => $model->id], true);

        $secretKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLiveSecretKey'] : Yii::$app->params['stripeTestSecretKey']);
        $stripeService = new StripeService($secretKey);

//        $discount = $stripeService->retrieveDiscount('WEZPCQCM');
//        foreach($discount->data as $promotion)
//        {
//            echo '<div id="checkoutTable_' . $promotion->id . '" style="width:100%;display:flex;display:none;">';
//            echo '<div style="margin-right:50px;display:inline-block;">Discount: ' . $promotion->id . ':</div><div id="checkoutTable_' . $promotion->id . '_amount" style="text-align:right;display:inline-block;flex-grow:1;">-$' . $promotion->coupon->amount_off / 100.0 . '</div><div style="width:60px;text-align:right;display:inline-block">x1</div>';
//            echo '</div>';
//        }

        //print_r($discount);


        $i = 0;
        foreach ($model->items as $stripeItem) {
            foreach ($formModel->formData->getFieldsForValidation() as $field) {

                if ($field['name'] == $stripeItem->price) {
                    //print_r($field);
                    $interval = '';
                    if (str_starts_with($field['value'], 'price')) {
                        // look up price from stripe
                        $stripePrice = $stripeService->retrievePrice($field['value']);
                        //print_r($stripePrice);
                        $amount = $stripePrice->unit_amount / 100.0;
                        $interval = 'x1';
                        if ($stripePrice->type == 'recurring')
                            $interval = '/' . $stripePrice->recurring->interval;
                    } else {
                        $amount = $field['value'];
                        $interval = 'x1';
                    }

                    echo '<div id="checkoutTable_' . $field['id'] . '" style="width:100%;display:flex;">';
                    //echo '<div style="display:inline-block;">' . $stripeItem->description . ':</div><div id="checkoutTable_' . $field['id'] . '_amount" style="text-align:right;display:inline-block;flex-grow:1;width:100px;">$' . $amount . '</div><div style="width:60px;text-align:right;display:inline-block">' . $interval . '</div>';

                    echo '<div style="display:flex;flex-basis:100%">
                    <div class="line-icon">
                        <i class="' . $stripeItem->icon . ' fa-2x"></i>
                    </div>
                    <div class="line-item" style="display:block">
                        <div>' . $stripeItem->description . '</div>
                        <div id="item-details">' . $field['label'] . '</div>
                        <div id="item-quantity-display">Quantity: 1</div>
                    </div>
                    <div class="line-price" id="checkoutTable_' . $field['id'] . '_amount">' . Yii::$app->formatter->asCurrency($stripeItem->getAmounts()[$field['id']] ?? 0) . '</div>
                    <div class="line-hidden-fields" style="display:none;">
                        <input type="hidden" id="item-price" name="lineItem[' . $i . '][price]" value="' . ($stripeItem->getAmounts()[$field['id']] ?? '') . '" />
                        <input type="hidden" id="item-description" name="lineItem[' . $i . '][description]" value="' . $stripeItem->description . ': ' . $field['label'] .  '" />
                        <input type="hidden" id="item-quantity" name="lineItem[' . $i . '][quantity]" value="1" />
                        <input type="hidden" id="item-total" name="lineItem[' . $i . '][total]" value="0" />
                    </div>
                    </div>';

                    echo '</div>';

//                    echo '<pre style="display:none;">';
//                    print_r($field);
//                    echo '</pre>';
                }
            }
            $i++;
//        }
    }

    echo '</div>';
//echo '<div class="card-footer">Total:</div>';
//echo '<pre>';
//print_r($formModel->formData->getFieldsForValidation());
//echo '</pre>';
    echo '</div>';

    echo '</div>';

    echo '</div>';
}

?>
