<?php

/*
 * This file is part of the 2amigos/yii2-usuario project.
 *
 * (c) 2amigOS! <http://2amigos.us/>
 *
 * For the full copyright and license information, please view
 * the LICENSE file that was distributed with this source code.
 */

namespace Da\User\Traits;

use app\components\gmail\GmailService;
use app\helpers\MailHelper;
use Da\User\Event\MailEvent;
use Da\User\Model\User;
use Da\User\Service\MailService;
use Exception;
use Yii;
use yii\base\InvalidConfigException;
use Da\User\Module;

/**
 * @property MailService $mailService
 */
trait MailAwareTrait
{
    use ContainerAwareTrait;

    /**
     * Sends a mailer
     *
     * @param User $user
     *
     * @throws InvalidConfigException
     * @return bool
     */
    protected function sendMail(User $user)
    {
        $type = $this->mailService->getType();
        $event = $this->make(MailEvent::class, [$type, $user, $this->mailService, null]);
        $user->trigger(MailEvent::EVENT_BEFORE_SEND_MAIL, $event);



        $showPassword = false;

        /** @var Module $module */
        $module = Yii::$app->getModule('user');
        $to = $user->email;
        $from = $module->mailParams['fromEmail'];
        $subject = $module->mailParams['welcomeMailSubject'];
        $params = [
            'user' => $user,
            'token' => null,
            'module' => $module,
            'showPassword' => $showPassword,
        ];

//        static::makeMailerService(MailEvent::TYPE_WELCOME, $from, $to, $subject, 'welcome', $params);



        $output = Yii::$app->controller->render('@vendor/baluart/yii2-usuario/mail/welcome', $params);
//        $body = Yii::$app->controller->render('@app/mail/layouts/html', ['content' => $output, 'message' => '']);

        $service = new GmailService();
        $result = $service->sendMessage($service->createMessage($from, $to, '', '', '', $subject, $output));

        print_r($result);
        die();
//        try {
//            $this->mailService->run();
//        } catch (Exception $e) {
//            $event = $this->make(MailEvent::class, [$type, $user, $this->mailService, $e]);
//            Yii::error($e->getMessage(), 'usuario');
//            $user->trigger(MailEvent::EVENT_AFTER_SEND_MAIL, $event);
//            return false;
//        }




        $user->trigger(MailEvent::EVENT_AFTER_SEND_MAIL, $event);
        return true;
    }
}
