<?php

use app\helpers\Html;
use app\modules\subscription\bundles\PricingTableBundle;
use app\modules\subscription\models\Subscription;
use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;
use Carbon\Carbon;
use kartik\datecontrol\Module as DateControlModule;
use yii\helpers\Url;

/* @var $intervals array */
/** @var $subscription Subscription */
/** @var $monthlyAndYearlyPrices SubscriptionPrice[] */

$validSubscription = !empty($subscription) && $subscription->valid();

PricingTableBundle::register($this);

$this->title = Yii::t('app', 'Current Subscription Plan');
$this->params['breadcrumbs'][] = $this->title;

/** @var kartik\datecontrol\Module $dateControlModule */
$dateControlModule = Yii::$app->getModule('datecontrol');
$dateFormat = $dateControlModule->displaySettings[DateControlModule::FORMAT_DATE];

// Calculate the number of days until the subscription expires & expiration date
Carbon::setLocale(substr(Yii::$app->language, 0, 2)); // eg. en-US to en
$endsAt = null;
$diffInDays = null;
$expired = null;
$expirationDate = null;
if (!empty($subscription->ends_at)) {
    $endsAt = Carbon::createFromTimestamp($subscription->ends_at);
    $now = Carbon::now();
    $diffInDays = $now->diffInDays($endsAt, false);
    $expired = $diffInDays < 0;
    $diffInDays = $now->diffInDays($endsAt);
    $expirationDate = Yii::$app->formatter->asDate($subscription->ends_at, $dateFormat);
}

/** @var array $nextSubscription Is there a next subscription? **/
$nextSubscription = $subscription->getNextSubscription();
$nextSubscriptionTime = null;
if (isset($nextSubscription['info']['next_billing_time'])) {
    $nextSubscriptionTime = $subscription->getNextBillingTime();
}
$nextSubscriptionName = null;
if (!empty($nextSubscription['name'])) {
    $nextSubscriptionName = $nextSubscription['name'];
}

?>

<h3 class="mb-3">
    <?= Html::encode($this->title) ?>
    <?php if ($subscription->onGracePeriod() && $subscription->isRecurring()): ?>
        <small class="text-muted">
        <?= Yii::t('app', 'On Grace Period') ?>
        </small>
    <?php endif; ?>
</h3>

<div class="card mb-3" style="display:none">
    <div class="card-header">
        <h3 class="card-title"><?= $subscription->name ?></h3>
    </div>
    <div class="card-body">
        <?php if ($subscription->isRecurring()): ?>
            <?php if ($nextSubscription): ?>
                <div class="alert alert-info">
                    <span class="glyphicon glyphicon-info-sign"> </span>
                    <?= Yii::t('app', 'Your subscription will be updated to {next_subscription_name} at the end of your current billing cycle {next_subscription_time}', [
                        'next_subscription_name' => '<strong>'. $nextSubscriptionName . '</strong>',
                        'next_subscription_time' => '<strong>'. $nextSubscriptionTime . '</strong>',
                    ]) ?>
                </div>
            <?php endif; ?>
            <p style="font-weight: bold;"><?= $subscription->getCurrencySymbol() ?><?= $subscription->getAmount() ?> / <?= $subscription->displayInfo('interval') ?></p>
        <?php else: ?>
            <p style="font-weight: bold;"><?= $subscription->getCurrencySymbol() ?><?= $subscription->getAmount() ?> / <?= Yii::t('app', 'One-Time Payment') ?></p>
        <?php endif; ?>
        <p><?= $subscription->displayInfo('description') ?></p>
        <div class="plan-features">
            <?php $details = explode("\n", str_replace("\r", "", $subscription->displayInfo('details'))); ?>
            <?php foreach ($details as $detail): ?>
                <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

<!--                <p><span class="glyphicon glyphicon-ok text-success"> </span> --><?php //= $detail ?><!--</p>-->
            <?php endforeach; ?>
        </div>
        <?php if ($subscription->isRecurring()): ?>
        <p><?= Html::a(Yii::t('app', 'Change Plan'), ['/subscription/user/change'], ['class' => 'btn btn-primary']) ?></p>
        <?php endif; ?>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="pricing-switcher my-4">
            <div class="fieldset">
                <?php $i = 1; foreach ($intervals as $interval => $name): ?>
                    <input type="radio" name="duration" value="<?= $interval ?>" id="<?= $interval ?>" <?= $i === 1 ? 'checked' : '' ?>>
                    <label for="<?= $interval ?>"><?= $name ?></label>
                    <?php $i++; endforeach; ?>
                <span class="switch"></span>
            </div>
        </div>
    </div>
</div>
<div style="display:flex;column-gap:10px;justify-content: center;">
    <?php foreach ($monthlyAndYearlyPrices as $price): ?>
        <?php if ($validSubscription && $subscription && $subscription->price_id === $price->id): ?>
            <div class="card mb-3 <?= $price->interval ?>" style="flex-grow:1">
                <div class="card-header">
                    <h3 class="card-title"><?= $subscription->name ?></h3>
                </div>
                <div class="card-body">
                    <p style="font-weight: bold;"><?= $subscription->getCurrencySymbol() ?><?= $subscription->getAmount() ?> / <?= $subscription->displayInfo('interval') ?></p>
                    <p><?= $subscription->displayInfo('description') ?></p>
                    <div class="plan-features">
                        <?php $details = explode("\n", str_replace("\r", "", $subscription->displayInfo('details'))); ?>
                        <?php foreach ($details as $detail): ?>
                            <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

                            <!--                            <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer">
                    <footer class="text-center text-muted" style="min-width:145px;min-height:40px;">
                        <?= Yii::t('app', 'Currently Subscribed') ?>
                    </footer>
                </div>
            </div>
        <?php elseif ($price->product->status === SubscriptionProduct::ON): ?>
            <div class="card mb-3 <?= $price->interval ?>" style="flex-grow:1">
                <div class="card-header">
                    <h3 class="card-title"><?= $price->product->name ?></h3>
                </div>
                <div class="card-body">
                    <p style="font-weight: bold;"><?= $price->getCurrencySymbol() ?><?= $price->getFormattedAmount() ?> / <?= $price->displayInterval() ?></p>
                    <p><?= $price->description ?></p>
                    <div class="plan-features">
                        <?php $details = explode("\n", str_replace("\r", "", $price->product->details)); ?>
                        <?php foreach ($details as $detail): ?>
                            <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

                            <!--                            <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer">
                    <footer class="text-center">
                        <?php if ($validSubscription): ?>
                            <?php if ($subscription->isPaypal()): ?>
                                <?= Html::a(Yii::t('app', 'Change Plan With Next Billing Cycle'),
                                    ['/subscription/user/confirm', 'id' => $price->id], [
                                        'class' => 'btn btn-default',
                                    ]) ?>
                            <?php endif; ?>
                            <?= Html::a(Yii::t('app', 'Change Plan Now'),
                                ['/subscription/user/confirm', 'id' => $price->id, 'now' => 1], [
                                    'class' => 'btn btn-primary',
                                ]) ?>
                        <?php else: ?>
                            <?= Html::a(Yii::t('app', 'Subscribe'),
                                ['/subscription/user/confirm', 'id' => $price->id], [
                                    'class' => 'btn btn-primary',
                                ]) ?>
                        <?php endif; ?>
                    </footer>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
</div>

<div class="card mb-3">
    <div class="card-header">
        <h3 class="card-title"><?= Yii::t('app', 'Payment Method') ?></h3>
    </div>
    <div class="card-body">
        <p>
            <?= Yii::t('app', 'Your current payment method is {payment_method}.', [
                'payment_method' => '<strong style="text-transform: capitalize">' . $subscription->gateway . '</strong>',
            ]) ?>
        </p>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header">
        <h3 class="card-title"><?= Yii::t('app', 'Billing History') ?></h3>
    </div>
    <div class="card-body">
        <p>
            <?= Yii::t('app', 'If you would like to update your billing details, please submit {your_billing_information}.', [
                'your_billing_information' => Html::a('your billing information', Url::to(['/subscription/user/billing-info']))
            ]) ?>
        </p>
        <p><?= Html::a(Yii::t('app', 'View Receipts'),
            ['/subscription/user/receipts'], [
                'class' => 'btn btn-primary',
            ]) ?></p>
    </div>
</div>

<div class="card mb-3">
    <div class="card-header">
        <h3 class="card-title"><?= Yii::t('app', 'Cancel Subscription') ?></h3>
    </div>
    <div class="card-body">
        <p>
            If you would like to cancel your subscription, change your subscription plan to Basic.
        </p>
<!--        --><?php //if ($subscription->type === SubscriptionPrice::TYPE_RECURRING): ?>
<!--            --><?php //if ($subscription->onGracePeriod()): ?>
<!--                <p>--><?php //= Yii::t('app', 'Your subscription has been cancelled, however your account will stay active until the end of the current billing cycle on {expirationDate}.', [
//                        'expirationDate' => '<strong>' . $expirationDate . '<strong>',
//                    ]) ?><!--</p>-->
<!--                <p>--><?php //= Html::a(Yii::t('app', 'Cancel Now'),
//                        ['/subscription/user/cancel-now'], [
//                            'class' => 'btn btn-danger',
//                            'data-method' => 'POST',
//                            'data-confirm' => Yii::t('app', 'Are you sure you want to cancel your subscription right now?'),
//                            'data-params' => [
//                                'id' => $subscription->id,
//                            ],
//                        ]) ?><!--</p>-->
<!--            --><?php //else: ?>
<!--                <p>--><?php //= Yii::t('app', 'You may cancel your subscription at any time. Once your subscription has been cancelled, you will have the option to resume the subscription until the end of your current billing cycle.') ?><!--</p>-->
<!--                <p>--><?php //= Html::a(Yii::t('app', 'Cancel Subscription'),
//                        ['/subscription/user/cancel'], [
//                            'class' => 'btn btn-danger',
//                            'data-method' => 'POST',
//                            'data-confirm' => Yii::t('app', 'Are you sure you want to cancel your subscription?'),
//                            'data-params' => [
//                                'id' => $subscription->id,
//                            ],
//                        ]) ?><!--</p>-->
<!--            --><?php //endif; ?>
<!--        --><?php //else: ?>
<!--            --><?php //if ($expired): ?>
<!--                <p>--><?php //= Yii::t('app', 'Your subscription expired {n,plural,=0{today} =1{# day} other{# days}} ago on {expirationDate}', [
//                        'n' => $diffInDays,
//                        'expirationDate' => $expirationDate,
//                    ]) ?><!--</p>-->
<!--            --><?php //else: ?>
<!--                <p>--><?php //= Yii::t('app', 'Your subscription will end in {diffInDays} days on {expirationDate}', [
//                        'diffInDays' => $diffInDays,
//                        'expirationDate' => $expirationDate,
//                    ]) ?><!--</p>-->
<!--                <p>--><?php //= Html::a(Yii::t('app', 'Cancel Now'),
//                        ['/subscription/user/cancel-now'], [
//                            'class' => 'btn btn-danger',
//                            'data-method' => 'POST',
//                            'data-confirm' => Yii::t('app', 'Are you sure you want to cancel your subscription right now? You will lose all the features and benefits of your current plan. This action cannot be undone.'),
//                            'data-params' => [
//                                'id' => $subscription->id,
//                            ],
//                        ]) ?><!--</p>-->
<!--            --><?php //endif; ?>
<!--        --><?php //endif; ?>
    </div>
</div>