<?php

use app\components\widgets\PageSizeDropDownList;
use app\helpers\IconHelper;
use kartik\grid\ActionColumn;
use kartik\switchinput\SwitchInput;
use yii\helpers\Url;
use yii\helpers\Html;
use app\components\widgets\GridView;
use app\components\widgets\ActionBar;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\subscription\models\search\SubscriptionTransactionSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Receipts');
$this->params['breadcrumbs'][] = $this->title;

// User Preferences
$showFilters = Yii::$app->user->preferences->get('GridView.filters.state') === '1';

$options = array(
    'currentPage' => Url::toRoute(['/subscription/user/receipts']), // Used by filters
    'gridViewSettingsEndPoint' => Url::to(['/ajax/grid-view-settings']),
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", View::POS_BEGIN, 'form-options');

$gridColumns = [
    [
        'attribute' => 'id',
        'label' => '#',
        'value' => function ($model) {
            return $model->id;
        }
    ],
    [
        'attribute' => 'gateway',
        'value' => function ($model) {
            return isset($model->gateway) ? ucfirst($model->gateway) : null;
        },
        'noWrap'=>true,
    ],
    [
        'attribute' => 'currency_code',
        'value' => function ($model) {
            return $model->getFormattedCurrencyCode();
        },
        'noWrap'=>true,
    ],
    [
        'attribute' => 'total',
        'value' => function ($model) {
            return $model->getFormattedAmount();
        },
        'noWrap'=>true,
    ],
    [
        'attribute'=> 'gateway_time',
        'value' => function ($model) {
            return $model->updated;
        },
        'label' => Yii::t('app', 'Date'),
        'noWrap'=>true,
        'filterType'=> \kartik\grid\GridView::FILTER_DATE_RANGE,
        'filterWidgetOptions' => [
            'presetDropdown' => false,
            'convertFormat' => true,
            'containerTemplate' => '
                <div class="form-control kv-drp-dropdown">
                    <i class="glyphicon glyphicon-calendar"></i>&nbsp;
                    <span class="range-value">{value}</span>
                    <span><b class="caret"></b></span>
                </div>
                {input}
            ',
            'pluginOptions' => [
                'showDropdowns' => true,
                'locale' => [
                    'format' => 'Y-m-d',
                    'separator' => ' - ',
                ],
                'opens' => 'left'
            ]
        ],
    ],

    [
        'class' => ActionColumn::class,
        'buttons' => [
            //view button
            'view' => function ($url) {
                return '<li>'.Html::a(
                        '<span class="me-2">' . IconHelper::show('file-info') . '</span>' . Yii::t('app', 'View Receipt'),
                        $url,
                        ['title' => Yii::t('app', 'View Receipt'), 'class' => 'dropdown-item']
                    ) .'</li>';
            },
        ],
        'urlCreator' => function ($action, $model) {
            if ($action === "view") {
                return Url::to(['/subscription/user/receipt', 'id' => $model->id]);
            }
            return '';
        },
        'template' => '{view}'
    ],
];
?>
<div class="subscription-transaction-index">
    <div class="row">
        <div class="col-md-12">
            <?= GridView::widget([
                'id' => 'subscription-transaction-grid',
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => $gridColumns,
                'resizableColumns' => false,
                'pjax' => false,
                'export' => false,
                'responsive' => true,
                'responsiveWrap' => false,
                'bordered' => false,
                'striped' => true,
                'tableOptions' => [
                    'class' => $showFilters
                        ? 'table-with-filters table-vcenter card-table'
                        : 'table-vcenter card-table',
                ],
                'panelTemplate' =>'{panelHeading}{panelBefore}{items}{panelFooter}',
                'panel'=>[
                    'type' => GridView::TYPE_DEFAULT,
                    'headingOptions' => [
                        'class' => 'card-header',
                    ],
                    'footerOptions' => [
                        'class' => 'card-footer d-flex align-items-center',
                    ],
                    'heading' => Yii::t('app', 'Receipts')
                        . ' <small class="ms-3 text-muted d-none d-sm-inline">'
                        . Yii::t('app', 'Billing history')
                        . ' </small>',
                    'before'=> ActionBar::widget([
                        'grid' => 'subscription-transaction-grid',
                        'templates' => [
                            '{message}' => ['class' => 'col-8'],
                            '{filters}' => ['class' => 'col-4'],
                        ],
                        'elements' => [
                            'message' => '<p style="margin: 6px 0 0 0;">'. Yii::t('app', 'We provide here the comprehensive list of all transactions relating to your account.') .'</p>',
                            'filters' => SwitchInput::widget(
                                [
                                    'name'=>'filters',
                                    'type' => SwitchInput::CHECKBOX,
                                    'value' => $showFilters,
                                    'pluginOptions' => [
                                        'size' => 'mini',
                                        'animate' => false,
                                        'labelText' => Yii::t('app', 'Filter'),
                                    ],
                                    'pluginEvents' => [
                                        "switchChange.bootstrapSwitch" => "function(event, state) {
                                                    var show = (typeof state !== 'undefined' && state == 1) ? 1 : 0;
                                                    $.post(options.gridViewSettingsEndPoint, { 'show-filters': show })
                                                        .done(function(response) {
                                                            if (response.success) {
                                                                if (show) {
                                                                    $('.filters').fadeIn();
                                                                } else {
                                                                    $('.filters').fadeOut();
                                                                    window.location = options.currentPage;
                                                                }                   
                                                            }
                                                        });
                                                }",
                                    ],
                                    'containerOptions' => ['style' => 'margin-top: 6px; text-align: right'],
                                ]
                            ),
                        ],
                        'class' => 'form-control',
                    ]),
                ],
                'replaceTags' => [
                    '{pageSize}' => function($widget) {
                        $html = '';
                        if ($widget->panelFooterTemplate !== false) {
                            $selectedSize = Yii::$app->user->preferences->get('GridView.pagination.pageSize');
                            return PageSizeDropDownList::widget(['selectedSize' => $selectedSize]);
                        }
                        return $html;
                    },
                ],
                'panelFooterTemplate' => '
                    {pager}{pageSize}
                ',
                'toolbar' => false
            ]); ?>
        </div>
    </div>
</div>