<?php

use app\modules\subscription\models\SubscriptionTransaction;
use yii\helpers\Html;
use yii\helpers\Url;

/**
 * @var yii\web\View $this
 * @var SubscriptionTransaction $model
 */

$this->title = Yii::t('app', 'Receipt');

// Global settings
$settings = Yii::$app->settings;
// Home URL
$homeUrl = Url::home(true);
// Brand
$appName = Yii::$app->settings->get("app.name");
$brandLabel = Html::tag("span", $appName, ["class" => "app-name"]);
if ($logo = Yii::$app->settings->get("logo", "app", null)) {
    $brandLabel = Html::img(Url::to('@web/static_files/uploads' . '/' . $logo, true), [
        'height' => '26px',
        'alt' => $appName,
        'title' => $appName,
    ]);
}
// Body
$this->registerCss("body { background-color: #EFF3F6; } iframe { border-radius: 0 0 4px 4px; } ");
?>
<div class="container">
    <div class="row app-form">
        <div class="col-12 col-sm-8 col-sm-offset-2 col-md-6 col-md-offset-3">
            <div class="card">
                <div class="card-header d-print-none">
                    <h3 class="card-title">
                        <?= Html::a(
                            $brandLabel,
                            $homeUrl,
                            [
                                "title" => Yii::$app->settings->get("app.description"),
                                "style" => 'text-decoration:none',
                            ]
                        ) ?>
                    </h3>
                </div>
                <div class="card-body">
                    <h3 style="margin-top: 10px"><?= Yii::t('app', 'Receipt') ?> #<?= $model->id ?></h3>
                    <div class="row">
                        <div class="col-6">
                            <p><strong><?= Yii::t('app', 'Receipt to') ?></strong></p>
                            <?php if (!empty($model->billingInfo->user_id)): ?>
                                <p><strong><?= $model->billingInfo->first_name ?> <?= $model->billingInfo->last_name ?></strong>
                                    <?php if (!empty($model->billingInfo->organization)): ?><br><strong><?= $model->billingInfo->organization ?></strong><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->email)): ?><br><?= $model->billingInfo->email ?><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->phone)): ?><br><?= $model->billingInfo->phone ?><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->tax_id)): ?><br><?= $model->billingInfo->tax_id ?><?php endif; ?>
                                </p>
                                <p><?= $model->billingInfo->address ?>
                                    <?php if (!empty($model->billingInfo->address_line_2)): ?><br><?= $model->billingInfo->address_line_2 ?><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->city)): ?><br><?= $model->billingInfo->city ?><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->state)): ?><?= $model->billingInfo->state ?><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->zip)): ?><?= $model->billingInfo->zip ?><?php endif; ?>
                                    <?php if (!empty($model->billingInfo->country)): ?><br><?= $model->billingInfo->country ?><?php endif; ?>
                                </p>
                            <?php else: ?>
                                <p><?= Html::a(Yii::t('app', 'Add billing information'), ['/subscription/user/billing-info'], ['class' => 'd-print-none']) ?></p>
                            <?php endif; ?>
                        </div>
                        <div class="col-6 text-right">
                            <p><strong><?= Yii::t('app', 'Receipt from') ?></strong></p>
                                <p><?php if (!empty($settings->get('subscription.firstName'))): ?><strong><?= $settings->get('subscription.firstName') ?></strong><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.lastName'))): ?><strong><?= $settings->get('subscription.lastName') ?></strong><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.organization'))): ?><br><strong><?= $settings->get('subscription.organization') ?></strong><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.email'))): ?><br><?= $settings->get('subscription.email') ?><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.phone'))): ?><br><?= $settings->get('subscription.phone') ?><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.taxId'))): ?><br><?= $settings->get('subscription.taxId') ?><?php endif; ?>
                                </p>
                                <p><?= $settings->get('subscription.address') ?>
                                    <?php if (!empty($settings->get('subscription.addressLine2'))): ?><br><?= $settings->get('subscription.addressLine2') ?><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.city'))): ?><br><?= $settings->get('subscription.city') ?><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.state'))): ?><?= $settings->get('subscription.state') ?><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.zip'))): ?><?= $settings->get('subscription.zip') ?><?php endif; ?>
                                    <?php if (!empty($settings->get('subscription.country'))): ?><br><?= $settings->get('subscription.country') ?><?php endif; ?>
                                </p>
                        </div>
                    </div>
                    <table class="table table-bordered" style="margin-top: 10px">
                        <tr>
                            <td>
                                <?= Yii::t('app', 'Date') ?>
                            </td>
                            <td>
                                <?= $model->gateway_time ? Yii::$app->formatter->asDatetime($model->gateway_time, $model->getDateTimeFormat()) : null ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?= Yii::t('app', 'Plan') ?>
                            </td>
                            <td>
                                <?= $model->subscription->name; ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?= Yii::t('app', 'Transaction ID') ?>
                            </td>
                            <td>
                                <?= $model->gateway_transaction_id ? $model->gateway_transaction_id : $model->gateway_id ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?= Yii::t('app', 'Gateway') ?>
                            </td>
                            <td style="text-transform: capitalize">
                                <?= $model->gateway ?>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <?= Yii::t('app', 'Amount') ?>
                            </td>
                            <td>
                                <?= $model->getFormattedCurrencyCode() ?> <?= $model->getFormattedAmount() ?>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="card-footer">
                    <?= Html::a(Yii::t('app', 'Back'), ['/subscription/user/receipts'], ['class' => 'btn btn-default d-print-none']) ?>
                    <?= Html::a(Yii::t('app', 'Print'), ['/subscription/users/receipts'], ['id' => 'print', 'class' => 'btn btn-primary d-print-none']) ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
$script = <<< JS
$( document ).ready(function(){
    $( "#print" ).click(function(e) {
        e.preventDefault();
        window.print();
    });    
})

JS;
$this->registerJs($script, $this::POS_END);
?>
