<?php

use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;
use app\modules\subscription\services\StripeClient;
use yii\helpers\Url;

/* @var $price SubscriptionPrice */
/* @var $subscription app\modules\subscription\models\Subscription|null */
/* @var $now int 1 or 0 */


// Plan Type
$isRecurring = $price->type === SubscriptionPrice::TYPE_RECURRING ? 1 : 0;
$stripePlanId = null;
$intent = null;

if ($isRecurring) {

    // Stripe Plan ID
    $stripePlanId = $price->getStripeId();

}
?>
<style>
    .hidden {
        display:none;
    }
</style>
<div class="stripe-button-container" style="width: 80%; margin-top: 30px">
    <form id="stripe-form" class="form-vertical" action="<?= Url::to(['/subscription/user/create']) ?>" method="post">
        <input type="hidden" name="<?= Yii::$app->request->csrfParam; ?>" value="<?= Yii::$app->request->csrfToken; ?>" />
        <input type="hidden" name="id" value="<?= $price->id ?>">
        <button class="btn btn-primary btn-block">
            <span class="spinner hidden" id="spinner"></span>
            <span class="fas fa-cart-plus" style="margin: 0 5px"></span>
            <span id="button-text">
                <?= Yii::t('app', 'Go to Checkout') ?>
            </span>
        </button>
        <div class="text-danger">
            <p id="card-error" role="alert"></p>
        </div>
        <p class="result-message <?=(!empty(Yii::$app->request->get('payment')) && Yii::$app->request->get('payment') == 'paid' ) ? '' : 'hidden' ?>">
            <?= Yii::t('app', 'Subscription succeeded!') ?>
        </p>
    </form>
</div>