<?php

use yii\helpers\Html;
use yii\helpers\Url;

/* @var $price app\modules\subscription\models\SubscriptionPrice */
/* @var $subscription app\modules\subscription\models\Subscription */
/* @var $now int 1 or 0 */
/* @var $stripeInvoice Stripe\Invoice|null */
/* @var $hasPaymentMethod bool */
/* @var $paymentMethod string|null */

?>
<h4><?= Yii::t('app', 'Are you sure you want to change your subscription plan?') ?></h4>
<p><?= Yii::t('app', 'Before proceeding, please note that:') ?></p>
<ul>
    <li><?= Yii::t('app', 'The change will be made effective immediately.') ?></li>
    <li><?= Yii::t('app', 'Apply charges immediately, including a prorated charge based on the price difference of the updated subscription.') ?></li>
    <?php if ($stripeInvoice->total > 0): ?>
    <li><?= Yii::t('app', 'Prorated charge') ?>: <strong><?= strtoupper($stripeInvoice->currency) ?> <?= $stripeInvoice->total/100 ?></strong></li>
    <?php else: ?>
        <li><?= Yii::t('app', 'Prorated charge') ?>: <strong><?= strtoupper($stripeInvoice->currency) ?> 0.00</strong></li>
    <?php endif; ?>
</ul>

<div>
    <p <?= $hasPaymentMethod ? 'style="display:none"' : '' ?>>
        Note: We do not have payment details saved on file. Please submit payment details before changing subscription.<br /><br />
        <?= Html::a(Yii::t('app', 'Submit Payment Details'),
            ['/subscription/user/collect-payment-method'], [
                'class' => 'btn btn-success',
                'data-method' => 'POST',
                'data-params' => [
                    'id' => $subscription->id,
                    'price_id' => $price->id,
                    'return_url' => Url::to([
                        '/subscription/user/confirm',
                        'id' => Yii::$app->request->get('id'),
                        'now' => Yii::$app->request->get('now'),
                        ], true),
                ],
            ]) ?>
    </p>
    <p><?= Html::a(Yii::t('app', 'Change Now'),
            ['/subscription/user/change-stripe-plan'], [
                'class' => 'btn btn-danger ' . (!$hasPaymentMethod ? 'disabled' : ''),
                'data-method' => 'POST',
                'data-confirm' => Yii::t('app', 'Are you sure you want to change your subscription right now?'),
                'data-params' => [
                    'id' => $subscription->id,
                    'price_id' => $price->id,
                ],
            ]) ?></p>
</div>