<?php

use app\helpers\Html;
use app\modules\subscription\bundles\PricingTableBundle;
use app\modules\subscription\models\Subscription;
use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;

/** @var $products SubscriptionProduct[] */
/* @var $switcher boolean */
/* @var $intervals array */
/** @var $subscription Subscription */
/** @var $monthlyAndYearlyPrices SubscriptionPrice[] */
/** @var $otherRecurringPrices SubscriptionPrice[] */
/** @var $oneTimePrices SubscriptionPrice[] */
/** @var $validSubscription bool */

PricingTableBundle::register($this);

$validSubscription = !empty($subscription) && $subscription->valid();

$this->title = $validSubscription ? Yii::t('app', 'Change Subscription Plan') : Yii::t('app', 'Subscribe');
$this->params['breadcrumbs'][] = $this->title;

?>

<div id="subscription-products">
    <h3 style="margin: 5px 0 15px 0"><?= Html::encode($this->title) ?></h3>

    <?php if (!$validSubscription): ?>
        <!-- Alert. -->
        <div class="alert alert-primary alert-dismissible m-0">
            <div class="d-flex">
                <div>
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <circle cx="12" cy="12" r="9"></circle>
                        <line x1="12" y1="8" x2="12.01" y2="8"></line>
                        <polyline points="11 12 12 12 12 16 13 16"></polyline>
                    </svg>
                </div>                                <div>
                    <h4 class="alert-title"><?= Yii::t('app', 'Did you know?') ?></h4>
                    <div class="text-muted">
                        <?= Yii::t(
                            'app',
                            'It looks like you do not have an active subscription. You may choose one of the subscription plans below to get started. Subscription plans may be changed or cancelled at your convenience.'
                        ) ?>
                    </div>
                </div>
            </div>
            <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
        </div>
        <!-- / Alert. -->
        <?= Yii::$app->settings->get('subscription.defaultUserLimits') ?>
    <?php endif; ?>

    <div class="row">
        <div class="col-12">
            <div class="pricing-switcher my-4">
                <div class="fieldset">
                    <?php $i = 1; foreach ($intervals as $interval => $name): ?>
                        <input type="radio" name="duration" value="<?= $interval ?>" id="<?= $interval ?>" <?= $i === 1 ? 'checked' : '' ?>>
                        <label for="<?= $interval ?>"><?= $name ?></label>
                        <?php $i++; endforeach; ?>
                    <span class="switch"></span>
                </div>
            </div>
        </div>
    </div>
    <div style="display:flex;column-gap:10px;justify-content: center;">
    <?php foreach ($monthlyAndYearlyPrices as $price): ?>
        <?php if ($validSubscription && $subscription && $subscription->price_id === $price->id): ?>
            <div class="card mb-3 <?= $price->interval ?>" style="flex-grow:1">
                <div class="card-header">
                    <h3 class="card-title"><?= $subscription->name ?></h3>
                </div>
                <div class="card-body">
                    <p style="font-weight: bold;"><?= $subscription->getCurrencySymbol() ?><?= $subscription->getAmount() ?> / <?= $subscription->displayInfo('interval') ?></p>
                    <p><?= $subscription->displayInfo('description') ?></p>
                    <div class="plan-features">
                        <?php $details = explode("\n", str_replace("\r", "", $subscription->displayInfo('details'))); ?>
                        <?php foreach ($details as $detail): ?>
                            <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

<!--                            <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer">
                    <footer class="text-center text-muted" style="margin: 3px 0">
                        <?= Yii::t('app', 'Currently Subscribed') ?>
                    </footer>
                </div>
            </div>
        <?php elseif ($price->product->status === SubscriptionProduct::ON): ?>
            <div class="card mb-3 <?= $price->interval ?>" style="flex-grow:1">
                <div class="card-header">
                    <h3 class="card-title"><?= $price->product->name ?></h3>
                </div>
                <div class="card-body">
                    <p style="font-weight: bold;"><?= $price->getCurrencySymbol() ?><?= $price->getFormattedAmount() ?> / <?= $price->displayInterval() ?></p>
                    <p><?= $price->description ?></p>
                    <div class="plan-features">
                        <?php $details = explode("\n", str_replace("\r", "", $price->product->details)); ?>
                        <?php foreach ($details as $detail): ?>
                            <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

<!--                            <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="card-footer">
                    <footer class="text-center">
                        <?php if ($validSubscription): ?>
                            <?php if ($subscription->isPaypal()): ?>
                                <?= Html::a(Yii::t('app', 'Change Plan With Next Billing Cycle'),
                                    ['/subscription/user/confirm', 'id' => $price->id], [
                                        'class' => 'btn btn-default',
                                    ]) ?>
                            <?php endif; ?>
                            <?= Html::a(Yii::t('app', 'Change Plan Now'),
                                ['/subscription/user/confirm', 'id' => $price->id, 'now' => 1], [
                                    'class' => 'btn btn-primary',
                                ]) ?>
                        <?php else: ?>
                            <?= Html::a(Yii::t('app', 'Subscribe'),
                                ['/subscription/user/confirm', 'id' => $price->id], [
                                    'class' => 'btn btn-primary',
                                ]) ?>
                        <?php endif; ?>
                    </footer>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
    </div>

    <?php if (count($otherRecurringPrices) > 0): ?>
        <h3 style="margin: 5px 0 15px 0"><?= Yii::t('app', 'Other Recurring Plans') ?></h3>
        <?php foreach ($otherRecurringPrices as $price): ?>
            <?php if ($price->product->status === SubscriptionProduct::ON && $validSubscription && $subscription && $subscription->price_id === $price->id): ?>
                <div class="card mb-3 <?= $price->interval ?>">
                    <div class="card-header">
                        <h3 class="card-title"><?= $subscription->name ?></h3>
                    </div>
                    <div class="card-body">
                        <p style="font-weight: bold;"><?= $subscription->getCurrencySymbol() ?><?= $subscription->getAmount() ?> / <?= $subscription->displayInfo('interval') ?></p>
                        <p><?= $subscription->displayInfo('description') ?></p>
                        <div class="plan-features">
                            <?php $details = explode("\n", str_replace("\r", "", $subscription->displayInfo('details'))); ?>
                            <?php foreach ($details as $detail): ?>
<!--                                <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                                <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="card-footer">
                        <footer class="text-center text-muted" style="margin: 3px 0">
                            <?= Yii::t('app', 'Currently Subscribed') ?>
                        </footer>
                    </div>
                </div>
            <?php elseif ($price->product->status === SubscriptionProduct::ON): ?>
                <div class="card mb-3 <?= $price->interval ?>">
                    <div class="card-header">
                        <h3 class="card-title"><?= $price->product->name ?></h3>
                    </div>
                    <div class="card-body">
                        <p style="font-weight: bold;"><?= $price->getCurrencySymbol() ?><?= $price->getFormattedAmount() ?> / <?= $price->displayInterval() ?></p>
                        <p><?= $price->description ?></p>
                        <div class="plan-features">
                            <?php $details = explode("\n", str_replace("\r", "", $price->product->details)); ?>
                            <?php foreach ($details as $detail): ?>
                                <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

<!--                                <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="card-footer">
                        <footer class="text-center">
                            <?= Html::a(Yii::t('app', 'Subscribe'),
                                ['/subscription/user/confirm', 'id' => $price->id], [
                                    'class' => 'btn btn-primary',
                                ]) ?>
                        </footer>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>

    <?php if (count($oneTimePrices) > 0): ?>
        <h3 style="margin: 5px 0 15px 0"><?= Yii::t('app', 'One-Time Payment Plans') ?></h3>
        <?php foreach ($oneTimePrices as $price): ?>
            <?php if ($price->product->status === SubscriptionProduct::ON && $validSubscription && $subscription && $subscription->price_id === $price->id): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h3 class="card-title"><?= $subscription->name ?></h3>
                    </div>
                    <div class="card-body">
                        <p style="font-weight: bold;"><?= $subscription->getCurrencySymbol() ?><?= $subscription->getAmount() ?> / <?= Yii::t('app', 'One-Time Payment') ?></p>
                        <p><?= $subscription->displayInfo('description') ?></p>
                        <div class="plan-features">
                            <?php $details = explode("\n", str_replace("\r", "", $subscription->displayInfo('details'))); ?>
                            <?php foreach ($details as $detail): ?>
                                <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

<!--                                <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="card-footer">
                        <footer class="text-center text-muted" style="margin: 3px 0">
                            <?= Yii::t('app', 'Currently Subscribed') ?>
                        </footer>
                    </div>
                </div>
            <?php elseif ($price->product->status === SubscriptionProduct::ON): ?>
                <div class="card mb-3">
                    <div class="card-header">
                        <h3 class="card-title"><?= $price->product->name ?></h3>
                    </div>
                    <div class="card-body">
                        <p style="font-weight: bold;"><?= $price->getCurrencySymbol() ?><?= $price->getFormattedAmount() ?> / <?= Yii::t('app', 'One-Time Payment') ?></p>
                        <p><?= $price->description ?></p>
                        <div class="plan-features">
                            <?php $details = explode("\n", str_replace("\r", "", $price->product->details)); ?>
                            <?php foreach ($details as $detail): ?>
                                <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

<!--                                <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <div class="card-footer">
                        <footer class="text-center">
                            <?= Html::a(Yii::t('app', 'Subscribe'),
                                ['/subscription/user/confirm', 'id' => $price->id], [
                                    'class' => 'btn btn-primary',
                                ]) ?>
                        </footer>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
