<?php

use app\helpers\Html;
use app\modules\subscription\models\Subscription;
use kartik\datecontrol\Module as DateControlModule;

/* @var $price app\modules\subscription\models\SubscriptionPrice */
/* @var $subscription app\modules\subscription\models\Subscription */
/* @var $now int|null */
/* @var $stripeInvoice \Stripe\Invoice|null */
/* @var $hasPaymentMethod bool */
/* @var $paymentMethod string|null */

$this->title = Yii::t('app', 'Subscribe');
$this->params['breadcrumbs'][] = $this->title;

$changeSubscription = $subscription && !$subscription->cancelled() ? 1 : 0;
$stripeIntegration = Yii::$app->settings->get('subscription.stripeIntegration');

/** @var kartik\datecontrol\Module $dateControlModule */
$dateControlModule = Yii::$app->getModule('datecontrol');
$dateFormat = $dateControlModule->displaySettings[DateControlModule::FORMAT_DATE];
$nextBillingTime = null;
if ($changeSubscription) {
    $nextBillingTime = $subscription->getNextBillingTime();
}
?>

<div id="subscription-product">
    <h3 style="margin: 5px 0 15px 0">
        <?= Html::encode($this->title) ?>
    </h3>

    <?php if (!$changeSubscription): ?>
        <!-- Alert. -->
        <div class="alert alert-primary alert-dismissible">
            <div class="d-flex">
                <div>
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                        <circle cx="12" cy="12" r="9"></circle>
                        <line x1="12" y1="8" x2="12.01" y2="8"></line>
                        <polyline points="11 12 12 12 12 16 13 16"></polyline>
                    </svg>
                </div>                                <div>
                    <h4 class="alert-title"><?= Yii::t('app', 'Did you know?') ?></h4>
                    <div class="text-muted">
                        <?= Yii::t('app','Select your payment method, confirm your subscription and enjoy all the features and benefits. Subscription plans may be changed or cancelled at your convenience.') ?>
                    </div>
                </div>
            </div>
            <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
        </div>
        <!-- / Alert. -->
    <?php endif; ?>

    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <div class="card-header">
                    <?php if ($price->isRecurring()): ?>
                        <?= Yii::t('app', 'Confirm subscription') ?>
                    <?php else: ?>
                        <?= Yii::t('app', 'Confirm order') ?>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-header">
                                    <?= Yii::t('app', 'Plan') ?>: <?= $price->product->name ?>
                                </div>
                                <div class="card-body">
                                    <p style="font-weight: bold;"><?= $price->currency_code ?><?= $price->getFormattedAmount() ?> / <?= $price->interval ?></p>
                                    <p><?= $price->product->description ?></p>
                                    <div class="features">
                                        <?php $details = explode("\n", str_replace("\r", "", $price->product->details)); ?>
                                        <?php foreach ($details as $detail): ?>
                                            <p><?= str_replace('[x]','<svg xmlns="http://www.w3.org/2000/svg" width="8" height="8" viewBox="0 0 24 24" style="margin-bottom:3px;margin-right:7px;fill:red;"><path d="M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z"/></svg>',str_replace('[check]', '<svg xmlns="http://www.w3.org/2000/svg" width="10" height="10" viewBox="0 0 24 24" style="margin-right:5px;fill:green;"><path d="M20.285 2l-11.285 11.567-5.286-5.011-3.714 3.716 9 8.728 15-15.285z"/></svg>', $detail)) ?></p>

                                            <!--                                            <p><span class="fas fa-check me-1 text-success"> </span> --><?php //= $detail ?><!--</p>-->
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-8">
                            <?php if ($changeSubscription): ?>
                                <?php if ($subscription->isPaypal()): ?>
                                    <?php if ($now): ?>
                                        <?= $this->render('partials/_paypal-change-now'); ?>
                                        <?= $this->render('partials/_paypal-button', ['price'=> $price, 'subscription' => $subscription, 'now' => 1] ); ?>
                                    <?php else: ?>
                                        <?= $this->render('partials/_paypal-change-with-billing-cycle', ['nextBillingTime'=> $nextBillingTime] ); ?>
                                        <?= $this->render('partials/_paypal-button', ['price'=> $price, 'subscription' => $subscription, 'now' => 0] ); ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?= $this->render('partials/_stripe-change-now', ['price'=> $price, 'subscription' => $subscription, 'now' => 1, 'stripeInvoice' => $stripeInvoice, 'paymentMethod' => $paymentMethod, 'hasPaymentMethod' => $hasPaymentMethod]); ?>
                                <?php endif; ?>
                            <?php else: ?>
                                <div class="form-group">
                                    <div class="inline-control inline-control-radio">
                                        <label class="form-label"><?= Yii::t('app', 'Payment Method') ?></label>
                                        <?php if ($price->hasPaypalId() || !$price->isRecurring()): ?>
                                        <input type="radio" id="payment-method-paypal" name="payment-method" value="paypal" checked>
                                        <label for="payment-method-paypal" class="radio-inline"><?= Yii::t('app', 'PayPal') ?></label>
                                        <?php endif; ?>
                                        <?php if ($price->hasStripeId() || !$price->isRecurring()): ?>
                                        <input type="radio" id="payment-method-stripe" name="payment-method" value="stripe"<?php if (!$price->hasPaypalId() && $price->isRecurring()): ?> checked<?php endif; ?>>
                                        <label for="payment-method-stripe" class="radio-inline"><?= Yii::t('app', 'Stripe') ?></label>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if ($price->hasPaypalId() || !$price->isRecurring()): ?>
                                <div id="paypal-button">
                                    <?= $this->render('partials/_paypal-button', ['price'=> $price, 'subscription' => null, 'now' => 1] ); ?>
                                </div>
                                <?php endif; ?>
                                <?php if ($price->hasStripeId() || !$price->isRecurring()): ?>
                                    <div id="stripe-button">
                                        <?php if ($stripeIntegration === Subscription::STRIPE_ELEMENTS): ?>
                                            <?= $this->render('partials/_stripe-button', ['price'=> $price, 'subscription' => null, 'now' => 1] ); ?>
                                        <?php else: ?>
                                            <?= $this->render('partials/_stripe-checkout', ['price'=> $price, 'subscription' => null, 'now' => 1] ); ?>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="subscription-pending" style="display: none">
    <h3 style="margin: 5px 0 15px 0"><?= Yii::t('app', 'Subscription Pending') ?></h3>
    <div class="alert alert-warning alert-dismissible m-0">
        <div class="d-flex">
            <div>
                <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <circle cx="12" cy="12" r="9"></circle>
                    <line x1="12" y1="8" x2="12.01" y2="8"></line>
                    <polyline points="11 12 12 12 12 16 13 16"></polyline>
                </svg>
            </div>
            <div>
                <h4 class="alert-title"><?= Yii::t('app', 'Did you know?') ?></h4>
                <div class="text-muted">
                    <?= Yii::t('app', 'We are processing your subscription. Once the subscription has successfully processed, this page will update automatically. Typically, this process should only take a few seconds.') ?>
                </div>
            </div>
        </div>
        <a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>
    </div>
</div>

<?php

$script = <<<JS

    $(document).ready(function(){
        // Handlers
        var toggleSettings = function () {
            if ($("#payment-method-paypal").is(":checked") === true) {
                $("#paypal-button").show();
                $("#stripe-button").hide();
            } else {
                $("#paypal-button").hide();
                $("#stripe-button").show();
            }
        };
        $('input[type="radio"]').click(function(e){
            toggleSettings()
        });
        toggleSettings();
    });

JS;

$this->registerJs($script, $this::POS_END);
