<?php

use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;
use yii\helpers\Url;

/* @var $intervals array */
/** @var $monthlyAndYearlyPrices SubscriptionPrice[] */

$this->title = Yii::$app->settings->get('app.name');

?>
<!-- Main content -->
<section class="py-5 bg-dark">
    <div class="container">
        <div class="row row-grid align-items-center">
            <div class="row justify-content-center text-center">
                <div class="col-lg-6">
                    <h1 class="my-4">
                        Terms and Conditions for Verso Forms
                    </h1>
                    <div class="mt-2">
                        <p class="lead">
                            Effective Date: 1-1-2024
                        </p>
                    </div>
                </div>
            </div>


            <h2 class="my-4">
                1. Introduction
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    Welcome to Verso Forms! These Terms and Conditions govern your use of our drag-and-drop form builder web service. By accessing or using our services, you agree to be bound by these terms. If you do not agree with any part of these terms, please do not use our services.
                </h3>
            </div>

            <h2 class="my-4">
                2. Account Registration
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    2.1. To use our services, you may be required to create an account. You agree to provide accurate, current, and complete information during the registration process.<br /><br />

                    2.2. You are responsible for maintaining the confidentiality of your account credentials and for all activities that occur under your account.
                </h3>
            </div>

            <h2 class="my-4">
                3. Use of Services
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    3.1. You may use our services for lawful purposes and in compliance with these terms and all applicable laws and regulations.<br /><br />

                    3.2. You agree not to engage in any activity that disrupts or interferes with the functioning of our platform.
                </h3>
            </div>

            <h2 class="my-4">
                4. Intellectual Property
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    4.1. The content and features of our platform, including but not limited to trademarks, logos, and designs, are the intellectual property of Verso Forms and are protected by applicable copyright, trademark, and other laws.<br /><br />

                    4.2. You may not use our intellectual property without our explicit permission.

                </h3>
            </div>

            <h2 class="my-4">
                5. User-Generated Content
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    5.1. By creating and publishing forms on our platform, you retain ownership of the content you generate.<br /><br />

                    5.2. You grant Verso Forms a worldwide, non-exclusive, royalty-free license to use, modify, and distribute the content you generate for the purpose of providing our services.
                </h3>
            </div>

            <h2 class="my-4">
                6. Payments and Billing
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    6.1. If you choose to purchase a subscription, you agree to pay all applicable fees as described on our pricing page.<br /><br />

                    6.2. Payments are processed through secure third-party payment processors, and we do not store your payment information.
                </h3>
            </div>

            <h2 class="my-4">
                7. Privacy
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    7.1. Your use of our services is subject to our Privacy Policy, which outlines how we collect, use, and protect your personal information.                </h3>
            </div>

            <h2 class="my-4">
                8. Limitation of Liability
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    8.1. To the extent permitted by law, Verso Forms shall not be liable for any indirect, incidental, special, or consequential damages arising out of or in any way connected with your use of our services.
                </h3>
            </div>

            <h2 class="my-4">
                9. Termination
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    9.1. We reserve the right to terminate or suspend your access to our services for any reason, without notice.
                </h3>
            </div>

            <h2 class="my-4">
                10. Changes to Terms and Conditions
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    10.1. We may update these Terms and Conditions to reflect changes in our practices or for other operational, legal, or regulatory reasons. We will notify you of any material changes through the platform or via email.
                </h3>
            </div>

            <h2 class="my-4">
                11. Governing Law
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    11.1. These Terms and Conditions are governed by the laws of [Your Jurisdiction], without regard to its conflict of laws principles.
                </h3>
            </div>

            <h2 class="my-4">
                12. Contact Us
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    If you have any questions or concerns about these Terms and Conditions, please contact us at admin@versoforms.com
                </h3>
            </div>
        </div>
    </div>
</section>
<footer class="position-relative" id="footer-main">
    <div class="footer pt-lg-7 footer-dark bg-light">
        <!-- Footer -->
        <div class="container pt-4">
            <div class="row">
                <div class="col-12 col-lg-4">
                    <!-- Brand -->
                    <?= $this->render('@app/themes/next/views/partials/_brand') ?>
                    <!-- Mission -->
                    <p class="my-4 fs-3" style="color:black;">
                        <?= Yii::t('app', 'A complete and customizable solution for building professional online forms.') ?>
                    </p>
                    <!-- Social -->
                    <ul class="nav mb-4">
                        <li class="nav-item">
                            <a class="nav-link ps-0" href="#" target="_blank">
                                <i class="fab fa-dribbble"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-github"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-facebook"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2 offset-lg-2">
                    <h3 class="mb-3" style="color:black;">
                        <?= Yii::t('app', 'Account') ?>
                    </h3>
                    <ul class="list-unstyled">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                <li>
                                    <a href="<?= Url::to(['/user/registration/register']) ?>" style="color:black;">
                                        <?= Yii::t('app', 'Sign Up') ?>
                                    </a>
                                </li>
                            <?php endif ?>
                            <li>
                                <a href="<?= Url::to(['/user/security/login']) ?>" style="color:black;">
                                    <?= Yii::t('app', 'Login') ?>
                                </a>
                            </li>
                        <?php else: ?>
                        <li>
                            <a href="<?= Url::to(['/dashboard']) ?>">
                                <?= Yii::t('app', 'Dashboard') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/user/settings/profile']) ?>">
                                <?= Yii::t('app', 'Profile') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/subscription/user/index']) ?>">
                                <?= Yii::t('app', 'Billing') ?>
                            </a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="mb-3" style="color:black;"><?= Yii::t('app', 'About') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="<?= Url::to(['/subscription/public/about']) ?>" style="color:black;"><?= Yii::t('app', 'Overview') ?></a></li>
                        <li><a href="/#pricing" style="color:black;"><?= Yii::t('app', 'Pricing') ?></a></li>
                        <li><a href="<?= Url::to(['/user/security/contact']) ?>" style="color:black;"><?= Yii::t('app', 'Contact') ?></a></li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="mb-3" style="color:black;"><?= Yii::t('app', 'Company') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="/documentation" style="color:black;"><?= Yii::t('app', 'Help Center') ?></a></li>
                        <li><a href="<?= Url::to(['/user/security/contact']) ?>" style="color:black;"><?= Yii::t('app', 'Support') ?></a></li>
                    </ul>
                </div>
            </div>
            <hr class="divider divider-fade divider-dark my-4">
            <div class="row align-items-center justify-content-md-between pb-4">
                <div class="col-md-6">
                    <div class="copyright text-sm font-weight-bold">
                        &copy; <?= date('Y') ?> <?= Yii::$app->settings->get("app.name") ?>. <?= Yii::t('app', 'All rights reserved.') ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <ul class="nav justify-content-center justify-content-md-end mt-3 mt-md-0">
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/terms']) ?>">
                                <?= Yii::t('app', 'Terms') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/privacy']) ?>">
                                <?= Yii::t('app', 'Privacy') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/cookies']) ?>">
                                <?= Yii::t('app', 'Cookies') ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php

$styles = <<<CSS

/* Preloader */
@keyframes hidePreloader {
    0% {
        width: 100%;
        height: 100%;
    }

    100% {
        width: 0;
        height: 0;
    }
}

body>div.preloader {
    position: fixed;
    background: #313941;
    width: 100%;
    height: 100%;
    z-index: 1071;
    opacity: 0;
    transition: opacity .5s ease;
    overflow: hidden;
    pointer-events: none;
    display: flex;
    align-items: center;
    justify-content: center;
}

body:not(.loaded)>div.preloader {
    opacity: 1;
}

body:not(.loaded) {
    overflow: hidden;
}

body.loaded>div.preloader {
    animation: hidePreloader .5s linear .5s forwards;
}

/* Pricing switcher */

.pricing-switcher {
    text-align: center;
}
.pricing-switcher .fieldset {
    display: inline-block;
    position: relative;
    padding: 2px;
    border-radius: 50em;
    border: 1px solid #92a1ad;
}
.pricing-switcher input[type="radio"] {
    position: absolute;
    opacity: 0;
}
.pricing-switcher label {
    position: relative;
    z-index: 1;
    display: inline-block;
    float: left;
    width: 90px;
    height: 36px;
    line-height: 36px;
    cursor: pointer;
    margin: 0;
    color: rgba(var(--tblr-muted-rgb),var(--tblr-text-opacity));
}
.pricing-switcher .switch {
    /* floating background */
    position: absolute;
    top: 2px;
    left: 2px;
    height: 36px;
    width: 90px;
    background-color: white;/*var(--tblr-primary);*/
    border-radius: 50em;
    -webkit-transition: -webkit-transform 0.5s;
    -moz-transition: -moz-transform 0.5s;
    transition: transform 0.5s;
}
.pricing-switcher input[type="radio"]:checked + label + .switch,
.pricing-switcher input[type="radio"]:checked + label:nth-of-type(n) + .switch {
    /* use label:nth-of-type(n) to fix a bug on safari with multiple adjacent-sibling selectors*/
    -webkit-transform: translateX(90px);
    -moz-transform: translateX(90px);
    -ms-transform: translateX(90px);
    -o-transform: translateX(90px);
    transform: translateX(90px);
}
.pricing-switcher input[type="radio"]:checked+label{
    color: #000000;
}
.no-js .pricing-switcher {
    display: none;
}


CSS;

$this->registerCss($styles);

$script = <<<JS

window.addEventListener("load", function() {
    setTimeout(function() {
        document.querySelector('body').classList.add('loaded');
    }, 300);
});

$(document).ready(function(){

    // Handlers
    var togglePlans = function () {
        if ($("#month").is(":checked") === true) {
            $(".year").hide();
            $(".month").fadeIn(600);
        } else {
            $(".month").hide();
            $(".year").fadeIn(600);
        }
    };

    $('input[name="duration"]').click(function(){
        togglePlans()
    });

    togglePlans();

});

JS;

$this->registerJs($script, $this::POS_END);

?>