<?php

use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;
use yii\helpers\Url;

/* @var $intervals array */
/** @var $monthlyAndYearlyPrices SubscriptionPrice[] */

$this->title = Yii::$app->settings->get('app.name');

?>
<!-- Main content -->
<section class="py-5 bg-dark">
    <div class="container">
        <div class="row row-grid align-items-center">
            <div class="row justify-content-center text-center">
                <div class="col-lg-6">
                    <h1 class="my-4">
                        Privacy Policy for Verso Forms
                    </h1>
                    <div class="mt-2">
                        <p class="lead">
                            Effective Date: 1-1-2024
                        </p>
                    </div>
                </div>
            </div>


            <h2 class="my-4">
                1. Introduction
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    Welcome to Verso Forms! We are committed to protecting your privacy and providing a safe, secure environment for you to use our services. This Privacy Policy outlines how we collect, use, disclose, and protect your personal information. By using our services, you consent to the practices described in this policy.
                </h3>
            </div>

            <h2 class="my-4">
                2. Information We Collect
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    We may collect the following types of information:<br /><br />

                    Personal Information: When you sign up for an account, we may collect your name, email address, and other contact information.<br />
                    Billing Information: If you choose to purchase a subscription, we may collect billing details such as credit card information.<br />
                    Usage Information: We collect data about how you interact with our platform, including the forms you create and the features you use.<br />
                    Device and Log Information: We may collect information about the device you use to access our services, including IP address, browser type, and operating system.<br />
                    Cookies and Similar Technologies: We use cookies and similar technologies to enhance your experience and for analytics purposes.

                </h3>
            </div>

            <h2 class="my-4">
                3. How We Use Your Information
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    We use the information we collect for various purposes, including:<br /><br />

                    Providing and improving our services.<br />
                    Personalizing your experience.<br />
                    Responding to your inquiries and support requests.<br />
                    Processing transactions and sending billing notifications.<br />
                    Analyzing usage patterns and trends to optimize our platform.<br />
                    Complying with legal and regulatory requirements.

                </h3>
            </div>

            <h2 class="my-4">
                4. How We Share Your Information
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    We do not sell, trade, or rent your personal information to third parties. However, we may share your information in the following circumstances:<br /><br />

                    Service Providers: We may engage third-party service providers to assist us in delivering our services, subject to appropriate data protection agreements.<br />
                    Legal Compliance: We may disclose information if required by law, regulation, or legal process.<br />
                    Business Transfers: In the event of a merger, acquisition, or sale of all or part of our assets, your information may be transferred to the acquiring entity.


                </h3>
            </div>

            <h2 class="my-4">
                5. Your Choices
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    You have the right to:<br /><br />

                    Access and update your personal information.<br />
                    Opt out of receiving marketing communications.<br />
                    Close your account and have your information deleted.

                </h3>
            </div>

            <h2 class="my-4">
                6. Security
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    We implement reasonable security measures to protect your information from unauthorized access, alteration, disclosure, or destruction.
                </h3>
            </div>

            <h2 class="my-4">
                7. Children's Privacy
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    Our services are not directed to children under the age of 13, and we do not knowingly collect personal information from them.
                </h3>
            </div>

            <h2 class="my-4">
                8. Changes to this Privacy Policy
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    We may update this Privacy Policy to reflect changes in our practices or for other operational, legal, or regulatory reasons. We will notify you of any material changes through the platform or via email.
                </h3>
            </div>

            <h2 class="my-4">
                9. Contact Us
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    If you have any questions, concerns, or requests regarding this Privacy Policy, please contact us at admin@versoforms.com
                </h3>
            </div>
        </div>
    </div>
</section>
<footer class="position-relative" id="footer-main">
    <div class="footer pt-lg-7 footer-dark bg-light">
        <!-- Footer -->
        <div class="container pt-4">
            <div class="row">
                <div class="col-12 col-lg-4">
                    <!-- Brand -->
                    <?= $this->render('@app/themes/next/views/partials/_brand') ?>
                    <!-- Mission -->
                    <p class="my-4 fs-3" style="color:black;">
                        <?= Yii::t('app', 'A complete and customizable solution for building professional online forms.') ?>
                    </p>
                    <!-- Social -->
                    <ul class="nav mb-4">
                        <li class="nav-item">
                            <a class="nav-link ps-0" href="#" target="_blank">
                                <i class="fab fa-dribbble"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-github"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-facebook"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2 offset-lg-2">
                    <h3 class="mb-3" style="color:black;">
                        <?= Yii::t('app', 'Account') ?>
                    </h3>
                    <ul class="list-unstyled">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                <li>
                                    <a href="<?= Url::to(['/user/registration/register']) ?>" style="color:black;">
                                        <?= Yii::t('app', 'Sign Up') ?>
                                    </a>
                                </li>
                            <?php endif ?>
                            <li>
                                <a href="<?= Url::to(['/user/security/login']) ?>" style="color:black;">
                                    <?= Yii::t('app', 'Login') ?>
                                </a>
                            </li>
                        <?php else: ?>
                        <li>
                            <a href="<?= Url::to(['/dashboard']) ?>">
                                <?= Yii::t('app', 'Dashboard') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/user/settings/profile']) ?>">
                                <?= Yii::t('app', 'Profile') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/subscription/user/index']) ?>">
                                <?= Yii::t('app', 'Billing') ?>
                            </a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="mb-3" style="color:black;"><?= Yii::t('app', 'About') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="<?= Url::to(['/subscription/public/about']) ?>" style="color:black;"><?= Yii::t('app', 'Overview') ?></a></li>
                        <li><a href="/#pricing" style="color:black;"><?= Yii::t('app', 'Pricing') ?></a></li>
                        <li><a href="<?= Url::to(['/user/security/contact']) ?>" style="color:black;"><?= Yii::t('app', 'Contact') ?></a></li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="mb-3" style="color:black;"><?= Yii::t('app', 'Company') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="/documentation" style="color:black;"><?= Yii::t('app', 'Help Center') ?></a></li>
                        <li><a href="<?= Url::to(['/user/security/contact']) ?>" style="color:black;"><?= Yii::t('app', 'Support') ?></a></li>
                    </ul>
                </div>
            </div>
            <hr class="divider divider-fade divider-dark my-4">
            <div class="row align-items-center justify-content-md-between pb-4">
                <div class="col-md-6">
                    <div class="copyright text-sm font-weight-bold">
                        &copy; <?= date('Y') ?> <?= Yii::$app->settings->get("app.name") ?>. <?= Yii::t('app', 'All rights reserved.') ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <ul class="nav justify-content-center justify-content-md-end mt-3 mt-md-0">
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/terms']) ?>">
                                <?= Yii::t('app', 'Terms') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/privacy']) ?>">
                                <?= Yii::t('app', 'Privacy') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/cookies']) ?>">
                                <?= Yii::t('app', 'Cookies') ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php

$styles = <<<CSS

/* Preloader */
@keyframes hidePreloader {
    0% {
        width: 100%;
        height: 100%;
    }

    100% {
        width: 0;
        height: 0;
    }
}

body>div.preloader {
    position: fixed;
    background: #313941;
    width: 100%;
    height: 100%;
    z-index: 1071;
    opacity: 0;
    transition: opacity .5s ease;
    overflow: hidden;
    pointer-events: none;
    display: flex;
    align-items: center;
    justify-content: center;
}

body:not(.loaded)>div.preloader {
    opacity: 1;
}

body:not(.loaded) {
    overflow: hidden;
}

body.loaded>div.preloader {
    animation: hidePreloader .5s linear .5s forwards;
}

/* Pricing switcher */

.pricing-switcher {
    text-align: center;
}
.pricing-switcher .fieldset {
    display: inline-block;
    position: relative;
    padding: 2px;
    border-radius: 50em;
    border: 1px solid #92a1ad;
}
.pricing-switcher input[type="radio"] {
    position: absolute;
    opacity: 0;
}
.pricing-switcher label {
    position: relative;
    z-index: 1;
    display: inline-block;
    float: left;
    width: 90px;
    height: 36px;
    line-height: 36px;
    cursor: pointer;
    margin: 0;
    color: rgba(var(--tblr-muted-rgb),var(--tblr-text-opacity));
}
.pricing-switcher .switch {
    /* floating background */
    position: absolute;
    top: 2px;
    left: 2px;
    height: 36px;
    width: 90px;
    background-color: white;/*var(--tblr-primary);*/
    border-radius: 50em;
    -webkit-transition: -webkit-transform 0.5s;
    -moz-transition: -moz-transform 0.5s;
    transition: transform 0.5s;
}
.pricing-switcher input[type="radio"]:checked + label + .switch,
.pricing-switcher input[type="radio"]:checked + label:nth-of-type(n) + .switch {
    /* use label:nth-of-type(n) to fix a bug on safari with multiple adjacent-sibling selectors*/
    -webkit-transform: translateX(90px);
    -moz-transform: translateX(90px);
    -ms-transform: translateX(90px);
    -o-transform: translateX(90px);
    transform: translateX(90px);
}
.pricing-switcher input[type="radio"]:checked+label{
    color: #000000;
}
.no-js .pricing-switcher {
    display: none;
}


CSS;

$this->registerCss($styles);

$script = <<<JS

window.addEventListener("load", function() {
    setTimeout(function() {
        document.querySelector('body').classList.add('loaded');
    }, 300);
});

$(document).ready(function(){

    // Handlers
    var togglePlans = function () {
        if ($("#month").is(":checked") === true) {
            $(".year").hide();
            $(".month").fadeIn(600);
        } else {
            $(".month").hide();
            $(".year").fadeIn(600);
        }
    };

    $('input[name="duration"]').click(function(){
        togglePlans()
    });

    togglePlans();

});

JS;

$this->registerJs($script, $this::POS_END);

?>