<?php

use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;
use yii\helpers\Url;

/* @var $intervals array */
/** @var $monthlyAndYearlyPrices SubscriptionPrice[] */

$this->title = Yii::$app->settings->get('app.name');

?>
<!-- Main content -->
<section class="py-5 bg-dark">
    <div class="container">
        <div class="row row-grid align-items-center">
            <div class="row justify-content-center text-center">
                <div class="col-lg-6">
                    <h1 class="my-4">
                        About Verso Forms
                    </h1>

                </div>
            </div>


            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5"><br />
                    Welcome to Verso Forms, where we believe that creating forms should be simple, intuitive, and hassle-free. Our platform empowers individuals and businesses to design and deploy customized forms with ease.
                </h3>
            </div>

<!--            <h2 class="mb-3">-->
<!--                About Verso Forms-->
<!--            </h2>-->
<!--            <p class="text-muted fs-3 text-muted-light">-->
<!--                Welcome to Verso Forms, where we believe that creating forms should be simple, intuitive, and hassle-free. Our platform empowers individuals and businesses to design and deploy customized forms with ease.-->
<!--                <br /><br />-->
<!--            </p>-->

            <h2 class="my-4">
                Our Mission
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    At Verso Forms, we are dedicated to revolutionizing the way you interact with data. We understand the importance of collecting information efficiently and securely. Our mission is to provide a user-friendly, drag-and-drop form builder that streamlines the process of creating and managing forms for a wide range of applications.
                </h3>
            </div>

            <h2 class="my-4">
                What Sets Us Apart
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    Intuitive Design: Our user-friendly interface allows you to effortlessly design and customize forms to suit your unique needs.<br /><br />

                    Versatility: Whether you need contact forms, surveys, event registrations, or more, Verso Forms adapts to your requirements.<br /><br />

                    Security & Compliance: We prioritize the security of your data. Our platform adheres to industry-leading standards to ensure your information is safe.<br /><br />

                    Innovation and Adaptability: We are committed to staying at the forefront of technology, constantly updating our platform to meet the evolving demands of form creation.
                </h3>
            </div>

            <h2 class="my-4">
                Our Team
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    Behind Verso Forms is a team of dedicated professionals who are passionate about providing you with the best form-building experience. With a diverse range of skills and expertise, we work collaboratively to bring you an innovative and reliable platform.
                </h3>
            </div>

            <h2 class="my-4">
                Get Started with Verso Forms
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                Join us in simplifying your form-building journey. Whether you're an individual, a small business, or an enterprise, Verso Forms is designed to meet your needs. Create, deploy, and manage forms effortlessly, all in one place.
                </h3>
            </div>

            <h2 class="my-4">
                Contact Us
            </h2>
            <div class="mt-2">
                <h3 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                If you have any questions or would like to learn more about Verso Forms, please don't hesitate to contact us.<br /><br />

                Thank you for choosing Verso Forms. We look forward to helping you create powerful, effective forms.
                </h3>
            </div>

        </div>
    </div>
</section>
<footer class="position-relative" id="footer-main">
    <div class="footer pt-lg-7 footer-dark bg-light">
        <!-- Footer -->
        <div class="container pt-4">
            <div class="row">
                <div class="col-12 col-lg-4">
                    <!-- Brand -->
                    <?= $this->render('@app/themes/next/views/partials/_brand') ?>
                    <!-- Mission -->
                    <p class="my-4 fs-3" style="color:black;">
                        <?= Yii::t('app', 'A complete and customizable solution for building professional online forms.') ?>
                    </p>
                    <!-- Social -->
                    <ul class="nav mb-4">
                        <li class="nav-item">
                            <a class="nav-link ps-0" href="#" target="_blank">
                                <i class="fab fa-dribbble"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-github"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-facebook"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2 offset-lg-2">
                    <h3 class="mb-3" style="color:black;">
                        <?= Yii::t('app', 'Account') ?>
                    </h3>
                    <ul class="list-unstyled">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                <li>
                                    <a href="<?= Url::to(['/user/registration/register']) ?>" style="color:black;">
                                        <?= Yii::t('app', 'Sign Up') ?>
                                    </a>
                                </li>
                            <?php endif ?>
                            <li>
                                <a href="<?= Url::to(['/user/security/login']) ?>" style="color:black;">
                                    <?= Yii::t('app', 'Login') ?>
                                </a>
                            </li>
                        <?php else: ?>
                        <li>
                            <a href="<?= Url::to(['/dashboard']) ?>">
                                <?= Yii::t('app', 'Dashboard') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/user/settings/profile']) ?>">
                                <?= Yii::t('app', 'Profile') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/subscription/user/index']) ?>">
                                <?= Yii::t('app', 'Billing') ?>
                            </a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="mb-3" style="color:black;"><?= Yii::t('app', 'About') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="<?= Url::to(['/subscription/public/about']) ?>" style="color:black;"><?= Yii::t('app', 'Overview') ?></a></li>
                        <li><a href="/#pricing" style="color:black;"><?= Yii::t('app', 'Pricing') ?></a></li>
                        <li><a href="<?= Url::to(['/user/security/contact']) ?>" style="color:black;"><?= Yii::t('app', 'Contact') ?></a></li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="mb-3" style="color:black;"><?= Yii::t('app', 'Company') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="/documentation" style="color:black;"><?= Yii::t('app', 'Help Center') ?></a></li>
                        <li><a href="<?= Url::to(['/user/security/contact']) ?>" style="color:black;"><?= Yii::t('app', 'Support') ?></a></li>
                    </ul>
                </div>
            </div>
            <hr class="divider divider-fade divider-dark my-4">
            <div class="row align-items-center justify-content-md-between pb-4">
                <div class="col-md-6">
                    <div class="copyright text-sm font-weight-bold">
                        &copy; <?= date('Y') ?> <?= Yii::$app->settings->get("app.name") ?>. <?= Yii::t('app', 'All rights reserved.') ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <ul class="nav justify-content-center justify-content-md-end mt-3 mt-md-0">
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/terms']) ?>">
                                <?= Yii::t('app', 'Terms') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/privacy']) ?>">
                                <?= Yii::t('app', 'Privacy') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?= Url::to(['/subscription/public/cookies']) ?>">
                                <?= Yii::t('app', 'Cookies') ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php

$styles = <<<CSS

/* Preloader */
@keyframes hidePreloader {
    0% {
        width: 100%;
        height: 100%;
    }

    100% {
        width: 0;
        height: 0;
    }
}

body>div.preloader {
    position: fixed;
    background: #313941;
    width: 100%;
    height: 100%;
    z-index: 1071;
    opacity: 0;
    transition: opacity .5s ease;
    overflow: hidden;
    pointer-events: none;
    display: flex;
    align-items: center;
    justify-content: center;
}

body:not(.loaded)>div.preloader {
    opacity: 1;
}

body:not(.loaded) {
    overflow: hidden;
}

body.loaded>div.preloader {
    animation: hidePreloader .5s linear .5s forwards;
}

/* Pricing switcher */

.pricing-switcher {
    text-align: center;
}
.pricing-switcher .fieldset {
    display: inline-block;
    position: relative;
    padding: 2px;
    border-radius: 50em;
    border: 1px solid #92a1ad;
}
.pricing-switcher input[type="radio"] {
    position: absolute;
    opacity: 0;
}
.pricing-switcher label {
    position: relative;
    z-index: 1;
    display: inline-block;
    float: left;
    width: 90px;
    height: 36px;
    line-height: 36px;
    cursor: pointer;
    margin: 0;
    color: rgba(var(--tblr-muted-rgb),var(--tblr-text-opacity));
}
.pricing-switcher .switch {
    /* floating background */
    position: absolute;
    top: 2px;
    left: 2px;
    height: 36px;
    width: 90px;
    background-color: white;/*var(--tblr-primary);*/
    border-radius: 50em;
    -webkit-transition: -webkit-transform 0.5s;
    -moz-transition: -moz-transform 0.5s;
    transition: transform 0.5s;
}
.pricing-switcher input[type="radio"]:checked + label + .switch,
.pricing-switcher input[type="radio"]:checked + label:nth-of-type(n) + .switch {
    /* use label:nth-of-type(n) to fix a bug on safari with multiple adjacent-sibling selectors*/
    -webkit-transform: translateX(90px);
    -moz-transform: translateX(90px);
    -ms-transform: translateX(90px);
    -o-transform: translateX(90px);
    transform: translateX(90px);
}
.pricing-switcher input[type="radio"]:checked+label{
    color: #000000;
}
.no-js .pricing-switcher {
    display: none;
}


CSS;

$this->registerCss($styles);

$script = <<<JS

window.addEventListener("load", function() {
    setTimeout(function() {
        document.querySelector('body').classList.add('loaded');
    }, 300);
});

$(document).ready(function(){

    // Handlers
    var togglePlans = function () {
        if ($("#month").is(":checked") === true) {
            $(".year").hide();
            $(".month").fadeIn(600);
        } else {
            $(".month").hide();
            $(".year").fadeIn(600);
        }
    };

    $('input[name="duration"]').click(function(){
        togglePlans()
    });

    togglePlans();

});

JS;

$this->registerJs($script, $this::POS_END);

?>