<?php

use app\helpers\Html;
use app\helpers\IconHelper;
use app\helpers\Language;
use app\modules\subscription\bundles\LandingBundle;
use yii\helpers\Url;

/* @var $this \yii\web\View */
/* @var $content string */

LandingBundle::register($this);

$moduleID = $this->context->module->id;
$controllerID = $this->context->id;
$actionID = $this->context->action->id;
$userModule = Yii::$app->getModule('user');

// Brand
$appName = Yii::$app->settings->get("app.name");
$brandLabel = Html::tag("span", $appName, ["class" => "app-name"]);
$brandStyle = 'padding: 15px';
if ($logo = Yii::$app->settings->get("logo", "app", null)) {
    $brandLabel = Html::img(Url::to('@web/themes/classic/assets/uploads' . '/' . $logo, true), [
        'height' => '32px',
        'alt' => $appName,
        'title' => $appName,
        'class' => 'navbar-brand-image',
    ]);
    $brandStyle = 'padding: 5px 15px';
}
// Theme
$themeMode = Yii::$app->user->preferences->get('UI.theme.mode', 'theme-light');
?>
<?php $this->beginPage() ?>
    <!doctype html>
    <html lang="<?= Yii::$app->language ?>" dir="<?php echo Language::dir(); ?>">
    <head>
        <meta property="og:site_name" content="Verso Forms"/>
        <meta charset="<?= Yii::$app->charset ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
        <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
        <meta name="generator" content="<?= Yii::$app->name ?> <?= Yii::$app->version ?>"/>
        <link rel="shortcut icon" href="<?= Yii::$app->getHomeUrl() ?>favicon.ico" type="image/x-icon">
        <link rel="icon" href="<?= Yii::$app->getHomeUrl() ?>favicon_32.png" sizes="32x32">
        <link rel="icon" href="<?= Yii::$app->getHomeUrl() ?>favicon_48.png" sizes="48x48">
        <link rel="icon" href="<?= Yii::$app->getHomeUrl() ?>favicon_96.png" sizes="96x96">
        <link rel="icon" href="<?= Yii::$app->getHomeUrl() ?>favicon_144.png" sizes="144x144">
        <?= Html::csrfMetaTags() ?>
        <title><?= Html::encode($this->title) ?></title>
        <meta name="msapplication-TileColor" content=""/>
        <meta name="theme-color" content=""/>
        <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"/>
        <meta name="apple-mobile-web-app-capable" content="yes"/>
        <meta name="mobile-web-app-capable" content="yes"/>
        <meta name="HandheldFriendly" content="True"/>
        <meta name="MobileOptimized" content="320"/>
        <!-- CSS files -->
        <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/libs/fontawesome/css/all.css') ?>">
        <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/tabler.min.css') ?>">
        <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/tabler-flags.min.css') ?>">
        <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/tabler-payments.min.css') ?>">
        <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/tabler-vendors.min.css') ?>">
        <link rel="stylesheet" href="<?= $this->theme->getUrl('assets/css/app.min.css') ?>">
        <!-- CSS files -->
        <style>
            .text-muted-light {
                color: var(--tblr-secondary-color)!important;
            }
        </style>
        <?php $this->head() ?>
    </head>
    <body class="main <?= $themeMode ?> <?= $controllerID ?> <?= $controllerID ?>-<?= $actionID ?> bg-light" data-bs-theme="dark">
    <?php $this->beginBody() ?>
    <div class="page">
        <header class="navbar navbar-dark navbar-expand-md navbar-overlap d-print-none bg-light" data-bs-theme="dark">
            <div class="container-xl">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu" aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <h1 class="navbar-brand navbar-brand-autodark d-none-navbar-horizontal pe-0 pe-md-3">
                    <!-- Brand -->
                    <?= $this->render('@app/themes/next/views/partials/_brand', [
                        'brandHeight' => '40px',
                    ]) ?>
                </h1>
                <div class="navbar-nav flex-row order-md-last">
                    <div class="collapse navbar-collapse">
                        <div class="d-flex flex-column flex-md-row flex-fill align-items-stretch align-items-md-center">
                            <ul class="navbar-nav d-none d-md-flex">
                                <li class="nav-item">
                                    <a class="nav-link" href="#overview">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Overview') ?>
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#pricing">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Pricing') ?>
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="<?= Url::to(['/user/security/contact/']) ?>">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Contact Us') ?>
                                        </span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="/documentation">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Help Center') ?>
                                        </span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="btn-list">
                            <!-- Button -->
                            <?php if (Yii::$app->user->isGuest): ?>
                                <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                    <a class="btn btn-dark bg-dark" href="<?= Url::to(['/user/registration/register']) ?>">
                                        <?= Yii::t('app', 'Sign Up') ?>
                                    </a>
                                <?php endif; ?>
                                <a class="btn btn-dark bg-dark" href="<?= Url::to(['/user/security/login']) ?>">
                                    <?= Yii::t('app', 'Login') ?>
                                </a>
                            <?php else: ?>
                                <a class="btn btn-dark" href="<?= Url::to(['/dashboard']) ?>">
                                    <?= Yii::t('app', 'Dashboard') ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <header class="navbar-expand-md">
            <div class="navbar-collapse collapse" id="navbar-menu" style="">
                <div class="navbar navbar-dark d-md-none">
                    <div class="container-xl">
                        <ul class="navbar-nav">
                            <li class="nav-item">
                                <a class="nav-link" href="#overview">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Overview') ?>
                                        </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#pricing">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Pricing') ?>
                                        </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="<?= Url::to(['/user/security/contact/']) ?>">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Contact Us') ?>
                                        </span>
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="/documentation">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Help Center') ?>
                                        </span>
                                </a>
                            </li>
                            <?php if (Yii::$app->user->isGuest): ?>
                                <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                    <li class="nav-item">
                                        <a class="nav-link" href="<?= Url::to(['/user/registration/register']) ?>">
                                            <span class="nav-link-title">
                                                <?= Yii::t('app', 'Sign Up') ?>
                                            </span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <li class="nav-item">
                                    <a class="nav-link text-pink" href="<?= Url::to(['/user/security/login']) ?>">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Login') ?>
                                        </span>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="nav-item">
                                    <a class="nav-link text-pink" href="<?= Url::to(['/dashboard']) ?>">
                                        <span class="nav-link-title">
                                            <?= Yii::t('app', 'Dashboard') ?>
                                        </span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </header>
        <div class="page-wrapper">
            <?= $content ?>
        </div>
    </div>
    <?php $this->endBody() ?>
    </body>
    </html>
<?php $this->endPage() ?>