<?php

use app\components\widgets\ActiveForm;
use yii\helpers\Html;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $form ActiveForm */

$this->title = Yii::t('app', 'Subscription Settings');
$this->params['breadcrumbs'][] = ['label' => $this->title];

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body theme-create">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card mb-3">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Environment'), 'subscription_environment', ['class' => 'form-label']) ?>
                                    <?= Select2::widget([
                                        'name' => 'subscription_environment',
                                        'data' => [
                                            'sandbox' => Yii::t('app', 'Sandbox / Test'),
                                            'production' => Yii::t('app', 'Live / Production'),
                                        ],
                                        'value' => Yii::$app->settings->get('subscription.environment'),
                                    ]); ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Paypal Webhook ID'), 'subscription_paypalLiveWebhookId', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_paypalLiveWebhookId', Yii::$app->settings->get('subscription.paypalLiveWebhookId'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Paypal Webhook ID (Sandbox)'), 'subscription_paypalSandboxWebhookId', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_paypalSandboxWebhookId', Yii::$app->settings->get('subscription.paypalSandboxWebhookId'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <?= Html::hiddenInput('action', 'global-settings'); ?>
                                    <?= Html::submitButton(Html::tag('i', '', [
                                            'class' => 'glyphicon glyphicon-ok',
                                            'style' => 'margin-right: 2px;',
                                        ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
                <div class="card mb-3">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Yii::t('app', 'Default User Limits') ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Form Limit'), 'subscription_formLimit', ['class' => 'form-label']) ?>
                                    <?= Html::input('number', 'subscription_formLimit', Yii::$app->settings->get('subscription.formLimit'), [
                                        'class' => 'form-control',
                                        'min' => '1',
                                        'max' => '99999999999',
                                        'maxlength' => '11',
                                        'placeholder' => 5,
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Submission Limit'), 'subscription_submissionLimit', ['class' => 'form-label']) ?>
                                    <?= Html::input('number', 'subscription_submissionLimit', Yii::$app->settings->get('subscription.submissionLimit'), [
                                        'class' => 'form-control',
                                        'min' => '1',
                                        'max' => '99999999999',
                                        'maxlength' => '11',
                                        'placeholder' => 100,
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Trial Days'), 'subscription_trialDays', ['class' => 'form-label']) ?>
                                    <?= Html::input('number', 'subscription_trialDays', Yii::$app->settings->get('subscription.trialDays'), [
                                        'class' => 'form-control',
                                        'min' => '1',
                                        'max' => '365',
                                        'maxlength' => '11',
                                        'placeholder' => 14,
                                    ]) ?>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Branding in Embed Code'), 'subscription_branding', ['class' => 'form-label']) ?>
                                    <?= SwitchInput::widget([
                                        'name'=>'subscription_branding',
                                        'value' => (boolean) Yii::$app->settings->get('subscription.branding'),
                                        'pluginOptions' => [
                                            'onColor' => 'primary',
                                        ],
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class='row'>
                            <div class='col-sm-12'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'User Limits Description'), 'subscription_defaultUserLimits', ['class' => 'form-label']) ?>
                                    <?= Html::textarea('subscription_defaultUserLimits', Yii::$app->settings->get('subscription.defaultUserLimits'), ['class' => 'form-control', 'id' => 'subscription_defaultUserLimits']) ?>
                                    <div class="hint-block"><?= Yii::t(
                                            'app',
                                            'Allowed HTML tags. This description will be displayed in the Subscription page.'
                                        ) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <?= Html::hiddenInput('action', 'default-user-limits'); ?>
                                    <?= Html::submitButton(Html::tag('i', '', [
                                            'class' => 'glyphicon glyphicon-ok',
                                            'style' => 'margin-right: 2px;',
                                        ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                    <div class="card-footer">
                        <span class="text-muted">
                            <?= Yii::t('app', 'Used by default user role when unsubscribed users have application access.') ?>
                        </span>
                    </div>
                </div>
                <div class="card mb-3">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Yii::t('app', 'Company Information') ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                        <div class='row'>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'First Name'), 'subscription_firstName', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_firstName', Yii::$app->settings->get('subscription.firstName'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Last Name'), 'subscription_lastName', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_lastName', Yii::$app->settings->get('subscription.lastName'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Email Address'), 'subscription_email', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_email', Yii::$app->settings->get('subscription.email'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Phone'), 'subscription_phone', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_phone', Yii::$app->settings->get('subscription.phone'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Organization'), 'subscription_organization', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_organization', Yii::$app->settings->get('subscription.organization'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Address'), 'subscription_address', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_address', Yii::$app->settings->get('subscription.address'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Address Line 2'), 'subscription_addressLine2', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_addressLine2', Yii::$app->settings->get('subscription.addressLine2'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Country'), 'subscription_country', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_country', Yii::$app->settings->get('subscription.country'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'City'), 'subscription_city', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_city', Yii::$app->settings->get('subscription.city'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Zip Code'), 'subscription_zip', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_zip', Yii::$app->settings->get('subscription.zip'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'State'), 'subscription_state', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_state', Yii::$app->settings->get('subscription.state'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group mb-3">
                                    <?= Html::label(Yii::t('app', 'Tax ID'), 'subscription_taxId', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'subscription_taxId', Yii::$app->settings->get('subscription.taxId'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <?= Html::hiddenInput('action', 'billing-information'); ?>
                                    <?= Html::submitButton(Html::tag('i', '', [
                                            'class' => 'glyphicon glyphicon-ok',
                                            'style' => 'margin-right: 2px;',
                                        ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                    <div class="card-footer">
                        <div class="text-muted">
                            <?= Yii::t('app', 'This information will be used to generate the receipts that can be downloaded by your users.') ?>
                        </div>
                    </div>
                </div>
                <div class="card mb-3">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Yii::t('app', 'Payment Gateways') ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= $this->render('partials/_payment-gateways'); ?>
                    </div>
                    <div class="card-footer">
                        <div class="text-muted">
                            <?= Yii::t('app', 'This information will be used to accept payments by using these Payment Gateways.') ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>