<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */
namespace app\modules\subscription\services\paypal;

use PayPalHttp\HttpRequest;

/**
 * Class WebhooksVerifySignaturePostRequest
 * @package app\modules\subscription\services\paypal
 */
class WebhooksVerifySignaturePostRequest extends HttpRequest
{
    function __construct($authAlgo, $certUrl, $transmissionId, $transmissionSig, $transmissionTime, $webhookId, $webhookEvent)
    {
        parent::__construct("/v1/notifications/verify-webhook-signature?", "POST");

        $this->headers["Content-Type"] = "application/json";
        $this->body['auth_algo'] = $authAlgo;
        $this->body['cert_url'] = $certUrl;
        $this->body['transmission_id'] = $transmissionId;
        $this->body['transmission_sig'] = $transmissionSig;
        $this->body['transmission_time'] = $transmissionTime;
        $this->body['webhook_id'] = $webhookId;
        $this->body['webhook_event'] = $webhookEvent;
    }
}