<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */
namespace app\modules\subscription\models;

use app\components\behaviors\DateTrait;
use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%subscription_transaction}}".
 *
 * @property int $id
 * @property int|null $subscription_id
 * @property string|null $gateway
 * @property string|null $gateway_id
 * @property string|null $gateway_status
 * @property string|null $gateway_transaction_id
 * @property int|null $gateway_time
 * @property float|null $total
 * @property string|null $currency_code
 * @property string|null $payload
 * @property int $created_by
 * @property int|null $updated_by
 * @property int|null $created_at
 * @property int|null $updated_at
 *
 * @property Subscription $subscription
 * @property SubscriptionBillingInformation $billingInfo
 */
class SubscriptionTransaction extends \yii\db\ActiveRecord
{
    use DateTrait;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%subscription_transaction}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['subscription_id', 'gateway_time', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['total'], 'number'],
            [['payload'], 'string'],
            [['gateway'], 'string', 'max' => 20],
            [['gateway_id', 'gateway_status', 'gateway_transaction_id'], 'string', 'max' => 110],
            [['currency_code'], 'string', 'max' => 32],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'subscription_id' => Yii::t('app', 'Subscription ID'),
            'gateway' => Yii::t('app', 'Gateway'),
            'gateway_id' => Yii::t('app', 'Gateway ID'),
            'gateway_status' => Yii::t('app', 'Gateway Status'),
            'gateway_transaction_id' => Yii::t('app', 'Gateway Transaction ID'),
            'gateway_time' => Yii::t('app', 'Gateway Time'),
            'total' => Yii::t('app', 'Total'),
            'currency_code' => Yii::t('app', 'Currency'),
            'payload' => Yii::t('app', 'Payload'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSubscription()
    {
        return $this->hasOne(Subscription::class,['id'=>'subscription_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getBillingInfo()
    {
        return $this->hasOne(SubscriptionBillingInformation::class,['created_by'=>'created_by']);
    }

    /**
     * Get Formatted Currency Code
     *
     * @return string|null
     */
    public function getFormattedCurrencyCode()
    {
        $currencyCode = null;

        if (!empty($this->currency_code)) {
            $currencyCode = strtoupper($this->currency_code);
        }

        return $currencyCode;
    }

    /**
     * Get Formatted Amount
     *
     * @return string|null
     */
    public function getFormattedAmount()
    {
        $amount = null;

        if (!empty($this->total)) {
            // Amount is in cents
            $amount = $this->total / 100;
            // $amount = number_format($amount, 2);
            $amount = Yii::$app->formatter->asDecimal($amount);
        }

        return $amount;
    }
}
