<?php

use yii\db\Migration;

/**
 * Class m200630_213211_subscription_1_0
 */
class m200630_213211_subscription_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%subscription_product}}', [
            'id' => $this->primaryKey(),

            // Settings
            'name' => $this->string(191)->notNull(),
            'description' => $this->text(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            'details' => $this->text(),

            // Limits
            'recommended' => $this->boolean()->defaultValue(0),
            'form_limit' => $this->integer(),
            'submission_limit' => $this->integer(),
            'file_upload_limit' => $this->boolean()->defaultValue(0),
            'file_storage_limit' => $this->integer(),
            'api_request_limit' => $this->integer(),
            'branding' => $this->boolean()->defaultValue(0),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%subscription_price}}', [
            'id' => $this->primaryKey(),
            'product_id' => $this->integer(11)->notNull(),

            // Integrations
            'paypal_price_id' => $this->string(64),
            'test_paypal_price_id' => $this->string(64),
            'stripe_price_id' => $this->string(64),
            'test_stripe_price_id' => $this->string(64),

            // Settings
            'name' => $this->string(191)->notNull(),
            'description' => $this->text(),
            'image' => $this->text(),
            'status' => $this->boolean()->notNull()->defaultValue(1),
            'amount' => $this->integer(),
            'currency_code' => $this->string(3),
            'model' => $this->string(32),
            'type' => $this->string(32),
            'interval' => $this->string(191)->notNull(),
            'interval_count' => $this->integer(3)->defaultValue(1),
            'trial_period_days' => $this->string(191),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%subscription_product_user_role}}', [
            'product_id' => $this->integer(11)->notNull(),
            'role_id' => $this->string(191)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createIndex("{{%subscription_role_product_id}}", "{{%subscription_product_user_role}}", "product_id");
        $this->createIndex("{{%subscription_role_role_id}}", "{{%subscription_product_user_role}}", "role_id");
        $this->createIndex("{{%subscription_role_product_id_role_id}}", "{{%subscription_product_user_role}}", ["product_id", "role_id"], true);

        $this->createTable('{{%subscription_billing_information}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer(11)->notNull(),

            'first_name' => $this->string(191),
            'last_name' => $this->string(191),
            'email' => $this->string(191),
            'phone' => $this->string(191),
            'organization' => $this->string(191),
            'address' => $this->string(191),
            'address_line_2' => $this->string(191),
            'city' => $this->string(100),
            'state' => $this->string(32),
            'zip' => $this->string(32),
            'country' => $this->string(100),
            'tax_id' => $this->string(64),
            'extra_information' => $this->text(),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%subscription}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer(11)->notNull(),
            'product_id' => $this->integer(11),
            'price_id' => $this->integer(11),

            // Settings
            'name' => $this->string(191),
            'type' => $this->string(32),
            'trial_ends_at' => $this->integer(),
            'ends_at' => $this->integer(),

            // Gateway
            'gateway' => $this->string(20), // 'paypal' or 'stripe'
            'gateway_id' => $this->string(191), // PayPal or Stripe Subscription/Order ID
            'gateway_status' => $this->string(191), // PayPal or Stripe Subscription Status

            // Limits
            'recommended' => $this->boolean()->defaultValue(0),
            'form_limit' => $this->integer(),
            'submission_limit' => $this->integer(),
            'file_upload_limit' => $this->boolean()->defaultValue(0),
            'file_storage_limit' => $this->integer(),
            'api_request_limit' => $this->integer(),
            'branding' => $this->boolean()->defaultValue(0),

            // Others
            'info' => $this->text(),
            'downgraded_at' => $this->integer(),

            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%subscription_transaction}}', [
            'id' => $this->primaryKey(),
            'subscription_id' => $this->integer(),

            'gateway' => $this->string(20), // 'paypal' or 'stripe'
            'gateway_id' => $this->string(110), // PayPal or Stripe Subscription ID
            'gateway_status' => $this->string(110), // PayPal or Stripe Subscription Status
            'gateway_transaction_id' => $this->string(110), // PayPal or Stripe Transaction ID
            'gateway_time' => $this->integer(),
            'total' => $this->decimal(),
            'currency_code' => $this->string(32),
            'payload' => $this->text(),

            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createIndex("{{%subscription_transaction_gateway_id}}", "{{%subscription_transaction}}", "gateway_id");

    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%subscription}}');
        $this->dropTable('{{%subscription_transaction}}');
        $this->dropTable('{{%subscription_billing_information}}');
        $this->dropTable('{{%subscription_price}}');
        $this->dropTable('{{%subscription_product_user_role}}');
        $this->dropTable('{{%subscription_product}}');
    }

}
