<?php

use app\components\widgets\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = Yii::t('app', 'Integration Settings');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Zoho CRM'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $this->title];

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                        <div class="card mb-3">
                            <div class="card-body">
                                <h5>
                                    <?= Yii::t('app', 'Instructions') ?>
                                </h5>
                                <ol>
                                    <li><?= Yii::t('app', 'Go to {google_console}, click <strong>Add Client</strong> and select <strong>Server Web Applications</strong>.', [
                                            'google_console' => Html::a(Yii::t('app', 'Zoho Developer Console'), 'https://api-console.zoho.com/'),
                                        ]) ?></li>
                                    <li><?= Yii::t('app', 'Enter "{client_name}" in <strong>Client Name</strong>, enter {homepage_url} in <strong>Homepage Url</strong> and {redirect_url} in <strong>Authorized Redirect URLs</strong>. Then, click the <strong>Create</strong> button.', [
                                            'client_name' => Html::tag('em', Yii::$app->settings->get('app.name')),
                                            'homepage_url' => Html::tag('em', parse_url(Url::base(true), PHP_URL_HOST)),
                                            'redirect_url' => Html::tag('em', Url::to(['/addons/zoho_crm/admin/authorized'], true)),
                                        ]) ?></li>
                                    <li><?= Yii::t('app', 'Copy the <strong>Client ID</strong> and <strong>Client Secret</strong> from newly created app and save below.') ?></li>
                                </ol>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'Client ID'), 'addon_zoho_crm_clientId', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_zoho_crm_clientId', Yii::$app->settings->get('addon_zoho_crm.clientId'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'Client Secret'), 'addon_zoho_crm.clientSecret', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_zoho_crm_clientSecret', Yii::$app->settings->get('addon_zoho_crm.clientSecret'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group" style="margin-top: 20px">
                                    <?= Html::hiddenInput('action', 'global-settings'); ?>
                                    <?= Html::submitButton(Html::tag('i', '', [
                                            'class' => 'fas fa-check me-2',
                                        ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>