<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use app\modules\addons\modules\zoho_crm\models\ZohoCrm;
use yii\helpers\Html;
use yii\helpers\Json;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\zoho_crm\models\ZohoCrm */
/* @var $itemModel app\modules\addons\modules\zoho_crm\models\ZohoCrmItem */
/* @var $forms array [id => name] of Form models */
/* @var $modules array [id => name] of Zoho CRM */
/* @var $token array Zoho Access Token */

$formFieldUrl = Url::to(['/addons/zoho_crm/admin/fields']);
$modulesUrl = Url::to(['/addons/zoho_crm/admin/modules']);
$moduleFieldUrl = Url::to(['/addons/zoho_crm/admin/module-fields']);

?>

<?php if (empty($token)): ?>

    <?php if ($model->isNewRecord): ?>
        <p><?= Yii::t('app', 'Authenticate your Zoho CRM account to create an integration.') ?></p>
        <p><a href="<?= Url::to('/addons/zoho_crm/admin/authorize') ?>" class="btn btn-primary"><?= Yii::t('app', 'Authenticate') ?></a></p>
    <?php else: ?>
        <p><?= Yii::t('app', 'Authenticate your Zoho CRM account to update your integration.') ?></p>
        <p><a href="<?= Url::to(['/addons/zoho_crm/admin/authorize', 'id' => $model->id]) ?>" class="btn btn-primary"><?= Yii::t('app', 'Authenticate') ?></a></p>
    <?php endif; ?>

<?php else: ?>

    <?php $form = ActiveForm::begin(); ?>

    <div class="row" style="margin-top: 20px;">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'module')->widget(Select2::class, [
                'data' => $modules,
                'options' => [
                    'placeholder' => Yii::t('app', 'Select a module...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ]
            ])->hint(Yii::t(
                'app',
                'Select the module you want to add information to.'
            )); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => EventHelper::supportedFormEvents(),
            ]); ?>
        </div>
        <div class="col-sm-6">
            <?php if ($model->isNewRecord) { $model->status = 1; } ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                'app',
                'Disables the integration at any time.'
            )); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?php if ($model->isNewRecord) { $model->action = ZohoCrm::ACTION_UPSERT; }  ?>
            <?= $form->field($model, 'action')->widget(Select2::class, [
                'data' => ZohoCrm::actionDropdown(),
                'options' => [
                    'placeholder' => Yii::t('app', 'Select an action...'),
                ],
            ]); ?>
        </div>
        <div class="col-sm-6">
            <?php $model->duplicate_check_fields = is_string($model->duplicate_check_fields) ? Json::decode($model->duplicate_check_fields, true) : $model->duplicate_check_fields; ?>
            <?= $form->field($model, 'duplicate_check_fields')->widget(DepDrop::class, [
                'data' => [],
                'options' => [
                    'placeholder' => Yii::t('app', 'Select'),
                    'multiple' => true,
                ],
                'type' => DepDrop::TYPE_SELECT2,
                'select2Options' => [
                    'theme' => Select2::THEME_BOOTSTRAP,
                    'pluginOptions' => [
                        'allowClear' => true
                    ]
                ],
                'pluginOptions' => [
                    'depends' => ['zohocrm-module'],
                    'url' => $moduleFieldUrl,
                ]
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?php $model->trigger = is_string($model->trigger) ? Json::decode($model->trigger, true) : $model->trigger; ?>
            <?= $form->field($model, 'trigger')->widget(Select2::class, [
                'data' => ZohoCrm::triggerDropdown(),
                'options' => [
                    'placeholder' => Yii::t('app', 'Select a trigger...'),
                    'multiple' => true,
                ],
                'pluginOptions' => [
                    'allowClear' => true,
                ],
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

        <fieldset class="item">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, '[0]field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['zohocrm-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $formFieldUrl,
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, '[0]module_field')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['zohocrm-module'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $moduleFieldUrl,
                            'params'=>['zohocrm-form_id'],
                        ]
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-add">
                            <i class="fas fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['zohocrm-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $formFieldUrl,
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= $form->field($itemModel, 'module_field')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['zohocrm-module'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $moduleFieldUrl,
                            'params'=>['zohocrm-form_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <div class="form-group" style="padding-top: 28px;">
                        <button type="button" class="btn btn-icon btn-default btn-remove">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
        </fieldset>

    <?php else: ?>

        <?php foreach($model->items as $i => $item): ?>
            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-'.$i.'-field_id',
                            $item->field_id, ['id'=>'item-'.$i.'-field_id']) ?>
                        <?= $form->field($itemModel, '['.$i.']field_id')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['zohocrm-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'params'=>['item-'.$i.'-field_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= Html::hiddenInput('item-'.$i.'-module_field', $item->module_field, ['id'=>'item-'.$i.'-module_field']) ?>
                        <?= $form->field($itemModel, '['.$i.']module_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['zohocrm-module'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $moduleFieldUrl,
                                'params' => ['item-'.$i.'-module_field', 'zohocrm-form_id']
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>
        <?php endforeach; ?>

        <fieldset id="itemTemplate" class="d-none">
            <div class="row">
                <div class="col-sm-6">
                    <?= Html::hiddenInput('item-field_id', '', ['id'=>'item-field_id']) ?>
                    <?= $form->field($itemModel, 'field_id')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['zohocrm-form_id'],
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $formFieldUrl,
                            'params'=>['item-field_id'],
                            'initialize' => true,
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-5">
                    <?= Html::hiddenInput('item-module_field', '', ['id'=>'item-module_field']) ?>
                    <?= $form->field($itemModel, 'module_field')->widget(DepDrop::class, [
                        'pluginOptions' => [
                            'depends' => ['zohocrm-module'],
                            'initialize' => true,
                            'placeholder' => Yii::t('app', 'Select...'),
                            'url' => $moduleFieldUrl,
                            'params'=>['item-module_field', 'zohocrm-form_id'],
                        ],
                        'pluginEvents' => [
                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                        ],
                    ]) ?>
                </div>
                <div class="col-sm-1">
                    <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                        <i class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
        </fieldset>

    <?php endif; ?>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton(
                ' <i class="fas fa-check me-2"></i> ' .
                Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

<?php endif; ?>

<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

if ($token) {

    $script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#zohocrm-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['zohocrm-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

    $this->registerJs($script, $this::POS_END, 'zohocrm-conditions');

}

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update name attribute
            cloned
                .find('[name="ZohoCrmItem[field_id]"]')
                    .attr('name', 'ZohoCrmItem[' + item + '][field_id]')
                    .attr('id', 'zohocrmitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['zohocrm-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="ZohoCrmItem[module_field]"]')
                    .attr('name', 'ZohoCrmItem[' + item + '][module_field]')
                    .attr('id', 'zohocrmitem-' + item + '-module_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['zohocrm-module'],
                        url: '$modulesUrl'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#zohocrm-form_id').trigger('depdrop.change');
    $('#zohocrm-module').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update name attribute
            cloned
                .find('[name="ZohoCrmItem[field_id]"]')
                    .attr('name', 'ZohoCrmItem[' + item + '][field_id]')
                    .attr('id', 'zohocrmitem-' + item + '-field_id')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['zohocrm-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="ZohoCrmItem[module_field]"]')
                    .attr('name', 'ZohoCrmItem[' + item + '][module_field]')
                    .attr('id', 'zohocrmitem-' + item + '-module_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['zohocrm-module'],
                        url: '{$modulesUrl}'
                    })
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>
