<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\zoho_crm\models;

use Yii;

/**
 * This is the model class for table "{{%addon_zoho_crm_item}}".
 *
 * @property int $id
 * @property int|null $zoho_crm_id
 * @property int|null $form_id
 * @property string|null $field_id
 * @property string|null $module_field
 */
class ZohoCrmItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_zoho_crm_item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['zoho_crm_id', 'form_id'], 'integer'],
            [['field_id', 'module_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'zoho_crm_id' => Yii::t('app', 'Zoho CRM ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'field_id' => Yii::t('app', 'Form Field'),
            'module_field' => Yii::t('app', 'Module Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getZohoCrm()
    {
        return $this->hasOne(ZohoCrm::class, ['id' => 'zoho_crm_id']);
    }
}