<?php

use yii\db\Migration;

/**
 * Class m210825_001502_zoho_crm_1_0
 */
class m210825_001502_zoho_crm_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_zoho_crm}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),

            'name' => $this->text()->notNull(),
            'event' => $this->integer()->notNull()->defaultValue(1),
            'conditions' => $this->text(),

            'oauth' => $this->text(),
            'accounts_url' => $this->text(),
            'module' => $this->text(),
            'trigger' => $this->text(),
            'approved' => $this->integer()->defaultValue(1),
            'action' => $this->integer()->defaultValue(1), // 1. Create, 2. Update or 3. Upsert
            'duplicate_check_fields' => $this->text(),

            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_zoho_crm_item}}', [
            'id' => $this->primaryKey(),
            'zoho_crm_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(), // Form Field ID
            'module_field' => $this->text(), // Module Field ID
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_zoho_crm_item}}');
        $this->dropTable('{{%addon_zoho_crm}}');
    }
}
