<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\zapier\models;

use Yii;

/**
 * This is the model class for table "{{%addon_zapier_item}}".
 *
 * @property integer $id
 * @property integer $zapier_id
 * @property integer $form_id
 * @property string $field_id
 * @property string $field_name
 */
class ZapierItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_zapier_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['zapier_id', 'form_id'], 'integer'],
            [['field_id', 'field_name'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'zapier_id' => Yii::t('app', 'Zapier ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'field_id' => Yii::t('app', 'Field (Value)'),
            'field_name' => Yii::t('app', 'Name (Key)'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getZapier()
    {
        return $this->hasOne(Zapier::class,['zapier_id'=>'id']);
    }
}
