<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

/**
 * Class m210608_141211_zapier_1_0
 */
class m210608_141211_zapier_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_zapier}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'name' => $this->text()->notNull(),
            'event' => $this->integer()->notNull()->defaultValue(1),
            'conditions' => $this->text(),
            'url' => $this->text()->notNull(),
            'method' => $this->text(),
            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_zapier_item}}', [
            'id' => $this->primaryKey(),
            'zapier_id' => $this->integer(11),
            'form_id' => $this->integer(11),
            'field_id' => $this->text(),
            'field_name' => $this->text(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_zapier}}');
        $this->dropTable('{{%addon_zapier_item}}');
    }
}
