<?php

use kartik\form\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\Html;

$this->title = Yii::t('app', 'Global Settings');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Twilio SMS'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $this->title];

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'Account SID'), 'addon_twilio_accountSID', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_twilio_accountSID', Yii::$app->settings->get('addon_twilio.accountSID'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                    <p class="form-text">
                                        <?= Yii::t('app', 'Every message matters.') ?>
                                        <?= Html::a(Yii::t('app', 'Get your Twilio API keys'), 'https://www.twilio.com/') ?>.
                                    </p>
                                </div>
                            </div>
                            <div class='col-sm-6'>
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'Auth Token'), 'addon_twilio_authToken', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_twilio_authToken', Yii::$app->settings->get('addon_twilio.authToken'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class='col-sm-6'>
                                <div class="form-group">
                                    <?= Html::label(Yii::t('app', 'From'), 'addon_twilio_from', ['class' => 'form-label']) ?>
                                    <?= Html::input('text', 'addon_twilio_from', Yii::$app->settings->get('addon_twilio.from'), [
                                        'class' => 'form-control',
                                    ]) ?>
                                    <p class="form-text">
                                        <?= Yii::t('app', 'An alphanumeric string giving your sender address. Eg. +15712224361') ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <?= Html::hiddenInput('action', 'global-settings'); ?>
                                    <?= Html::submitButton(Html::tag('i', '', [
                                            'class' => 'fas fa-check me-2',
                                        ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
                                </div>
                            </div>
                        </div>
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>