<?php

use yii\helpers\Html;

/* @var $price app\modules\subscription\models\SubscriptionPrice */
/* @var $subscription app\modules\subscription\models\Subscription */
/* @var $now int 1 or 0 */
/* @var $stripeInvoice Stripe\Invoice|null */

?>
<h4><?= Yii::t('app', 'Are you sure you want to change your subscription plan?') ?></h4>
<p><?= Yii::t('app', 'Before proceeding, please note that:') ?></p>
<ul>
    <li><?= Yii::t('app', 'The change will be made effective immediately.') ?></li>
    <li><?= Yii::t('app', 'Apply charges immediately, including a prorated charge based on the price difference of the updated subscription.') ?></li>
    <?php if ($stripeInvoice->total > 0): ?>
    <li><?= Yii::t('app', 'Prorated charge') ?>: <strong><?= strtoupper($stripeInvoice->currency) ?> <?= $stripeInvoice->total/100 ?></strong></li>
    <?php else: ?>
        <li><?= Yii::t('app', 'Prorated charge') ?>: <strong><?= strtoupper($stripeInvoice->currency) ?> 0.00</strong></li>
    <?php endif; ?>
</ul>

<div>
    <p><?= Html::a(Yii::t('app', 'Change Now'),
            ['/subscription/user/change-stripe-plan'], [
                'class' => 'btn btn-danger',
                'data-method' => 'POST',
                'data-confirm' => Yii::t('app', 'Are you sure you want to change your subscription right now?'),
                'data-params' => [
                    'id' => $subscription->id,
                    'price_id' => $price->id,
                ],
            ]) ?></p>
</div>