<?php

use app\helpers\Html;
use app\modules\subscription\bundles\PricingTableBundle;

/* @var $products app\modules\subscription\models\SubscriptionProduct[] */
/* @var $switcher boolean */
/* @var $intervals array */

$this->title = Yii::t('app', 'Plan Checkout');

PricingTableBundle::register($this);

?>
<div class="cd-pricing-container cd-has-margins">
    <?php if ($switcher): ?>
    <div class="cd-pricing-switcher">
        <p class="fieldset">
            <?php $i = 1; foreach ($intervals as $interval => $name): ?>
                <input type="radio" name="duration" value="<?= $interval ?>" id="<?= $interval ?>" <?= $i === 1 ? 'checked' : '' ?>>
                <label for="<?= $interval ?>"><?= $name ?></label>
            <?php $i++; endforeach; ?>
            <span class="cd-switch"></span>
        </p>
    </div> <!-- .cd-pricing-switcher -->
    <?php endif; ?>

    <ul class="cd-pricing-list cd-bounce-invert">
        <?php $p = 1; foreach ($products as $product): ?>
            <li class="<?= $p === 2 ? 'cd-popular' : '' ?>">
                <ul class="cd-pricing-wrapper">
                    <?php $k = 1; foreach ($product->items as $subscriptionPrice): ?>
                    <li data-type="<?= $subscriptionPrice->interval ?>" class="<?= $k === 1 ? 'is-visible' : 'is-hidden' ?>">
                        <header class="cd-pricing-header">
                            <h2><?= $product->name ?></h2>

                            <div class="cd-price">
                                <span class="cd-currency"><?= $subscriptionPrice->getCurrencySymbol() ?></span>
                                <span class="cd-value"><?= $subscriptionPrice->price ?></span>
                                <span class="cd-duration"><?= $subscriptionPrice->intervalAbbr ?></span>
                            </div>
                        </header> <!-- .cd-pricing-header -->

                        <div class="cd-pricing-body">
                            <ul class="cd-pricing-features">
                                <?php $details = explode("\n", str_replace("\r", "", $product->details)); ?>
                                <?php foreach ($details as $detail): ?>
                                    <li><?= $detail ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div> <!-- .cd-pricing-body -->

                        <footer class="cd-pricing-footer">
                            <?= Html::a(Yii::t('app', 'Select'),
                                ['/subscription/user/confirm', 'id' => $subscriptionPrice->id], [
                                    'class' => 'cd-select',
                                ]) ?>
                        </footer>  <!-- .cd-pricing-footer -->
                    </li>
                    <?php $k++; endforeach; ?>
                </ul> <!-- .cd-pricing-wrapper -->
            </li>
        <?php $p++; endforeach; ?>
    </ul> <!-- .cd-pricing-list -->
</div> <!-- .cd-pricing-container -->
