<?php

use app\helpers\Html;
use app\components\widgets\ActiveForm;

$this->title = Yii::t('app', 'Billing Information');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Subscription'), 'url' => ['/subscription/user/index']];
$this->params['breadcrumbs'][] = $this->title;

/* @var $model \app\modules\subscription\models\SubscriptionBillingInformation */

?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><?= Html::encode($this->title) ?></h3>
    </div>
    <div class="panel-body">
        <?php $form = ActiveForm::begin(
            [
                'id' => 'billing-information',
            ]
        ); ?>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'first_name')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'last_name')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'email')->textInput([
                    'maxlength' => 255,
                    'type' => 'email'
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'phone')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'organization')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'address')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'address_line_2')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'country')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'city')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'zip')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'state')->textInput([
                    'maxlength' => 255,
                ]) ?>
            </div>
        </div>


        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'tax_id')->textInput([
                    'maxlength' => 64,
                ])->hint(Yii::t('app', 'If you have a registered Tax ID, please provide.')) ?>
            </div>
        </div>

        <div class="form-action">
            <?= Html::submitButton(
                '<i class="glyphicon glyphicon-ok" style="margin-right: 3px"></i> ' .
                Yii::t('app', 'Save'), ['class' => 'btn btn-primary']
            ) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>