<?php

use app\modules\subscription\models\SubscriptionPrice;
use app\modules\subscription\models\SubscriptionProduct;
use yii\helpers\Url;

/* @var $intervals array */
/** @var $monthlyAndYearlyPrices SubscriptionPrice[] */

$this->title = Yii::$app->settings->get('app.name');

?>
<!-- Main content -->
<section class="py-7 bg-dark">
    <div class="container">
        <div class="row row-grid align-items-center">
            <div class="col-12 col-md-5 col-lg-6 order-md-2 mb-5 text-center">
                <figure class="w-100">
                    <img alt="Image placeholder" src="<?= Url::to('@web/modules/subscription/assets/img/svg/illustrations/illustration-3.svg') ?>" class="img-fluid mw-md-120">
                </figure>
            </div>
            <div class="col-12 col-md-7 col-lg-6 order-md-1 pr-md-5">
                <h1 class="display-4 text-center text-md-start text-white mb-3 me-0 me-xl-5">
                    <strong>
                        <?= Yii::t('app', 'Easy-to-use {startTag}online form builder{endTag} for every need.', [
                            'startTag' => '<span class="text-primary">',
                            'endTag' => '</span>',
                        ]) ?>
                    </strong>
                </h1>
                <!-- Text -->
                <h2 class="text-center text-md-start text-white opacity-75 me-0 me-xl-5">
                    <?= Yii::t('app', 'Create online forms and publish them. Get an email for each response. Collect valuable data.') ?>
                </h2>
                <!-- Buttons -->
                <div class="text-center text-md-start mt-5">
                    <a href="#overview" class="btn btn-lg btn-primary">
                        <?= Yii::t('app', 'Get started') ?>
                        <i class="fas fa-chevron-right ms-3"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="py-7" id="overview">
    <div class="container">
        <div class="row mb-5 justify-content-center text-center">
            <div class="col-lg-6">
                <span class="badge bg-lime text-lime-fg fs-3 p-2 fs-4">
                    <?= Yii::t('app', 'Get started') ?>
                </span>
                <h1 class="my-4">
                    <?= Yii::t('app', 'Build powerful online forms') ?>
                </h1>
                <div class="mt-2">
                    <p class="lead fs-2 text-muted">
                        <?= Yii::t('app', 'Build powerful online forms and customize them to your heart\'s delight. Our form builder gives you a intuitive interface, easy customization, templates and reporting. Check out some of our most popular features.') ?>
                    </p>
                </div>
            </div>
        </div>
        <!-- Card -->
        <div class="row mt-5">
            <div class="col-md-4 mb-4">
                <div class="card">
                    <div class="card-body text-center pb-5">
                        <div class="pt-4 pb-5">
                            <img src="<?= Url::to('@web/modules/subscription/assets/img/svg/illustrations/illustration-6.svg') ?>" class="img-fluid img-center" style="height: 150px;" alt="Illustration" />
                        </div>
                        <h2 class="mb-3"><?= Yii::t('app', 'Easy-to-use form builder') ?></h2>
                        <p class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Create the forms you need to collect data, files and payments — without write a single line of code.') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card">
                    <div class="card-body text-center pb-5">
                        <div class="pt-4 pb-5">
                            <img src="<?= Url::to('@web/modules/subscription/assets/img/svg/illustrations/illustration-16.svg') ?>" class="img-fluid img-center" style="height: 150px;" alt="Illustration" />
                        </div>
                        <h2 class="mb-3"><?= Yii::t('app', 'Accept online payments') ?></h2>
                        <p class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Process online payments through one of our payment partners, like PayPal, Stripe and Adyen.') ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="card">
                    <div class="card-body text-center pb-5">
                        <div class="pt-4 pb-5">
                            <img src="<?= Url::to('@web/modules/subscription/assets/img/svg/illustrations/illustration-7.svg') ?>" class="img-fluid img-center" style="height: 150px;" alt="Illustration" />
                        </div>
                        <h2 class="mb-3"><?= Yii::t('app', 'Unique form experiences') ?></h2>
                        <p class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Design beautiful forms that match the look and feel of your brand or website, with or without CSS.') ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="hr-text hr-text-left"></div>
<section class="py-7">
    <div class="container">
        <div class="pb-7">
            <div class="row row-grid justify-content-between align-items-center">
                <div class="col-lg-5 order-lg-2 text-center text-md-start">
                    <h2 class="mb-3">
                        <?= Yii::t('app', 'Configure workflows to save time') ?>
                    </h2>
                    <p class="text-muted fs-3">
                        <?= Yii::t('app', 'With dozens of integrations and countless ways to configure workflows, you can spend less time on tedious tasks and focus on more important things.') ?>
                    </p>
                    <ul class="list-unstyled mb-0 ps-3 pb-3">
                        <li class="py-2">
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="icon icon-shape bg-primary text-white icon-sm rounded-circle me-3">
                                        <i class="fas fa-puzzle-piece"></i>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Integrations') ?></span>
                                </div>
                            </div>
                        </li>
                        <li class="py-2">
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="icon icon-shape bg-primary text-white icon-sm rounded-circle me-3">
                                        <i class="fas fa-tasks"></i>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Workflows') ?></span>
                                </div>
                            </div>
                        </li>
                        <li class="py-2">
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="icon icon-shape bg-primary text-white icon-sm rounded-circle me-3">
                                        <i class="fas fa-code-branch"></i>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Branching & Logic') ?></span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-6 order-lg-1">
                    <div class="card bg-transparent border-0 mb-0 me-lg-5">
                        <div class="card-body p-2">
                            <img alt="Image placeholder" src="<?= Url::to('@web/modules/subscription/assets/img/theme/app/screen-5.png') ?>" class="img-fluid shadow rounded">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div>
            <div class="row row-grid justify-content-between align-items-center">
                <div class="col-lg-5 text-center text-md-start">
                    <h2 class="mb-3">
                        <?= Yii::t('app', 'Analyze data as a PRO') ?>
                    </h2>
                    <p class="text-muted fs-3">
                        <?= Yii::t('app', 'Analyze your data with ease and in whatever way suits you best without effort.') ?>
                    </p>
                    <ul class="list-unstyled mb-0 ms-3 mb-3">
                        <li class="py-2">
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="icon icon-shape bg-primary text-white icon-sm rounded-circle me-3">
                                        <i class="fas fa-database"></i>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Submission Management') ?></span>
                                </div>
                            </div>
                        </li>
                        <li class="py-2">
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="icon icon-shape bg-primary text-white icon-sm rounded-circle me-3">
                                        <i class="fas fa-chart-pie"></i>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Custom Reports') ?></span>
                                </div>
                            </div>
                        </li>
                        <li class="py-2">
                            <div class="d-flex align-items-center">
                                <div>
                                    <div class="icon icon-shape bg-primary text-white icon-sm rounded-circle me-3">
                                        <i class="fas fa-download"></i>
                                    </div>
                                </div>
                                <div>
                                    <span class="text-muted fs-3 mb-0"><?= Yii::t('app', 'Data Export') ?></span>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-6">
                    <div class="card bg-transparent border-0 mb-0 ml-lg-5">
                        <div class="card-body p-2">
                            <img alt="Image placeholder" src="<?= Url::to('@web/modules/subscription/assets/img/theme/app/screen-3.png') ?>" class="img-fluid shadow rounded">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="hr-text hr-text-left"></div>
<section class="py-7">
    <!-- Container -->
    <div class="container position-relative zindex-100">
        <div class="col">
            <div class="row justify-content-center">
                <div class="col-md-10 text-center">
                    <h1 class="">
                        <?= Yii::t('app', 'Ready to get started?') ?>
                    </h1>
                    <p class="text-muted fs-2 mt-3">
                        <?= Yii::t('app', 'Start a free trial to see how {appName} can help you simplify your day and achieve efficiency in the workplace.', [
                            'appName' => Yii::$app->settings->get('app.name')
                        ]) ?>
                    </p>
                    <!-- Play button -->
                    <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                        <a href="<?= Url::to(['/user/registration/register']) ?>" class="btn btn-lg btn-primary mt-4">
                            <?= Yii::t('app', 'Try It Free') ?>
                            <i class="fas fa-chevron-right ms-3"></i>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="hr-text hr-text-left"></div>
<section class="py-7">
    <div class="container position-relative zindex-100">
        <div class="row">
            <div class="col-12 col-md-4 mb-4">
                <div class="card">
                    <div class="d-flex p-4">
                        <div>
                            <span class="badge bg-lime text-lime-fg bg-red fs-3 p-2">
                                <?= Yii::t('app', 'Easy') ?>
                            </span>
                        </div>
                        <div class="ps-4">
                            <h5 class="h2">
                                <?= Yii::t('app', 'Forms in minutes') ?>
                            </h5>
                            <p class="fs-3 text-muted mb-0">
                                <?= Yii::t('app', 'No coding knowledge is needed. Just drag and drop.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-4">
                <div class="card">
                    <div class="d-flex p-4">
                        <div>
                            <span class="badge bg-orange text-orange-fg fs-3 p-2">
                                <?= Yii::t('app', 'Smart') ?>
                            </span>
                        </div>
                        <div class="ps-4">
                            <h5 class="h2">
                                <?= Yii::t('app', 'Conditional logic') ?>
                            </h5>
                            <p class="fs-3 text-muted mb-0">
                                <?= Yii::t('app', 'Hide fields, perform math, format text and much more.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-4">
                <div class="card">
                    <div class="d-flex p-4">
                        <div>
                            <span class="badge bg-yellow text-yellow-fg fs-3 p-2"><?= Yii::t('app', 'Social') ?></span>
                        </div>
                        <div class="ps-4">
                            <h5 class="h2">
                                <?= Yii::t('app', 'Publish anywhere') ?>
                            </h5>
                            <p class="fs-3 text-muted mb-0">
                                <?= Yii::t('app', 'Link to your form or Embed it on your site') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12 col-md-4 mb-4">
                <div class="card">
                    <div class="d-flex p-4">
                        <div>
                            <span class="badge bg-green text-green-fg fs-3 p-2">
                                <?= Yii::t('app', 'Safe') ?>
                            </span>
                        </div>
                        <div class="ps-4">
                            <h5 class="h2">
                                <?= Yii::t('app', 'Secure Forms') ?>
                            </h5>
                            <p class="fs-3 text-muted mb-0">
                                <?= Yii::t('app', 'Password protection, authorized urls, invisible honeypot and more.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-4">
                <div class="card">
                    <div class="d-flex p-4">
                        <div>
                            <span class="badge bg-teal text-teal-fg fs-3 p-2"><?= Yii::t('app', 'Leads') ?></span>
                        </div>
                        <div class="ps-4">
                            <h5 class="h2"><?= Yii::t('app', 'Email notifications') ?></h5>
                            <p class="fs-3 text-muted mb-0">
                                <?= Yii::t('app', 'Receives real-time notifications based on form completions.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-4 mb-4">
                <div class="card">
                    <div class="d-flex p-4">
                        <div>
                            <span class="badge bg-cyan text-cyan-fg fs-3 p-2"><?= Yii::t('app', 'Sales') ?></span>
                        </div>
                        <div class="ps-3">
                            <h5 class="h2">
                                <?= Yii::t('app', 'Collect payments') ?>
                            </h5>
                            <p class="fs-3 text-muted mb-0">
                                <?= Yii::t('app', 'Securely and easily sell products and accept donations.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="hr-text hr-text-left"></div>
<section class="py-7">
    <div class="container">
        <div class="row mb-5 justify-content-center text-center">
            <div class="col-lg-6">
                <span class="badge bg-lime text-lime-fg fs-3 p-2 fs-4"><?= Yii::t('app', 'Key features') ?></span>
                <h1 class="my-4"><?= Yii::t('app', 'Basic or advanced, we have all the features you need to quickly create powerful online forms.') ?></h1>
            </div>
        </div>
        <!-- Features -->
        <div class="row mx-lg-n4">
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div class="icon icon-shape rounded-circle bg-red text-white me-4">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', '100% Responsive') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Built to be customized.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div class="icon icon-shape rounded-circle bg-orange text-white me-4">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Drag & Drop Form Builder') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Create custom forms in minutes.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div class="icon icon-shape rounded-circle bg-yellow text-white me-4">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'File Uploads') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Capturing multiple files at once.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div class="icon icon-shape rounded-circle bg-green text-white me-4">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Multi-Page Forms') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Get more responses with long forms.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div class="icon icon-shape rounded-circle bg-teal text-white me-4">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Conditional Logic') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Control what fields your users see.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div class="icon icon-shape rounded-circle bg-cyan text-white me-4">
                                <i class="fas fa-check"></i>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Calculations') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Let your forms do the math for you.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div>
                                <div class="icon icon-shape rounded-circle bg-blue text-white me-4">
                                    <i class="fas fa-check"></i>
                                </div>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Electronic Signatures') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Collect signatures on any device.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div>
                                <div class="icon icon-shape rounded-circle bg-azure text-white me-4">
                                    <i class="fas fa-check"></i>
                                </div>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Style your forms') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'With a plethora of fonts and colors.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-6 pb-3">
                <div class="card shadow-none">
                    <div class="p-3 d-flex">
                        <div>
                            <div>
                                <div class="icon icon-shape rounded-circle bg-indigo text-white me-4">
                                    <i class="fas fa-check"></i>
                                </div>
                            </div>
                        </div>
                        <div>
                            <span class="h2"><?= Yii::t('app', 'Website Embedding') ?></span>
                            <p class="text-muted mb-0">
                                <?= Yii::t('app', 'Embed any form into your website.') ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="hr-text hr-text-left"></div>
<section class="py-7" id="pricing">
    <div class="container text-center">
        <div class="row justify-content-center mb-6">
            <div class="col-lg-8">
                <!-- Title -->
                <h1>
                    <?= Yii::t('app', 'Complete features at your hand') ?>
                </h1>
                <!-- Text -->
                <div class="mt-2">
                    <p class="lead fs-2 text-muted">
                        <?= Yii::t('app', 'Thousands of people around the world have already made Verso Forms the main tool for building forms.') ?>
                    </p>
                </div>
            </div>
        </div>
        <!-- Pricing Switcher -->
        <div class="row justify-content-center m-5">
            <div class="col">
                <div class="pricing-switcher">
                    <div class="fieldset">
                        <input type="radio" name="duration" value="month" id="month" checked>
                        <label for="month"><?= Yii::t('app', 'Monthly') ?></label>
                        <input type="radio" name="duration" value="year" id="year">
                        <label for="year"><?= Yii::t('app', 'Yearly') ?></label>
                        <span class="switch"></span>
                    </div>
                </div>
            </div>
        </div>
        <!-- Pricing -->
        <div class="row justify-content-center">
        <?php foreach ($monthlyAndYearlyPrices as $price): ?>
            <?php if ($price->product->status === SubscriptionProduct::ON): ?>
                <?php $recommended = $price->product->recommended === SubscriptionProduct::ON; ?>
                <div class="col-12 col-lg-4 mb-4 <?= $price->interval ?>">
                    <div class="card card-md">
                        <?php if ($recommended): ?>
                        <div class="ribbon ribbon-top ribbon-bookmark bg-primary">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-filled" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z"></path></svg>
                        </div>
                        <?php endif; ?>
                        <div class="card-body text-center">
                            <div class="text-uppercase text-muted font-weight-medium"><?= $price->product->name ?></div>
                            <div class="display-5 fw-bold mt-3">
                                <?= $price->getCurrencySymbol() ?><span class="price font-weight-bolder"><?= $price->getFormattedAmount() ?></span>
                            </div>
                            <div class="delimiter-bottom"></div>
                            <ul class="list-unstyled lh-lg">
                                <?php $details = explode("\n", str_replace("\r", "", $price->product->details)); ?>
                                <?php foreach ($details as $detail): ?>
                                    <li><?= $detail ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                <div class="text-center mt-4">
                                    <a href="<?= Url::to(['/user/registration/register', 'p' => $price->id]) ?>" class="btn w-100 <?php if ($recommended): ?> btn-primary<?php endif; ?>"><?= Yii::t('app', 'Choose plan') ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; ?>
        </div>
        <div class="mt-5 text-center" id="contact-us">
            <p class="mb-2">
                <?= Yii::t('app', 'All plans contains free support. Need more?') ?>
            </p>
            <a href="#" class="text-primary text-underline--dashed">
                <?= Yii::t('app', 'Contact us') ?>
                <i class="fas fa-arrow-right ms-2"></i>
            </a>
        </div>
    </div>
</section>
<footer class="position-relative" id="footer-main">
    <div class="footer pt-lg-7 footer-dark bg-dark">
        <!-- Footer -->
        <div class="container pt-4">
            <div class="row">
                <div class="col-12 col-lg-4">
                    <!-- Brand -->
                    <?= $this->render('@app/themes/next/views/partials/_brand') ?>
                    <!-- Mission -->
                    <p class="my-4 fs-3 text-white">
                        <?= Yii::t('app', 'A complete and customizable solution for building professional online forms.') ?>
                    </p>
                    <!-- Social -->
                    <ul class="nav mb-4">
                        <li class="nav-item">
                            <a class="nav-link ps-0" href="#" target="_blank">
                                <i class="fab fa-dribbble"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-github"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-instagram"></i>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#" target="_blank">
                                <i class="fab fa-facebook"></i>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2 offset-lg-2">
                    <h3 class="text-white mb-3">
                        <?= Yii::t('app', 'Account') ?>
                    </h3>
                    <ul class="list-unstyled">
                        <?php if (Yii::$app->user->isGuest): ?>
                            <?php if (Yii::$app->settings->get('app.anyoneCanRegister')): ?>
                                <li>
                                    <a href="<?= Url::to(['/user/registration/register']) ?>">
                                        <?= Yii::t('app', 'Sign Up') ?>
                                    </a>
                                </li>
                            <?php endif ?>
                            <li>
                                <a href="<?= Url::to(['/user/security/login']) ?>">
                                    <?= Yii::t('app', 'Login') ?>
                                </a>
                            </li>
                        <?php else: ?>
                        <li>
                            <a href="<?= Url::to(['/dashboard']) ?>">
                                <?= Yii::t('app', 'Dashboard') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/user/settings/profile']) ?>">
                                <?= Yii::t('app', 'Profile') ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= Url::to(['/subscription/user/index']) ?>">
                                <?= Yii::t('app', 'Billing') ?>
                            </a>
                        </li>
                        <?php endif; ?>

                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="text-white mb-3"><?= Yii::t('app', 'About') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="#overview"><?= Yii::t('app', 'Overview') ?></a></li>
                        <li><a href="#pricing"><?= Yii::t('app', 'Pricing') ?></a></li>
                        <li><a href="#contact-us"><?= Yii::t('app', 'Contact') ?></a></li>
                    </ul>
                </div>
                <div class="col-4 col-lg-2">
                    <h3 class="text-white mb-3"><?= Yii::t('app', 'Company') ?></h3>
                    <ul class="list-unstyled">
                        <li><a href="#"><?= Yii::t('app', 'Community') ?></a></li>
                        <li><a href="#"><?= Yii::t('app', 'Help center') ?></a></li>
                        <li><a href="#"><?= Yii::t('app', 'Support') ?></a></li>
                    </ul>
                </div>
            </div>
            <hr class="divider divider-fade divider-dark my-4">
            <div class="row align-items-center justify-content-md-between pb-4">
                <div class="col-md-6">
                    <div class="copyright text-sm font-weight-bold">
                        &copy; <?= date('Y') ?> <?= Yii::$app->settings->get("app.name") ?>. <?= Yii::t('app', 'All rights reserved.') ?>
                    </div>
                </div>
                <div class="col-md-6">
                    <ul class="nav justify-content-center justify-content-md-end mt-3 mt-md-0">
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <?= Yii::t('app', 'Terms') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <?= Yii::t('app', 'Privacy') ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#">
                                <?= Yii::t('app', 'Cookies') ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php

$styles = <<<CSS

/* Preloader */
@keyframes hidePreloader {
    0% {
        width: 100%;
        height: 100%;
    }

    100% {
        width: 0;
        height: 0;
    }
}

body>div.preloader {
    position: fixed;
    background: #313941;
    width: 100%;
    height: 100%;
    z-index: 1071;
    opacity: 0;
    transition: opacity .5s ease;
    overflow: hidden;
    pointer-events: none;
    display: flex;
    align-items: center;
    justify-content: center;
}

body:not(.loaded)>div.preloader {
    opacity: 1;
}

body:not(.loaded) {
    overflow: hidden;
}

body.loaded>div.preloader {
    animation: hidePreloader .5s linear .5s forwards;
}

/* Pricing switcher */

.pricing-switcher {
    text-align: center;
}
.pricing-switcher .fieldset {
    display: inline-block;
    position: relative;
    padding: 2px;
    border-radius: 50em;
    border: 1px solid #92a1ad;
}
.pricing-switcher input[type="radio"] {
    position: absolute;
    opacity: 0;
}
.pricing-switcher label {
    position: relative;
    z-index: 1;
    display: inline-block;
    float: left;
    width: 90px;
    height: 36px;
    line-height: 36px;
    cursor: pointer;
    margin: 0;
    color: rgba(var(--tblr-muted-rgb),var(--tblr-text-opacity));
}
.pricing-switcher .switch {
    /* floating background */
    position: absolute;
    top: 2px;
    left: 2px;
    height: 36px;
    width: 90px;
    background-color: var(--tblr-primary);
    border-radius: 50em;
    -webkit-transition: -webkit-transform 0.5s;
    -moz-transition: -moz-transform 0.5s;
    transition: transform 0.5s;
}
.pricing-switcher input[type="radio"]:checked + label + .switch,
.pricing-switcher input[type="radio"]:checked + label:nth-of-type(n) + .switch {
    /* use label:nth-of-type(n) to fix a bug on safari with multiple adjacent-sibling selectors*/
    -webkit-transform: translateX(90px);
    -moz-transform: translateX(90px);
    -ms-transform: translateX(90px);
    -o-transform: translateX(90px);
    transform: translateX(90px);
}
.pricing-switcher input[type="radio"]:checked+label{
    color: #FFFFFF;
}
.no-js .pricing-switcher {
    display: none;
}


CSS;

$this->registerCss($styles);

$script = <<<JS

window.addEventListener("load", function() {
    setTimeout(function() {
        document.querySelector('body').classList.add('loaded');
    }, 300);
});

$(document).ready(function(){

    // Handlers
    var togglePlans = function () {
        if ($("#month").is(":checked") === true) {
            $(".year").hide();
            $(".month").fadeIn(600);
        } else {
            $(".month").hide();
            $(".year").fadeIn(600);
        }
    };

    $('input[name="duration"]').click(function(){
        togglePlans()
    });

    togglePlans();

});

JS;

$this->registerJs($script, $this::POS_END);

?>