<?php

use app\modules\subscription\models\Subscription;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use yii\helpers\Html;

?>
<?php $form = ActiveForm::begin(['options' => ['enctype' => 'multipart/form-data']]); ?>
    <div class="row">
        <div class="col-xs-12">
            <legend class="text-primary">PayPal</legend>
        </div>
    </div>
    <div class='row'>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Live Client ID'), 'subscription_paypalLiveClientID', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_paypalLiveClientID', Yii::$app->settings->get('subscription.paypalLiveClientID'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Live Client Secret'), 'subscription_paypalLiveClientSecret', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_paypalLiveClientSecret', Yii::$app->settings->get('subscription.paypalLiveClientSecret'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Sandbox Client ID'), 'subscription_paypalSandboxClientID', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_paypalSandboxClientID', Yii::$app->settings->get('subscription.paypalSandboxClientID'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Sandbox Client Secret'), 'subscription_paypalSandboxClientSecret', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_paypalSandboxClientSecret', Yii::$app->settings->get('subscription.paypalSandboxClientSecret'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xs-12">
            <legend class="text-primary">Stripe</legend>
        </div>
    </div>
    <div class='row'>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Live Publishable Key'), 'subscription_stripeLivePublishableKey', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_stripeLivePublishableKey', Yii::$app->settings->get('subscription.stripeLivePublishableKey'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Live Secret Key'), 'subscription_stripeLiveSecretKey', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_stripeLiveSecretKey', Yii::$app->settings->get('subscription.stripeLiveSecretKey'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Sandbox Publishable Key'), 'subscription_stripeSandboxPublishableKey', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_stripeSandboxPublishableKey', Yii::$app->settings->get('subscription.stripeSandboxPublishableKey'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
        <div class='col-sm-3'>
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Sandbox Secret Key'), 'subscription_stripeSandboxSecretKey', ['class' => 'control-label']) ?>
                <?= Html::input('text', 'subscription_stripeSandboxSecretKey', Yii::$app->settings->get('subscription.stripeSandboxSecretKey'), [
                    'class' => 'form-control',
                ]) ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-6">
            <div class="form-group">
                <?= Html::label(Yii::t('app', 'Integration Type'), 'subscription_stripeIntegration', ['class' => 'control-label']) ?>
                <?= Select2::widget([
                    'name' => 'subscription_stripeIntegration',
                    'data' => [
                        Subscription::STRIPE_CHECKOUT => Yii::t('app', 'Stripe Checkout (Recommended)'),
                        Subscription::STRIPE_ELEMENTS => Yii::t('app', 'Stripe Elements'),
                    ],
                    'value' => Yii::$app->settings->get('subscription.stripeIntegration'),
                ]); ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="form-group" style="margin-top: 20px">
                <?= Html::hiddenInput('action', 'payment-gateways'); ?>
                <?= Html::submitButton(Html::tag('i', '', [
                        'class' => 'glyphicon glyphicon-ok',
                        'style' => 'margin-right: 2px;',
                    ]) . ' ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>
<?php ActiveForm::end(); ?>