<?php

use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\modules\subscription\models\SubscriptionProduct */
/* @var $itemModel app\modules\subscription\models\SubscriptionPrice */
/* @var $roles array [name => description] of user roles */
/* @var $subscriptionProductRoles array [name => description] of user roles related to subscription product model */

$this->title = Yii::t('app', 'Create Subscription Product');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Subscription Products'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body theme-create">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= $this->render('_form', [
                            'model' => $model,
                            'itemModel' => $itemModel,
                            'roles' => $roles,
                            'subscriptionProductRoles' => $subscriptionProductRoles,
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>