<?php

use app\components\widgets\ActiveForm;
use app\helpers\ArrayHelper;
use app\helpers\CurrencyHelper;
use app\modules\subscription\models\SubscriptionPrice;
use yii\helpers\Html;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $model app\modules\subscription\models\SubscriptionProduct */
/* @var $itemModel app\modules\subscription\models\SubscriptionPrice */
/* @var $roles array [name => description] of user roles */
/* @var $subscriptionProductRoles array [name => description] of user roles related to subscription product model */
/* @var $form yii\widgets\ActiveForm */

// Currencies
$currencies = CurrencyHelper::currencies();
$currencies = ArrayHelper::map($currencies, 'alphabeticCode', 'currency');

?>

<div class="subscription-product-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-12">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <?= $form->field($model, 'description')->textarea(['rows' => 3]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <?= $form->field($model, 'details')->textarea(['rows' => 3]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-6">
            <?php $model->roles = $subscriptionProductRoles; // initial value ?>
            <?= $form->field($model, 'roles')
                ->widget(Select2::class, [
                    'data' => $roles,
                    'options' => ['placeholder' => 'Select roles...'],
                    'pluginOptions' => [
                        'allowClear' => true,
                        'multiple' => true,
                    ],
                ])
                ->label(Yii::t('app', 'Roles'))
                ->hint(Yii::t('app', 'Will be assigned to the user who purchases the subscription product.')) ?>
        </div>
        <div class="col-3">
            <?php if ($model->isNewRecord) { $model->status = 1;} ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                'app',
                'Disables this product at any time.'
            )) ?>
        </div>
        <div class="col-3">
            <?= $form->field($model, 'recommended')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <legend class="text-primary"><?= Yii::t('app', 'Limits') ?></legend>
        </div>
    </div>

    <div class="row">
        <div class="col-6">
            <?= $form->field($model, 'form_limit')->textInput([
                'type' => 'number',
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-6">
            <?= $form->field($model, 'submission_limit')->textInput([
                'type' => 'number',
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <legend class="text-primary"><?= Yii::t('app', 'Pricing Plans') ?></legend>
        </div>
    </div>

    <?php if ($model->isNewRecord || count($model->items) === 0): ?>

    <fieldset class="item">
        <div class="hr-text hr-text-left">
            <?= Yii::t('app', 'Plan') ?>
        </div>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($itemModel, '[0]name')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-5">
                <?= $form->field($itemModel, '[0]description')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-1">
                <div class="form-group" style="padding-top: 28px;">
                    <button type="button" class="btn btn-icon btn-default btn-add">
                        <i class="fas fa-plus"></i>
                    </button>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($itemModel, '[0]paypal_price_id')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($itemModel, '[0]test_paypal_price_id')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($itemModel, '[0]stripe_price_id')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-2">
                <?= $form->field($itemModel, '[0]test_stripe_price_id')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-4">
                <?= $form->field($itemModel, '[0]amount')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-sm-4">
                <?= $form->field($itemModel, '[0]currency_code')->dropDownList($currencies) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($itemModel, '[0]type')->dropDownList(
                        SubscriptionPrice::availableTypes()) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-2">
                <?= $form->field($itemModel, '[0]interval_count')->textInput([
                    'maxlength' => true,
                    'type' => 'number',
                ]) ?>
            </div>
            <div class="col-2">
                <?= $form->field($itemModel, '[0]interval')->dropDownList(
                    SubscriptionPrice::availableIntervals()) ?>
            </div>
            <div class="col-4">
                <?= $form->field($itemModel, '[0]trial_period_days')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
            <div class="col-3">
                <?= $form->field($itemModel, '[0]image')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>
    </fieldset>

    <?php else: ?>

    <?php foreach($model->items as $i => $item): ?>

            <fieldset class="item">
                <div class="hr-text hr-text-left">
                    <?= Yii::t('app', 'Plan') ?>
                </div>
                <?= $form->field($item, '['.$i.']id', [
                    'template' => '{input}',
                    'options' => ['tag' => false],
                ])->hiddenInput()->label(false); ?>
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($item, '['.$i.']name')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($item, '['.$i.']description')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($item, '['.$i.']paypal_price_id')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($item, '['.$i.']test_paypal_price_id')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($item, '['.$i.']stripe_price_id')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($item, '['.$i.']test_stripe_price_id')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-4">
                        <?= $form->field($item, '['.$i.']amount')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-4">
                        <?= $form->field($item, '['.$i.']currency_code')->dropDownList($currencies) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($item, '['.$i.']type')->dropDownList(
                            SubscriptionPrice::availableTypes()) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-2">
                        <?= $form->field($item, '['.$i.']interval_count')->textInput([
                            'maxlength' => true,
                            'type' => 'number',
                        ]) ?>
                    </div>
                    <div class="col-2">
                        <?= $form->field($item, '['.$i.']interval')->dropDownList(
                            SubscriptionPrice::availableIntervals()) ?>
                    </div>
                    <div class="col-4">
                        <?= $form->field($item, '['.$i.']trial_period_days')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-3">
                        <?= $form->field($item, '['.$i.']image')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                </div>
            </fieldset>
    <?php endforeach; ?>

    <?php endif; ?>

    <style>
        div.hr-number {
            counter-reset: item;
            list-style-type: none;
            padding: 0;
            margin: 0;
        }
        div.hr-number::before {
            content: counter(item) " ";
            counter-increment: item;
        }
    </style>
    <fieldset id="itemTemplate" class="d-none">
        <div class="hr-text hr-text-left">
            <?= Yii::t('app', 'Plan') ?>
        </div>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($itemModel, 'name')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-5">
                <?= $form->field($itemModel, 'description')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-1">
                <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                    <i class="fas fa-minus"></i>
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-3">
                <?= $form->field($itemModel, 'paypal_price_id')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($itemModel, 'test_paypal_price_id')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($itemModel, 'stripe_price_id')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-2">
                <?= $form->field($itemModel, 'test_stripe_price_id')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-4">
                <?= $form->field($itemModel, 'amount')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-sm-4">
                <?= $form->field($itemModel, 'currency_code')->dropDownList($currencies, ['disabled' => true]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($itemModel, 'type')
                    ->dropDownList(SubscriptionPrice::availableTypes(), ['disabled' => true]) ?>
            </div>
        </div>
        <div class="row">
            <div class="col-2">
                <?= $form->field($itemModel, 'interval_count')->textInput([
                    'maxlength' => true,
                    'type' => 'number',
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-2">
                <?= $form->field($itemModel, 'interval')->dropDownList(
                    SubscriptionPrice::availableIntervals(), ['disabled' => true]) ?>
            </div>
            <div class="col-4">
                <?= $form->field($itemModel, 'trial_period_days')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
            <div class="col-3">
                <?= $form->field($itemModel, 'image')->textInput([
                    'maxlength' => true,
                    'disabled' => true,
                ]) ?>
            </div>
        </div>
    </fieldset>


    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton(' <i class="fas fa-check me-2"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

if ($model->isNewRecord || count($model->items) === 0) {

$script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            cloned
                .find('[name="SubscriptionPrice[name]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][name]')
                    .attr('id', 'subscriptionprice-' + item + '-name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[description]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][description]')
                    .attr('id', 'subscriptionprice-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[paypal_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][paypal_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-paypal_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[test_paypal_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][test_paypal_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-test_paypal_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[stripe_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][stripe_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-stripe_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[test_stripe_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][test_stripe_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-test_stripe_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[amount]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][amount]')
                    .attr('id', 'subscriptionprice-' + item + '-amount')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[currency_code]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][currency_code]')
                    .attr('id', 'subscriptionprice-' + item + '-currency_code')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[type]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][type]')
                    .attr('id', 'subscriptionprice-' + item + '-type')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[interval_count]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][interval_count]')
                    .attr('id', 'subscriptionprice-' + item + '-interval_count')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[interval]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][interval]')
                    .attr('id', 'subscriptionprice-' + item + '-interval')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[trial_period_days]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][trial_period_days]')
                    .attr('id', 'subscriptionprice-' + item + '-trial_period_days')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[image]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][image]')
                    .attr('id', 'subscriptionprice-' + item + '-image')
                    .removeAttr('disabled')
                    .end()
                
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            cloned
                .find('[name="SubscriptionPrice[name]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][name]')
                    .attr('id', 'subscriptionprice-' + item + '-name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[description]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][description]')
                    .attr('id', 'subscriptionprice-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[paypal_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][paypal_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-paypal_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[test_paypal_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][test_paypal_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-test_paypal_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[stripe_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][stripe_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-stripe_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[test_stripe_price_id]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][test_stripe_price_id]')
                    .attr('id', 'subscriptionprice-' + item + '-test_stripe_price_id')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[amount]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][amount]')
                    .attr('id', 'subscriptionprice-' + item + '-amount')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[currency_code]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][currency_code]')
                    .attr('id', 'subscriptionprice-' + item + '-currency_code')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[type]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][type]')
                    .attr('id', 'subscriptionprice-' + item + '-type')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[interval_count]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][interval_count]')
                    .attr('id', 'subscriptionprice-' + item + '-interval_count')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[interval]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][interval]')
                    .attr('id', 'subscriptionprice-' + item + '-interval')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[trial_period_days]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][trial_period_days]')
                    .attr('id', 'subscriptionprice-' + item + '-trial_period_days')
                    .removeAttr('disabled')
                    .end()
                .find('[name="SubscriptionPrice[image]"]')
                    .attr('name', 'SubscriptionPrice[' + item + '][image]')
                    .attr('id', 'subscriptionprice-' + item + '-image')
                    .removeAttr('disabled')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);
