<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */
namespace app\modules\subscription\services\paypal;

use PayPalHttp\HttpRequest;

/**
 * Class SubscriptionTransactionsGetRequest
 * @package app\modules\subscription\services\paypal
 */
class SubscriptionTransactionsGetRequest extends HttpRequest
{
    function __construct($subscriptionId, $startTime, $endTime)
    {
        parent::__construct("/v1/billing/subscriptions/{subscription_id}/transactions?start_time={start_time}&end_time={end_time}", "GET");

        $this->path = str_replace("{subscription_id}", urlencode($subscriptionId), $this->path);
        $this->path = str_replace("{start_time}", $startTime, $this->path);
        $this->path = str_replace("{end_time}", $endTime, $this->path);
        $this->headers["Content-Type"] = "application/json";
    }
}