<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */
namespace app\modules\subscription\helpers;

use app\helpers\ArrayHelper;
use Yii;

/**
 * Class Config
 * @package app\modules\subscription\helpers
 */
class Config
{

    /**
     * Get module parameter
     *
     * @param $key
     * @param null $default
     * @return mixed|null
     * @throws \Exception
     */
    public static function get($key, $default = null) {

        $module = Yii::$app->getModule('subscription');

        if (!isset($module->params) || !is_array($module->params) || empty($module->params)) {
            return null;
        }

        return ArrayHelper::getValue($module->params, $key, $default);
    }

}