<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */
namespace app\modules\subscription\controllers;

use app\modules\subscription\helpers\Config;
use app\modules\subscription\models\SubscriptionPrice;
use yii\web\Controller;
use yii\helpers\Url;
use yii\web\Response;

class PublicController extends Controller
{
    public function actionIndex()
    {
        $this->layout = 'landing';

        $intervals = Config::get('pricing.intervals');
        $intervalKeys = array_keys($intervals);
        $monthlyAndYearlyPrices = SubscriptionPrice::find()
            ->where(['type' => SubscriptionPrice::TYPE_RECURRING])
            ->andWhere(['in', 'interval', $intervalKeys])
            ->with('product')
            ->all();

        return $this->render('index', [
            'intervals' => $intervals,
            'monthlyAndYearlyPrices' => $monthlyAndYearlyPrices,
        ]);
    }
}