<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use app\modules\addons\modules\stripe\helpers\Client;
use app\modules\addons\modules\stripe\models\Stripe;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;


?>

    <div class="stripe-promo-form">

        <div class="col-12">
            <h3>Promo Code</h3>
        </div>

        <div class="col-sm-12">
<!--            <label class="form-label">Promo Code</label>-->
            <?= Html::textInput('promo_code', null, ['class' => 'form-control']) ?>
        </div>

        <div id="resultText" class="form-group col-sm-12" style="margin-top:20px;"></div>

        <div class="form-group" style="margin-top: 20px">
            <?= Html::button('Add Discount',['id' => 'addDiscountBtn', 'class' => 'btn btn-primary']) ?>
        </div>


        <script type="text/javascript">
            function numberWithCommas(x) {
                return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
            }

            $(function () {
                $('#addDiscountBtn').on('click', function () {
                    $.ajax({
                        url: '<?= Url::to(['/addons/stripe/check/discount']) ?>',
                        data: {
                            id: '<?= $id ?>',
                            promoCode: $("input[name=promo_code]").val()
                        },
                        success:function(response){
                            var json = JSON.parse(response);
                            var element = $('#checkoutTable_' + json[0].code, window.parent.document);

                            if (json[0].active && element.length == 0) {

                                $('#resultText').append(
                                    '<input name="promo_codes[]" type="hidden" value="' + json[0].id + '" />' +
                                    'Applied Discount: ' + json[0].coupon.name + '<br />');
                                if (json[0].coupon.amount_off != null) {
                                    $('#checkoutTable_line_items', window.parent.document).append(
                                        '<div id="checkoutTable_' + json[0].code + '" style="width:100%;display:flex;">' +
                                        '<div style="display:inline-block;">' + json[0].coupon.name + '</div><div id="checkoutTable_' + json[0].code + '_amount" style="width:100px;text-align:right;display:inline-block;flex-grow:1;">-$' + json[0].coupon.amount_off / 100.0 + '</div><div style="width:60px;text-align:right;display:inline-block">' + (json[0].coupon.duration == 'forever' ? '/month' : 'x1') + '</div>' +
                                        '</div>');
                                }
                                else if (json[0].coupon.percent_off != null) {
                                    $('#checkoutTable_line_items', window.parent.document).append(
                                        '<div id="checkoutTable_' + json[0].code + '" style="width:100%;display:flex;">' +
                                        '<div style="display:inline-block;">' + json[0].coupon.name + '</div><div id="checkoutTable_' + json[0].code + '_amount" style="width:100px;text-align:right;display:inline-block;flex-grow:1;">-' + json[0].coupon.percent_off + '%</div><div style="width:60px;text-align:right;display:inline-block">' + (json[0].coupon.duration == 'forever' ? '/month' : 'x1') + '</div>' +
                                        '</div>');
                                }
                            }

                            // Recalculate total

                            var total = 0;

                            $('#checkoutTable_line_items > div:visible', window.parent.document).each(function(index, element) {
                                //alert(element);
                                //console.log(element.id);
                                $(this).find("div[id$='_amount']").each(function(index2, amountDiv) {
                                    console.log(amountDiv.innerHTML);
                                    var amount = amountDiv.innerHTML;
                                    amount = amount.replace("$","");
                                    if (amount.startsWith("-")) {
                                        if (amount.endsWith("%"))
                                            total = total - (total * parseInt(amount.replace("-", "").replace("%", "")) / 100);
                                        else
                                            total = total - parseInt(amount.replace("-", ""));
                                    }
                                    else
                                        total = total + parseInt(amount);
                                });
                            });
                            total = (total < 0 ? 0 : total);

                            $('#checkoutTable_total', window.parent.document).html('$' + numberWithCommas(total));

                            // $.each( $radios, function( key, radio ) {
                            //     console.log(radio.value);
                            //     if (radio.checked) {
                            //         $('#checkoutTable_' + radio.id).show();
                            //         total += parseInt($('#checkoutTable_' + radio.id + '_amount').text().replace("$", ""));
                            //     }
                            //     else {
                            //         $('#checkoutTable_' + radio.id).hide();
                            //     }
                            //     // $radios[key].hide();
                            //     $('#checkoutTable_total').html('$' + numberWithCommas(total));
                            // });
                        }
                    });
                });
            });
        </script>
    </div>

