<?php

use app\helpers\ArrayHelper;
use app\modules\addons\modules\stripe\models\Stripe;
use Money\Formatter\IntlMoneyFormatter;
use Money\Money;
use yii\helpers\Url;
use kartik\depdrop\DepDrop;
use yii\web\View;
use Money\Converter;
use Money\Currency;
use Money\Currencies\ISOCurrencies;
use Money\Exchange\FixedExchange;
use Money\Exchange\SwapExchange;
use Swap\Builder;


/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\stripe\models\Stripe */

//Yii::$app->getSession()->setFlash(
//    'danger',
//    Yii::t('app', "Test email was not sent.")
//);

$this->registerCssFile('@web/themes/next/assets/css/checkout.min.css');
$this->registerJsFile('https://code.jquery.com/ui/1.14.0/jquery-ui.js');
$this->registerJsFile('@web/static_files/js/buttonstrip.min.js');
$this->registerJsFile('https://unpkg.com/js-big-decimal@1.3.1/dist/web/js-big-decimal.min.js');
$this->registerJs('
    function submitWithoutPayment() {
        $("input[name=payment_type]").val("later");
        console.log("submitting without payment");
        formEl.submit();
        
    }
    
    function showPaymentWarningModal() {
        $("#paymentWarningModal").modal("show");
    }

    // display correct checkout   
    function updateCheckout() {
        // check which payment option was selected and which payment method was selected
        var paymentOption = $("#payment-options").find(".Tab--selected").find(".TabLabel").html();
        var paymentMethod = $("#payment-methods").find(".Tab--selected").find(".TabLabel").html();
        
        $("#full-ach").removeClass("showSection");
        $("#full-card").removeClass("showSection");
        $("#subscribe-ach").removeClass("showSection");
        $("#subscribe-card").removeClass("showSection");
        
        if (paymentOption == "Pay Now" && paymentMethod == "ACH Transfer") {
            $("#full-ach").addClass("showSection");
        }
        else if (paymentOption == "Pay Now" && paymentMethod == "Card") {
            $("#full-card").addClass("showSection");
        }
        else if (paymentOption == "Pay in Installments" && paymentMethod == "ACH Transfer") {
            $("#subscribe-ach").addClass("showSection");
        }
        else if (paymentOption == "Pay in Installments" && paymentMethod == "Card") {
            $("#subscribe-card").addClass("showSection");
        }
        else if (paymentOption == "Pay Deposit Only" && paymentMethod == "ACH Transfer") {
            $("#full-ach").addClass("showSection");
        }
        else if (paymentOption == "Pay Deposit Only" && paymentMethod == "Card") {
            $("#full-card").addClass("showSection");
        }
        
        var previousSubtotal = Number($("#checkout_subtotal").html().replace(/[^0-9.-]+/g,""));
        updateCheckoutNumbers(previousSubtotal);
    }
    
    function updatePaymentOptionButton(updatedPaymentOption) {
        if (updatedPaymentOption == "full") {
            $("#payment-options").find("#pay-now").addClass("Tab--selected");
            $("#payment-options").find("#pay-plan").removeClass("Tab--selected");
            $("#payment-options").find("#pay-deposit").removeClass("Tab--selected");
            $("#payment-options").find("#pay-now").find("svg").addClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-plan").find("svg").removeClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-deposit").find("svg").removeClass("p-TabIcon--selected");
        }
        else if (updatedPaymentOption == "plan") {
            $("#payment-options").find("#pay-plan").addClass("Tab--selected");
            $("#payment-options").find("#pay-now").removeClass("Tab--selected");
            $("#payment-options").find("#pay-deposit").removeClass("Tab--selected");
            $("#payment-options").find("#pay-plan").find("svg").addClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-now").find("svg").removeClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-deposit").find("svg").removeClass("p-TabIcon--selected");
        }
        else if (updatedPaymentOption == "deposit") {
            $("#payment-options").find("#pay-plan").removeClass("Tab--selected");
            $("#payment-options").find("#pay-now").removeClass("Tab--selected");
            $("#payment-options").find("#pay-deposit").addClass("Tab--selected");
            $("#payment-options").find("#pay-plan").find("svg").removeClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-now").find("svg").removeClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-deposit").find("svg").addClass("p-TabIcon--selected");
        }
        
        updateCheckout();
    }
    
    function updatePaymentMethodButton(updatedPaymentMethod) {
        if (updatedPaymentMethod == "ach") {
            $("#payment-methods").find("#ach").addClass("Tab--selected");
            $("#payment-methods").find("#card").removeClass("Tab--selected");
            $("#payment-methods").find("#ach").find("svg").addClass("p-TabIcon--selected");
            $("#payment-methods").find("#card").find("svg").removeClass("p-TabIcon--selected");
        }
        else if (updatedPaymentMethod == "card") {
            $("#payment-methods").find("#card").addClass("Tab--selected");
            $("#payment-methods").find("#ach").removeClass("Tab--selected");
            $("#payment-methods").find("#card").find("svg").addClass("p-TabIcon--selected");
            $("#payment-methods").find("#ach").find("svg").removeClass("p-TabIcon--selected");
        }
        
        updateCheckout();
    }
    
    function handleError() {
        $(\'#submitPaymentButton\').buttonLoader(\'stop\');
    }
    
    function handleSuccess() {
        console.log(\'success\');
        
        var hiddenInput = document.createElement(\'input\');
        hiddenInput.setAttribute(\'type\', \'hidden\');
        hiddenInput.setAttribute(\'name\', \'paymentIntentStatus\');
        hiddenInput.setAttribute(\'value\', \'success\');
        formEl.find(\'[name="paymentIntentStatus"]\').remove();
        formEl.append(hiddenInput);
    }
    
    function handleProcessing() {
        console.log(\'processing\');
        
        var hiddenInput = document.createElement(\'input\');
        hiddenInput.setAttribute(\'type\', \'hidden\');
        hiddenInput.setAttribute(\'name\', \'paymentIntentStatus\');
        hiddenInput.setAttribute(\'value\', \'processing\');
        formEl.find(\'[name="paymentIntentStatus"]\').remove();
        formEl.append(hiddenInput);
    }
    
    function handleRequiresAction() {
        console.log(\'requires action\');
        
        var hiddenInput = document.createElement(\'input\');
        hiddenInput.setAttribute(\'type\', \'hidden\');
        hiddenInput.setAttribute(\'name\', \'paymentIntentStatus\');
        hiddenInput.setAttribute(\'value\', \'requires_action\');
        formEl.find(\'[name="paymentIntentStatus"]\').remove();
        formEl.append(hiddenInput);
    }
', View::POS_HEAD);

//$publishableKey = $model->environment === Stripe::LIVE ? $model->publishable_key : $model->test_publishable_key;
$publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);


$paymentFrequency = $model->installment_interval;
$date = strtotime('now');
$paymentDates = [];

for ($paymentNumber = 1; $paymentNumber <= 5; $paymentNumber++) {
    if ($paymentFrequency == 'day') {
        $paymentDates[] = strtotime('+' . (1 * $paymentNumber) . ' day', time());
    } else if ($paymentFrequency == 'week') {
        $paymentDates[] = strtotime('+' . (7 * $paymentNumber) . ' day', time());
    } else if ($paymentFrequency == '2weeks') {
        $paymentDates[] = strtotime('+' . (14 * $paymentNumber) . ' day', time());
    } else if ($paymentFrequency == '3weeks') {
        $paymentDates[] = strtotime('+' . (21 * $paymentNumber) . ' day', time());
    } else if ($paymentFrequency == '4weeks') {
        $paymentDates[] = strtotime('+' . (28 * $paymentNumber) . ' day', time());
    } else if ($paymentFrequency == 'month') {
        $paymentDates[] = strtotime('+' . (30 * $paymentNumber) . ' day', time());

    }
}

$numberInstallments = $model->num_installments ?? 0;
$dt = new DateTime();

if (!empty($model->trip_date)) {
    $tripDt = new DateTime($model->trip_date);

    // Calculate days between now and trip date
    $diffTime = abs($tripDt->getTimestamp() - $dt->getTimestamp());
    $diffDays = ceil($diffTime / (60 * 60 * 24));

    // Calculate max possible installments based on payment frequency
    $maxInstallments = 1; // Start with 1 for initial payment

    if ($paymentFrequency == 'day') {
        $maxInstallments += $diffDays;
    }
    else if ($paymentFrequency == 'week') {
        $maxInstallments += floor($diffDays / 7);
    }
    else if ($paymentFrequency == '2weeks') {
        $maxInstallments += floor($diffDays / 14);
    }
    else if ($paymentFrequency == '3weeks') {
        $maxInstallments += floor($diffDays / 21);
    }
    else if ($paymentFrequency == '4weeks') {
        $maxInstallments += floor($diffDays / 28);
    }
    else if ($paymentFrequency == 'month') {
        $maxInstallments += floor($diffDays / 30);
    }

    // Cap at selected number of installments
    $numberInstallments = min($numberInstallments, $maxInstallments);
}
        
$denominator = ($model->deposit_rule == 'default' ? $numberInstallments : $numberInstallments - 1);

?>
<style>
    .modal-backdrop {
        position: fixed;
        top: 0;
        left: 0;
        width: 100vw;
        height: 100vh;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 1040;
    }

    #paymentWarningModal {
        z-index: 1050;
    }

    .modal-open {
        overflow: hidden;
    }
</style>

<script src="https://js.stripe.com/v3/"></script>
<script>
    function handleError() {
        $('.payment_alert').show();
        $('#submitPaymentButton').buttonLoader('stop');
    }
    function clearError() {
        $('.payment_alert').hide();
    }
    function numberWithCommas(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    function format_number(n) {
        return n.toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, "$1,");
    }

    function formatCurrency(amount, currencyCode) {
        return new Intl.NumberFormat('en-US', {
            style: 'currency',
            currency: (currencyCode == null ? 'usd' : currencyCode)
        }).format(amount);
    }

    function updateCheckoutLineItems(lineItemsHTML) {
        var html = "";
        lineItemsHTML.forEach(function(lineItem) {
            // console.log($(lineItem).html());
            var price = $(lineItem).find(".line-price").html().replace(",","").replace("$","");

            // const formattedAmount = formatCurrency(price, 'EUR'); // "€1,234.56"
            // console.log(formattedAmount);
            if (!price.startsWith("0.00"))
                html += $(lineItem).html();
        });

        $('.checkout-card').html(html);
    }

    function currencyChanged() {
        const subtotal = bigDecimal.divide($('#amountSubTotal').val(),100, 2);
        // const subtotal = Number($("#amountSubTotal").val().replace(/[^0-9.-]+/g,""));
        const endpoint = 'convert';
        const access_key = '27d9cff002b12aef43bb72dc2ae5f365';

        const from = 'USD';
        const to = $('select[name=currencies]').find(":selected").val();

        if (from != to) {
            // get new converted subtotal
            $.get('https://api.currencylayer.com/' + endpoint + '?access_key=' + access_key + '&from=' + from + '&to=' + to + '&amount=' + subtotal, function (data) {
                console.log(data);
                console.log(data.result);
                // $(elem).closest('fieldset').find("#values").html(data);
                // $('#item_values').html(data);
                updateCheckoutNumbers(data.result, true);
            });
        }
        else
            updateCheckoutNumbers(subtotal, true);
    }

    function updateCheckoutNumbers(subtotal, onlyUpdateCheckoutTable = false) {
        const currency = $('select[name=currencies]').find(":selected").val();

        // check which payment option was selected and which payment method was selected
        var paymentOption = $('#payment-options').find('.Tab--selected').find('.TabLabel').html();
        var paymentMethod = $('#payment-methods').find('.Tab--selected').find('.TabLabel').html();


        $('#checkout_subtotal').html(formatCurrency(subtotal, currency));

        const fullname = $('input[name="<?= $model->cardholder_name ?>"]').val();
        const email = $('input[name="<?= $model->receipt_email ?>"]').val();
        $('#customer_name').val(fullname);
        $('#customer_email').val(email);


        if (paymentOption == 'Pay Now') {
            // var fees = new Decimal(Math.round(subtotal * 3) / 100);
            // var discount = new Decimal(Math.round(subtotal * 2) / 100);
            //var fees = Math.round(subtotal * 3) / 100;
            //var discount = Math.round(subtotal * 2) / 100;

            var fees = Math.round(subtotal * <?= $model->fee_percentage ?? 0.0338 ?> * 100) / 100;
            var discount = Math.round(subtotal * <?= $model->discount_percentage ?? 0.0238 ?> * 100) / 100;

            <?= (!$model->surcharge ? 'fees=0;discount=0;' : '') ?>

            var grand_total = bigDecimal.add(subtotal,fees);
            var discount_total = bigDecimal.subtract(bigDecimal.add(subtotal,fees),discount);

            $('#checkout_subtotal_row').show();
            $('#checkout_installments_row').hide();
            $('#checkout_individualpayment_row').hide();
            $('#checkout_fees').html(formatCurrency(fees, currency));
            if (!onlyUpdateCheckoutTable) {
                $('#amountFees').val(bigDecimal.round(bigDecimal.multiply(fees, 100)));
                $('#amountDiscount').val(bigDecimal.round(bigDecimal.multiply(discount, 100)));
            }

            $('.installments-table').removeClass('showSection');
            $('.deposit-table').removeClass('showSection');


            if (paymentMethod == 'ACH Transfer') {
                $('#checkout_discount').html('- ' + formatCurrency(discount, currency));
                $('#checkout_grand_total').html(formatCurrency(discount_total, currency));

                //$('#checkout_discount_row').show();
                $('#checkout_discount_row').addClass('showSection');

                if (!onlyUpdateCheckoutTable) {
                    $('#amountSubTotal').val(bigDecimal.round(bigDecimal.multiply(subtotal, 100)));

                    $('#amountTotal').val(bigDecimal.round(bigDecimal.multiply(discount_total, 100)));

                    $('#packageTotal').val(bigDecimal.round(bigDecimal.multiply(discount_total, 100)));
                }
            }
            else if (paymentMethod == 'Card') {
                $('#checkout_grand_total').html(formatCurrency(grand_total, currency));

                // $('#checkout_discount_row').hide();
                $('#checkout_discount_row').removeClass('showSection');

                if (!onlyUpdateCheckoutTable) {
                    $('#amountDiscount').val(0);
                    $('#amountSubTotal').val(bigDecimal.round(bigDecimal.multiply(subtotal, 100)));
                    $('#amountTotal').val(bigDecimal.round(bigDecimal.multiply(grand_total, 100)));
                    $('#packageTotal').val(bigDecimal.round(bigDecimal.multiply(grand_total, 100)));
                }
            }
        }
        else if (paymentOption == 'Pay Deposit Only') {
            // CALCULATE INSTALLMENTS

            var first_payment = 0;

            if (<?= $model->deposit_rule == 'custom' ? 'true' : 'false' ?>) {
                var custom_deposit_amount = <?= !empty($model->custom_deposit_amount) ? $model->custom_deposit_amount : 0 ?>;


                var custom_deposit_quantity = $("input[type='radio'][name='<?= $model->custom_deposit_quantity ?>']:checked").val();
                console.log(custom_deposit_quantity);


                first_payment = custom_deposit_amount * (custom_deposit_quantity ?? 1);
            }

            var plan_subtotal = first_payment;
            var plan_fees = bigDecimal.round(bigDecimal.multiply(plan_subtotal, 3.38)) / 100;
            var plan_discount = bigDecimal.round(bigDecimal.multiply(plan_subtotal, 2.38)) / 100;

            var package_subtotal = subtotal;
            var package_totalfees = bigDecimal.round(bigDecimal.multiply(package_subtotal, 3.38)) / 100;
            var package_discount = bigDecimal.round(bigDecimal.multiply(package_subtotal, 2.38)) / 100;

            <?= (!$model->surcharge ? 'plan_fees=0;plan_discount=0;package_totalfees=0;package_discount=0;' : '') ?>

            var plan_grand_total = bigDecimal.add(plan_subtotal,plan_fees);
            var plan_discount_total = bigDecimal.subtract(bigDecimal.add(plan_subtotal,plan_fees), plan_discount);


            $('#checkout_subtotal_row').hide();
            $('#checkout_individualpayment_row').show();
            $('#checkout_individualpayment').html(formatCurrency(plan_subtotal, currency));
            $('#checkout_fees').html(formatCurrency(plan_fees, currency));
            $('.deposit-table').addClass('showSection');

            if (!onlyUpdateCheckoutTable) {
                $('#amountFees').val(bigDecimal.multiply(plan_fees, 100));
                $('#amountDiscount').val(bigDecimal.multiply(plan_discount, 100));

                $('#initial_deposit').html(formatCurrency(first_payment, 'usd'));

                console.log($('input[name="installment[0]price"]'));

                $('input[name="installment[0][price]"]').val(bigDecimal.round(first_payment,2));

                $('input[name="installment[0][amountSubTotal]"]').val(bigDecimal.round(first_payment * 100));

                $('input[name="installment[0][amountTotal]"]').val(bigDecimal.round(bigDecimal.multiply(first_payment, (paymentMethod == 'ACH Transfer' ? 101.5 : 103.5))));

                $('input[name="installment[0][amountFees]"]').val(bigDecimal.round(bigDecimal.multiply(first_payment, 3.5)));

                $('input[name="installment[0][amountDiscount]"]').val((paymentMethod == 'ACH Transfer' ? bigDecimal.round(bigDecimal.multiply(first_payment, 2)) : 0));

                $('input[name="installment[0][date]"]').val('<?= strtotime('now') ?>');
            }



            if (paymentMethod == 'ACH Transfer') {
                $('#checkout_discount').html('- ' + formatCurrency(plan_discount, currency));
                $('#checkout_grand_total').html(formatCurrency(plan_discount_total, currency));

                $('#checkout_discount_row').addClass('showSection');

                if (!onlyUpdateCheckoutTable) {
                    $('#amountSubTotal').val(bigDecimal.round(bigDecimal.multiply(plan_subtotal, 100)));
                    $('#amountTotal').val(bigDecimal.round(bigDecimal.multiply(plan_discount_total, 100)));

                    $('#packageTotal').val(bigDecimal.round(bigDecimal.multiply(bigDecimal.subtract(bigDecimal.add(package_subtotal, package_totalfees), package_discount), 100)));
                }
            }
            else if (paymentMethod == 'Card') {
                $('#checkout_grand_total').html(formatCurrency(plan_grand_total, currency));

                $('#checkout_discount_row').removeClass('showSection');

                if (!onlyUpdateCheckoutTable) {
                    $('#amountDiscount').val(0);
                    $('#amountSubTotal').val(bigDecimal.round(bigDecimal.multiply(plan_subtotal, 100)));
                    $('#amountTotal').val(bigDecimal.round(bigDecimal.multiply(plan_grand_total, 100)));

                    $('#packageTotal').val(bigDecimal.round(bigDecimal.multiply(bigDecimal.add(package_subtotal, package_totalfees), 100)));
                }
            }
        }
        else if (paymentOption == 'Pay in Installments') {
            // CALCULATE INSTALLMENTS

            var first_payment = 0;
            var second_payment = 0;
            var third_payment = 0;
            var fourth_payment = 0;
            var fifth_payment = 0;
            var remainder = 0;

            //var denominator = <?= $numberInstallments ?>; // <?= ($model->deposit_rule == 'default' ? $numberInstallments : $numberInstallments - 1) ?>;
            var denominator = <?= $denominator ?>;

            if (<?= $model->deposit_rule == 'custom' ? 'true' : 'false' ?>) {
                var custom_deposit_amount = <?= !empty($model->custom_deposit_amount) ? $model->custom_deposit_amount : 0 ?>;


                var custom_deposit_quantity = $("input[type='radio'][name='<?= $model->custom_deposit_quantity ?>']:checked").val();
                console.log(custom_deposit_quantity);


                first_payment = custom_deposit_amount * (custom_deposit_quantity ?? 1);
            }
            else {
                first_payment = subtotal / denominator;
            }



            //denominator--;
            remainder = subtotal - first_payment;

            if (denominator <= 0)
            {
                second_payment = 0;
                third_payment = 0;
                fourth_payment = 0;
                fifth_payment = 0;
            }
            else {
                second_payment = remainder / denominator;
                third_payment = remainder / denominator;
                fourth_payment = remainder / denominator;
                fifth_payment = remainder / denominator;
            }

            var plan_subtotal = first_payment;
            var plan_fees = bigDecimal.round(bigDecimal.multiply(plan_subtotal, 3.5)) / 100;
            var plan_discount = bigDecimal.round(bigDecimal.multiply(plan_subtotal, 2)) / 100;

            var recurring_subtotal = second_payment;
            var recurring_fees = bigDecimal.round(bigDecimal.multiply(recurring_subtotal, 3.5)) / 100;
            var recurring_discount = bigDecimal.round(bigDecimal.multiply(recurring_subtotal, 2)) / 100;

            var package_subtotal = subtotal;
            var package_totalfees = bigDecimal.round(bigDecimal.multiply(package_subtotal, 3.5)) / 100;
            var package_discount = bigDecimal.round(bigDecimal.multiply(package_subtotal, 2)) / 100;

            <?= (!$model->surcharge ? 'plan_fees=0;plan_discount=0;recurring_fees=0;recurring_discount=0;package_totalfees=0;package_discount=0;' : '') ?>

            var plan_grand_total = bigDecimal.add(plan_subtotal,plan_fees);
            var plan_discount_total = bigDecimal.subtract(bigDecimal.add(plan_subtotal,plan_fees), plan_discount);

            var recurring_grand_total = bigDecimal.add(recurring_subtotal, recurring_fees);
            var recurring_discount_total = bigDecimal.subtract(bigDecimal.add(recurring_subtotal, recurring_fees), recurring_discount);

            $('#checkout_subtotal_row').hide();
            $('#checkout_individualpayment_row').show();
            $('#checkout_individualpayment').html(formatCurrency(plan_subtotal, currency));
            $('#checkout_fees').html(formatCurrency(plan_fees, currency));
            $('.installments-table').addClass('showSection');

            if (!onlyUpdateCheckoutTable) {
                $('#amountFees').val(bigDecimal.multiply(plan_fees, 100));
                $('#amountDiscount').val(bigDecimal.multiply(plan_discount, 100));

                $('#first_payment').html(formatCurrency(first_payment, 'usd'));
                $('#second_payment').html(formatCurrency(second_payment, 'usd'));
                $('#third_payment').html(formatCurrency(third_payment, 'usd'));
                $('#fourth_payment').html(formatCurrency(fourth_payment, 'usd'));
                $('#fifth_payment').html(formatCurrency(fifth_payment, 'usd'));


                $('#second_payment_date').html('<?= date("M j, Y", $paymentDates[0]) ?>');
                $('#third_payment_date').html('<?= date("M j, Y", $paymentDates[1]) ?>');
                $('#fourth_payment_date').html('<?= date("M j, Y", $paymentDates[2]) ?>');
                $('#fifth_payment_date').html('<?= date("M j, Y", $paymentDates[3]) ?>');

                console.log($('input[name="installment[0]price"]'));

                $('input[name="installment[0][price]"]').val(bigDecimal.round(first_payment,2));
                $('input[name="installment[1][price]"]').val(bigDecimal.round(second_payment,2));
                $('input[name="installment[2][price]"]').val(bigDecimal.round(third_payment,2));
                $('input[name="installment[3][price]"]').val(bigDecimal.round(fourth_payment,2));
                $('input[name="installment[4][price]"]').val(bigDecimal.round(fifth_payment,2));

                $('input[name="installment[0][amountSubTotal]"]').val(bigDecimal.round(first_payment * 100));
                $('input[name="installment[1][amountSubTotal]"]').val(bigDecimal.round(second_payment * 100));
                $('input[name="installment[2][amountSubTotal]"]').val(bigDecimal.round(third_payment * 100));
                $('input[name="installment[3][amountSubTotal]"]').val(bigDecimal.round(fourth_payment * 100));
                $('input[name="installment[4][amountSubTotal]"]').val(bigDecimal.round(fifth_payment * 100));

                $('input[name="installment[0][amountTotal]"]').val(bigDecimal.round(bigDecimal.multiply(first_payment, (paymentMethod == 'ACH Transfer' ? 101.5 : 103.5))));
                $('input[name="installment[1][amountTotal]"]').val(bigDecimal.round(bigDecimal.multiply(second_payment, (paymentMethod == 'ACH Transfer' ? 101.5 : 103.5))));
                $('input[name="installment[2][amountTotal]"]').val(bigDecimal.round(bigDecimal.multiply(third_payment, (paymentMethod == 'ACH Transfer' ? 101.5 : 103.5))));
                $('input[name="installment[3][amountTotal]"]').val(bigDecimal.round(bigDecimal.multiply(fourth_payment, (paymentMethod == 'ACH Transfer' ? 101.5 : 103.5))));
                $('input[name="installment[4][amountTotal]"]').val(bigDecimal.round(bigDecimal.multiply(fifth_payment, (paymentMethod == 'ACH Transfer' ? 101.5 : 103.5))));

                $('input[name="installment[0][amountFees]"]').val(bigDecimal.round(bigDecimal.multiply(first_payment, 3.5)));
                $('input[name="installment[1][amountFees]"]').val(bigDecimal.round(bigDecimal.multiply(second_payment, 3.5)));
                $('input[name="installment[2][amountFees]"]').val(bigDecimal.round(bigDecimal.multiply(third_payment, 3.5)));
                $('input[name="installment[3][amountFees]"]').val(bigDecimal.round(bigDecimal.multiply(fourth_payment, 3.5)));
                $('input[name="installment[4][amountFees]"]').val(bigDecimal.round(bigDecimal.multiply(fifth_payment, 3.5)));

                $('input[name="installment[0][amountDiscount]"]').val((paymentMethod == 'ACH Transfer' ? bigDecimal.round(bigDecimal.multiply(first_payment, 2)) : 0));
                $('input[name="installment[1][amountDiscount]"]').val((paymentMethod == 'ACH Transfer' ? bigDecimal.round(bigDecimal.multiply(second_payment, 2)) : 0));
                $('input[name="installment[2][amountDiscount]"]').val((paymentMethod == 'ACH Transfer' ? bigDecimal.round(bigDecimal.multiply(third_payment, 2)) : 0));
                $('input[name="installment[3][amountDiscount]"]').val((paymentMethod == 'ACH Transfer' ? bigDecimal.round(bigDecimal.multiply(fourth_payment, 2)) : 0));
                $('input[name="installment[4][amountDiscount]"]').val((paymentMethod == 'ACH Transfer' ? bigDecimal.round(bigDecimal.multiply(fifth_payment, 2)) : 0));

                $('input[name="installment[0][date]"]').val('<?= strtotime('now') ?>');
                $('input[name="installment[1][date]"]').val('<?= $paymentDates[0] ?>');
                $('input[name="installment[2][date]"]').val('<?= $paymentDates[1] ?>');
                $('input[name="installment[3][date]"]').val('<?= $paymentDates[2] ?>');
                $('input[name="installment[4][date]"]').val('<?= $paymentDates[3] ?>');
            }



            if (paymentMethod == 'ACH Transfer') {
                $('#checkout_discount').html('- ' + formatCurrency(plan_discount, currency));
                $('#checkout_grand_total').html(formatCurrency(plan_discount_total, currency));

                $('#checkout_discount_row').addClass('showSection');

                if (!onlyUpdateCheckoutTable) {

                    $('#amountSubTotal').val(bigDecimal.round(bigDecimal.multiply(plan_subtotal, 100)));
                    $('#amountTotal').val(bigDecimal.round(bigDecimal.multiply(plan_discount_total, 100)));
                    $('#recurringSubTotal').val(bigDecimal.round(bigDecimal.multiply(recurring_subtotal, 100)));
                    $('#recurringTotal').val(bigDecimal.round(bigDecimal.multiply(recurring_discount_total, 100)));

                    $('#packageTotal').val(bigDecimal.round(bigDecimal.multiply(bigDecimal.subtract(bigDecimal.add(package_subtotal, package_totalfees), package_discount), 100)));
                    // $('#packageTotal').val((package_subtotal + package_totalfees - package_discount) * 100);
                }
            }
            else if (paymentMethod == 'Card') {
                $('#checkout_grand_total').html(formatCurrency(plan_grand_total, currency));

                $('#checkout_discount_row').removeClass('showSection');

                if (!onlyUpdateCheckoutTable) {

                    $('#amountDiscount').val(0);
                    $('#amountSubTotal').val(bigDecimal.round(bigDecimal.multiply(plan_subtotal, 100)));
                    $('#amountTotal').val(bigDecimal.round(bigDecimal.multiply(plan_grand_total, 100)));
                    $('#recurringSubTotal').val(bigDecimal.round(bigDecimal.multiply(recurring_subtotal, 100)));
                    $('#recurringTotal').val(bigDecimal.round(bigDecimal.multiply(recurring_grand_total, 100)));

                    $('#packageTotal').val(bigDecimal.round(bigDecimal.multiply(bigDecimal.add(package_subtotal, package_totalfees), 100)));

                }
            }
        }
    }



    (function($) {
        $.fn.buttonLoader = function(action) {
            var self = $(this);
            //start loading animation
            if (action == 'start') {
                if ($(self).attr("disabled") == "disabled") {
                    e.preventDefault();
                }
                //disable buttons when loading state
                $('.has-spinner').attr("disabled", "disabled");
                $(self).attr('data-btn-text', $(self).text());
                //binding spinner element to button and changing button text
                $(self).html('<span class="spinner"><i class="fa fa-spinner fa-spin"></i></span>Loading');
                $(self).addClass('active');
            }
            //stop loading animation
            if (action == 'stop') {
                $(self).html($(self).attr('data-btn-text'));
                $(self).removeClass('active');
                //enable buttons after finish loading
                $('.has-spinner').removeAttr("disabled");
            }
        }
    })(jQuery);


    $(function () {
        $('#submitPaymentButton').click(function() {
            var btn = $(this);
            $(btn).buttonLoader('start');
        });

        $('#submitLaterButton').click(function() {
            var btn = $(this);
            $(btn).buttonLoader('start');
        });

        $('#addDiscountBtn').on('click', function () {
            var btnText = $('#addDiscountBtn').html();

            if (btnText == 'Remove') {
                $('#checkoutTable_line_items > div:last', window.parent.document).remove();

                window.parent.updateCheckoutSummary(null);

                $("input[name=promotion-code]").val('');
                $('#addDiscountBtn').html('Apply');
            }
            else if (btnText == 'Apply') {
                $.ajax({
                    url: '<?= Url::to(['/addons/stripe/check/discount']) ?>',
                    data: {
                        id: '<?= $model->id ?>',
                        promoCode: $("input[name=promotion-code]").val()
                    },
                    success: function (response) {
                        var json = JSON.parse(response);
                        var element = $('#checkoutTable_' + json[0].code, window.parent.document);

                        if (json[0].active && element.length == 0) {

                            $('#resultText').append(
                                '<input name="promo_codes[]" type="hidden" value="' + json[0].id + '" />' +
                                'Applied Discount: ' + json[0].coupon.name + '<br />');


                            var html = '<div id="checkoutTable_' + json[0].code + '" style="width:100%;display:flex;">';
                            html += '<div style="display:flex;flex-basis:100%">';

                            if (json[0].coupon.amount_off != null) {
                                html +=
                                    '<div class="line-icon"><img src="/static_files/images/money_off.svg" /></div>' +
                                    '<div class="line-item">' + json[0].coupon.name + '</div>' +
                                    '<div class="line-price" id="checkoutTable_' + json[0].code + '_amount">-$' + format_number(json[0].coupon.amount_off / 100.0) + '</div>';
                                console.log(json[0].coupon.amount_off);
                            } else if (json[0].coupon.percent_off != null) {
                                html +=
                                    '<div class="line-icon"></div>' +
                                    '<div class="line-item">' + json[0].coupon.name + '</div>' +
                                    '<div class="line-price" id="checkoutTable_' + json[0].code + '_amount">-' + json[0].coupon.percent_off + '%</div>';
                            }

                            html += '</div></div>';
                            $('#checkoutTable_line_items', window.parent.document).append(html);
                        }

                        // Recalculate total

                        window.parent.updateCheckoutSummary(null);

                        $('#addDiscountBtn').html('Remove');
                    }
                });
            }
        });
    });
</script>

<div class="checkout_container">

    <div class="checkout_table">
        <div>
            <div style="font-size:1.5rem;font-weight:bold;padding-bottom:20px;">
                Checkout Summary
            </div>
            <div class="checkout-card">
<!--                <div style="display:flex;">-->
<!--                    <div class="line-icon">-->
<!--                        <svg fill="#000000" width="32px" height="32px" viewBox="0 -64 640 640" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M624 448H16c-8.84 0-16 7.16-16 16v32c0 8.84 7.16 16 16 16h608c8.84 0 16-7.16 16-16v-32c0-8.84-7.16-16-16-16zM80.55 341.27c6.28 6.84 15.1 10.72 24.33 10.71l130.54-.18a65.62 65.62 0 0 0 29.64-7.12l290.96-147.65c26.74-13.57 50.71-32.94 67.02-58.31 18.31-28.48 20.3-49.09 13.07-63.65-7.21-14.57-24.74-25.27-58.25-27.45-29.85-1.94-59.54 5.92-86.28 19.48l-98.51 49.99-218.7-82.06a17.799 17.799 0 0 0-18-1.11L90.62 67.29c-10.67 5.41-13.25 19.65-5.17 28.53l156.22 98.1-103.21 52.38-72.35-36.47a17.804 17.804 0 0 0-16.07.02L9.91 230.22c-10.44 5.3-13.19 19.12-5.57 28.08l76.21 82.97z"></path></g></svg>-->
<!--                    </div>-->
<!--                    <div class="line-item">Fall Umrah Land Only Package</div>-->
<!--                    <div class="line-price">$1,000</div>-->
<!--                </div>-->
<!--                <div style="display:flex;">-->
<!--                    <div class="line-icon">-->
<!--                        <svg width="32px" height="32px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path fill="none" d="M0 0h24v24H0z"></path> <path d="M22 11v9h-2v-3H4v3H2V4h2v10h8V7h6a4 4 0 0 1 4 4zM8 13a3 3 0 1 1 0-6 3 3 0 0 1 0 6z"></path> </g> </g></svg>-->
<!--                    </div>-->
<!--                    <div class="line-item">Double Occupancy</div>-->
<!--                    <div class="line-price">$1,200</div>-->
<!--                </div>-->
<!--                <div style="display:flex;">-->
<!--                    <div class="line-icon">-->
<!--                        <svg width="32px" height="32px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M5 5C5 4.59334 4.75727 4.24338 4.40879 4.0871C4.55271 3.97374 4.72712 3.89615 4.91959 3.86865L15.7172 2.32614C16.922 2.15402 18 3.08894 18 4.30604V5.12602C17.6804 5.04375 17.3453 5 17 5H5Z" fill="#1C274D"></path> <path d="M9.75 13C9.75 11.7574 10.7574 10.75 12 10.75C13.2426 10.75 14.25 11.7574 14.25 13C14.25 14.2426 13.2426 15.25 12 15.25C10.7574 15.25 9.75 14.2426 9.75 13Z" fill="#1C274D"></path> <path fill-rule="evenodd" clip-rule="evenodd" d="M18 6.17071C19.1652 6.58254 20 7.69378 20 9V19C20 20.6569 18.6569 22 17 22H7C5.34315 22 4 20.6569 4 19V5C4 5.18214 4.0487 5.35291 4.13378 5.5C4.30669 5.7989 4.62986 6 5 6H17C17.3506 6 17.6872 6.06015 18 6.17071ZM12 9.25C9.92893 9.25 8.25 10.9289 8.25 13C8.25 15.0711 9.92893 16.75 12 16.75C14.0711 16.75 15.75 15.0711 15.75 13C15.75 10.9289 14.0711 9.25 12 9.25ZM10 18.25C9.58579 18.25 9.25 18.5858 9.25 19C9.25 19.4142 9.58579 19.75 10 19.75H14C14.4142 19.75 14.75 19.4142 14.75 19C14.75 18.5858 14.4142 18.25 14 18.25H10Z" fill="#1C274D"></path> </g></svg>-->
<!--                    </div>-->
<!--                    <div class="line-item">Travel Visa</div>-->
<!--                    <div class="line-price">$225</div>-->
<!--                </div>-->
            </div>
            <div class="deposit-table" style="padding:0px;font-size:1rem;border-top: 1px solid rgba(4, 32, 69, 0.14);">
                <div id="first_payment_row">
                    <div style="padding-right:25px;">
                        <svg fill="white" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512.00 512.00" enable-background="new 0 0 512 512" xml:space="preserve" stroke="white"><g id="SVGRepo_bgCarrier" stroke-width="0"><rect x="0" y="0" width="512.00" height="512.00" rx="256" fill="#377E22" strokewidth="0"></rect></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier">  <g> <path d="M249.703,201.25H188v-25h19.312c6.859,0,13.422-1.219,19.5-3.594c6.172-2.375,11.438-5.641,15.797-9.797 c4.358-4.203,7.922-9.25,10.547-15.234c2.734-5.906,4.047-12.5,4.047-19.625H284v256h-34.297V201.25z"></path> </g> </g></svg>
                    </div>
                    <div style="flex-grow:1;text-align:left;">
                        <div style="margin-top:18px;">
                            <div style="font-weight:bold;">Initial Deposit</div>
                            <div style="width:125px;justify-content: right;font-size:0.8rem">Today</div>
                        </div>
                    </div>
                    <div id="initial_deposit" style="font-weight:bold;"></div>
                </div>
            </div>
            <div class="installments-table" style="padding:0px;font-size:1rem;border-top: 1px solid rgba(4, 32, 69, 0.14);">
                <?php if($numberInstallments > 0): ?>
                <div id="first_payment_row">
                    <div style="padding-right:25px;">
<!--                        <svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M256,0C114.609,0,0,114.609,0,256c0,141.391,114.609,256,256,256c141.391,0,256-114.609,256-256 C512,114.609,397.391,0,256,0z M256,472c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"></path> <g> <path d="M249.703,201.25H188v-25h19.312c6.859,0,13.422-1.219,19.5-3.594c6.172-2.375,11.438-5.641,15.797-9.797 c4.358-4.203,7.922-9.25,10.547-15.234c2.734-5.906,4.047-12.5,4.047-19.625H284v256h-34.297V201.25z"></path> </g> </g></svg>-->

                        <svg fill="white" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512.00 512.00" enable-background="new 0 0 512 512" xml:space="preserve" stroke="white"><g id="SVGRepo_bgCarrier" stroke-width="0"><rect x="0" y="0" width="512.00" height="512.00" rx="256" fill="#377E22" strokewidth="0"></rect></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier">  <g> <path d="M249.703,201.25H188v-25h19.312c6.859,0,13.422-1.219,19.5-3.594c6.172-2.375,11.438-5.641,15.797-9.797 c4.358-4.203,7.922-9.25,10.547-15.234c2.734-5.906,4.047-12.5,4.047-19.625H284v256h-34.297V201.25z"></path> </g> </g></svg>

<!--                        <svg fill="white" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="-51.2 -51.2 614.40 614.40" enable-background="new 0 0 512 512" xml:space="preserve" stroke="white">-->
<!--                            <g id="SVGRepo_bgCarrier" stroke-width="0" transform="translate(40.96000000000001,40.96000000000001), scale(0.84)">-->
<!--                                <rect x="-51.2" y="-51.2" width="614.40" height="614.40" rx="307.2" fill="#377E22" strokewidth="0"></rect>-->
<!--                            </g>-->
<!--                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>-->
<!--                            <g id="SVGRepo_iconCarrier"> <path d="M256,0C114.609,0,0,114.609,0,256c0,141.391,114.609,256,256,256c141.391,0,256-114.609,256-256 C512,114.609,397.391,0,256,0z M256,472c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"></path>-->
<!--                                <g>-->
<!--                                    <path d="M249.703,201.25H188v-25h19.312c6.859,0,13.422-1.219,19.5-3.594c6.172-2.375,11.438-5.641,15.797-9.797 c4.358-4.203,7.922-9.25,10.547-15.234c2.734-5.906,4.047-12.5,4.047-19.625H284v256h-34.297V201.25z"></path>-->
<!--                                </g>-->
<!--                            </g>-->
<!--                        </svg>-->
                    </div>
                    <div style="flex-grow:1;text-align:left;">
                        <div style="margin-top:18px;">
                            <div style="font-weight:bold;">First Payment</div>
                            <div style="width:125px;justify-content: right;font-size:0.8rem">Today</div>
                        </div>
                    </div>
                    <div id="first_payment" style="font-weight:bold;"></div>
                </div>
                <?php endif ?>
                <?php if($numberInstallments > 1): ?>
                <div id="second_payment_row">
                    <div style="padding-right:25px;">
                        <svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M256,0C114.609,0,0,114.609,0,256s114.609,256,256,256s256-114.609,256-256S397.391,0,256,0z M256,472 c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"></path> <g> <path d="M176,209.75c2.531-24.406,10.969-44.141,25.375-59.219c14.344-15.031,34-22.531,58.859-22.531 c12.234,0,23.172,2.141,32.594,6.484c9.422,4.297,17.375,10.141,23.719,17.484c6.328,7.281,11.219,15.547,14.516,24.797 c3.281,9.266,4.938,18.844,4.938,28.703c0,8.625-0.984,16.391-3.062,23.266c-2.094,6.875-4.953,12.984-8.688,18.297 c-3.75,5.438-8.031,10.375-13.109,15c-4.922,4.688-10.328,9.078-16.188,13.234c-10.844,8.406-22.125,16.453-33.672,24.203 c-11.594,7.75-22.719,16.531-33.375,26.328c-3.875,3.672-7.062,7.438-9.594,11.453c-2.5,4.016-4.594,9.031-6.266,15.016h117.375 V384H178.531v-24.203c0-10.047,3.188-20,9.625-29.578c6.438-9.734,14.438-19.188,24.125-28.219 c9.625-9.031,20.188-17.828,31.781-26.359c11.609-8.516,22.531-16.766,32.891-24.781c7.844-5.984,14.031-12.359,18.672-19.234 c4.516-6.859,6.859-15.625,6.859-26.344c0-15.172-3.812-27.031-11.734-35.531c-7.781-8.484-17.938-12.734-30.516-12.734 c-15.359,0-27.531,4.703-36.453,14.109c-9,9.375-13.438,22.25-13.438,38.625H176z"></path> </g> </g></svg>
                    </div>
                    <div style="flex-grow:1;text-align:left;">
                        <div style="margin-top:18px;">
                            <div style="font-weight:bold;">Second Payment</div>
                            <div id="second_payment_date" style="width:125px;justify-content: right;font-size:0.8rem">---</div>
                        </div>
                    </div>
                    <div id="second_payment" style="font-weight:bold;"></div>

                </div>
                <?php endif ?>
                <?php if($numberInstallments > 2): ?>
                <div id="third_payment_row">
                    <div style="padding-right:25px;">
                        <svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M256,0C114.609,0,0,114.609,0,256s114.609,256,256,256s256-114.609,256-256S397.391,0,256,0z M256,472 c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"></path> <g> <path d="M182.828,204.781c2.688-24.062,9.672-42.922,20.938-56.5C215.031,134.766,232.812,128,257.25,128 c21.156,0,37.938,5.969,50.25,17.875s18.469,27.75,18.469,47.469c0,14.125-2.562,25.375-7.781,33.781 c-5.234,8.375-13.453,14.906-24.781,19.625c5.422,1.75,10.641,4.25,15.688,7.5c5.188,3.25,9.734,7.406,13.672,12.594 c4.062,5.156,7.266,11.234,9.734,18.344c2.344,7.047,3.5,15.359,3.5,25.094c0,12.172-2.078,22.688-6.234,31.75 c-4.281,9.188-9.984,16.906-17.078,22.984c-7.234,6.219-15.641,10.938-25.047,14.188c-9.531,3.234-19.672,4.797-30.391,4.797 c-21.969,0-40.156-6.984-54.5-20.984c-14.344-13.984-23.25-34.547-26.75-62h32.562c3.188,20,8.734,34.047,16.5,42.203 c7.75,8.031,18.531,12.062,32.188,12.062c6.156,0,12.094-1.016,17.703-3.047c5.641-2.016,10.516-5.016,14.812-9.016 c4.312-4,7.734-8.734,10.391-14.281c2.5-5.688,3.703-11.906,3.703-18.656c0-13.516-4.125-25.016-12.5-34.438 c-8.25-9.375-19.641-14.094-34.109-14.094h-18.516v-28.719h18.516c6.719,0,12.422-1.062,17.109-3.281 c4.656-2.234,8.484-5.094,11.453-8.625c2.953-3.5,5.031-7.5,6.219-11.875c1.297-4.469,1.797-8.875,1.797-13.25 c0-12.375-3.406-22.109-10.25-29.156c-6.828-7.078-15.922-10.594-27.188-10.594c-6.953,0-12.797,1.281-17.656,3.984 c-4.812,2.641-8.875,6.156-12.078,10.547c-3.188,4.453-5.719,9.594-7.625,15.484c-1.859,5.875-3.219,12.109-4,18.516H182.828z"></path> </g> </g></svg>
                    </div>
                    <div style="flex-grow:1;text-align:left;">
                        <div style="margin-top:18px;">
                            <div style="font-weight:bold;">Third Payment</div>
                            <div id="third_payment_date" style="width:125px;justify-content: right;font-size:0.8rem">---</div>
                        </div>
                    </div>
                    <div id="third_payment" style="font-weight:bold;"></div>
                </div>
                <?php endif ?>
                <?php if($numberInstallments > 3): ?>
                <div id="fourth_payment_row">
                    <div style="padding-right:25px;">
                        <svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M256,0C114.609,0,0,114.609,0,256s114.609,256,256,256s256-114.609,256-256S397.391,0,256,0z M256,472 c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"></path> <g> <path d="M274.203,384v-62.5H176v-37.203L274.203,128H303.5v164.484H336V321.5h-32.5V384H274.203z M202.438,292.484h71.766V176.969 L202.438,292.484z"></path> </g> </g></svg>
                    </div>
                    <div style="flex-grow:1;text-align:left;">
                        <div style="margin-top:18px;">
                            <div style="font-weight:bold;">Fourth Payment</div>
                            <div id="fourth_payment_date" style="width:125px;justify-content: right;font-size:0.8rem">---</div>
                        </div>
                    </div>
                    <div id="fourth_payment" style="font-weight:bold;"></div>
                </div>
                <?php endif ?>
                <?php if($numberInstallments > 4): ?>
                <div id="fifth_payment_row">
                    <div style="padding-right:25px;">
                        <svg fill="#000000" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M256,0C114.609,0,0,114.609,0,256s114.609,256,256,256s256-114.609,256-256S397.391,0,256,0z M256,472 c-119.297,0-216-96.703-216-216S136.703,40,256,40s216,96.703,216,216S375.297,472,256,472z"></path> <g> <path d="M183.219,263.844L198.453,128h124.062v29.031H221.328l-6.828,70.109l1.219,0.484c5.844-5.641,12.719-9.656,20.656-12.031 c7.875-2.375,15.719-3.594,23.469-3.594c10.969,0,21.109,2.234,30.5,6.719c9.266,4.406,17.359,10.531,24.078,18.281 c6.734,7.75,12.078,16.891,15.906,27.5c3.797,10.531,5.672,21.781,5.672,33.734c0,11.016-1.656,21.578-5.031,31.984 c-3.531,10.25-8.656,19.328-15.391,27.5c-6.734,8-15.297,14.328-25.656,19.078c-10.406,4.75-22.578,7.203-36.484,7.203 c-19.531,0-36.375-6.188-50.531-18.281c-14.219-12.234-23.188-30.172-26.906-53.688h32.516c2.922,13.453,8.453,23.969,16.641,31.5 c8.172,7.531,17.719,11.453,28.656,11.453c7.5,0,14.328-1.5,20.422-4.5c6.219-2.969,11.453-6.984,15.906-12.016 c4.328-5.156,7.828-11.219,10.156-18.422c2.453-7.078,3.594-14.734,3.594-22.766c0-8.297-1.391-15.859-4.344-22.766 c-3.062-6.797-6.906-12.734-11.859-17.641c-4.922-4.891-10.625-8.75-17.031-11.625C264.234,242.469,257.688,241,251,241 c-7.469,0-14.719,1.844-21.688,5.375c-6.938,3.609-12.812,9.375-17.625,17.469H183.219z"></path> </g> </g></svg>
                    </div>
                    <div style="flex-grow:1;text-align:left;">
                        <div style="margin-top:18px;">
                            <div style="font-weight:bold;">Fifth Payment</div>
                            <div id="fifth_payment_date" style="width:125px;justify-content: right;font-size:0.8rem">---</div>
                        </div>
                    </div>
                    <div id="fifth_payment" style="font-weight:bold;"></div>
                </div>
                <?php endif ?>

            </div>
            <?php if($model->enable_promo) : ?>
            <div id="promo-table" style="border-top: 1px solid rgba(4, 32, 69, 0.14);display:flex;padding:30px 0px;">
                <input type="text" id="promotion-code" name="promotion-code" placeholder="Promo Code" class="form-control" style="width:auto;flex-grow:1;margin-right:10px"/>
                <a id="addDiscountBtn" class="btn" >Apply</a>
<!--                <button id="remove-promotion-codes" class="btn">Remove</button>-->
                <div id="promotion-code-error"></div>
            </div>
            <?php endif; ?>
            <div style="border-top: 1px solid rgba(4, 32, 69, 0.14);display:flex;padding:30px 0px;">
                <div style="flex-grow:1;font-weight:bold;font-size:1rem;align-items: center;display: flex;">
                    Currency
                </div>
                <div>
                    <?php
                        $currencies = ArrayHelper::map(\app\models\Currency::find()->all(), 'currency_code', 'description');
                        array_walk($currencies, function(&$value, $key){
                            $value = $key.' - '.$value;
                        });

                        echo \app\helpers\Html::dropDownList('currencies', 'USD',  $currencies, ['onchange' => 'currencyChanged()', 'class' => 'form-select']);
                    ?>
                </div>
            </div>
            <div id="checkout-total" style="padding:0px;padding-top:30px;font-size:1rem;border-top: 1px solid rgba(4, 32, 69, 0.14);">
<!--                <div id="checkout_installments_row" style="display:none;padding-bottom:20px;">-->
<!--                    <div style="display:inline-block;">Number of Installments</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_installments">3 Equal Installments</div>-->
<!--                </div>-->
                <div id="checkout_individualpayment_row" style="display:flex;padding-bottom:20px;">
                    <div style="display:inline-block;">Payment Amount</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_individualpayment"></div>
                </div>
                <div id="checkout_subtotal_row" style="display:flex;padding-bottom:20px;">
                    <div style="display:inline-block;">Subtotal</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_subtotal">$0.00</div>
                </div>
                <?php if($model->surcharge) : ?>
                    <div id="checkout_fees_row" style="display:flex;padding-bottom:20px;">
                        <div style="display:inline-block;">Fees</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_fees">$0.00</div>
                    </div>
                    <div id="checkout_discount_row" style="display:flex;" class="showSection">
                        <div style="display:inline-block;">ACH Discount</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_discount">- $0.00</div>
                    </div>
                <?php endif; ?>
                <div style="display:flex;border-top: 1px solid rgba(4, 32, 69, 0.14);margin-top:20px;padding-top:10px;font-size:1.2rem;">
                    <div style="display:inline-block;font-weight:bold;">Total</div><div style="display:inline-block;font-weight:bold;flex-grow:1;text-align:right;" id="checkout_grand_total">$0.00</div>
                    <input type="hidden" name="amountSubTotal" id="amountSubTotal" value="0" />
                    <input type="hidden" name="amountFees" id="amountFees" value="0" />
                    <input type="hidden" name="amountDiscount" id="amountDiscount" value="0" />
                    <input type="hidden" id="amountTotal" value="0" />
                    <input type="hidden" id="recurringSubTotal" value="0" />
                    <input type="hidden" id="recurringTotal" value="0" />
                    <input type="hidden" name="packageTotal" id="packageTotal" value="0" />
                    <input type="hidden" name="customer_name" id="customer_name" value="" />
                    <input type="hidden" name="customer_email" id="customer_email" value="" />
                    <input type="hidden" name="installment[0][price]" />
                    <input type="hidden" name="installment[0][amountSubTotal]" />
                    <input type="hidden" name="installment[0][amountFees]" />
                    <input type="hidden" name="installment[0][amountDiscount]" />
                    <input type="hidden" name="installment[0][amountTotal]" />
                    <input type="hidden" name="installment[0][date]" />
                    <input type="hidden" name="installment[1][price]" />
                    <input type="hidden" name="installment[1][amountSubTotal]" />
                    <input type="hidden" name="installment[1][amountFees]" />
                    <input type="hidden" name="installment[1][amountDiscount]" />
                    <input type="hidden" name="installment[1][amountTotal]" />
                    <input type="hidden" name="installment[1][date]" />
                    <input type="hidden" name="installment[2][price]" />
                    <input type="hidden" name="installment[2][amountSubTotal]" />
                    <input type="hidden" name="installment[2][amountFees]" />
                    <input type="hidden" name="installment[2][amountDiscount]" />
                    <input type="hidden" name="installment[2][amountTotal]" />
                    <input type="hidden" name="installment[2][date]" />
                    <input type="hidden" name="installment[3][price]" />
                    <input type="hidden" name="installment[3][amountSubTotal]" />
                    <input type="hidden" name="installment[3][amountFees]" />
                    <input type="hidden" name="installment[3][amountDiscount]" />
                    <input type="hidden" name="installment[3][amountTotal]" />
                    <input type="hidden" name="installment[3][date]" />
                    <input type="hidden" name="installment[4][price]" />
                    <input type="hidden" name="installment[4][amountSubTotal]" />
                    <input type="hidden" name="installment[4][amountFees]" />
                    <input type="hidden" name="installment[4][amountDiscount]" />
                    <input type="hidden" name="installment[4][amountTotal]" />
                    <input type="hidden" name="installment[4][date]" />
                    <input type="hidden" name="num_installments" value="<?= $numberInstallments ?? 0 ?>" />
                    <input type="hidden" name="payment_type" />
                </div>
            </div>
        </div>
    </div>

    <div class="stripe-promo-form">
        <div>
            <div style="font-size:1.5rem;font-weight:bold;padding-bottom:20px;">
                Payment Details
            </div>
            <div class="payment_alert">
                Payment encountered an unexpected error. Please try another payment method or contact support for additional help.
            </div>
            <div id="payment-options" style="margin-bottom:20px;padding:0px;">
                <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                    Select Payment Option
                </div>

                <div role="tablist" aria-label="Payment Options" aria-orientation="horizontal" class="p-PaymentMethodSelector">
                    <?php if(in_array('full', $model->payment_options)): ?>
                    <button type="button" id="pay-now" class="p-Tab Tab <?= $model->payment_options[0] == 'full' ? 'Tab--selected' : '' ?>" onclick="updatePaymentOptionButton('full')">
                        <div class="p-TabIconContainer">
                            <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon  <?= $model->payment_options[0] == 'full' ? 'p-TabIcon--selected' : '' ?>" fill="#000000" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M16 0c-8.836 0-16 7.163-16 16s7.163 16 16 16c8.837 0 16-7.163 16-16s-7.163-16-16-16zM16 30.032c-7.72 0-14-6.312-14-14.032s6.28-14 14-14 14 6.28 14 14-6.28 14.032-14 14.032zM22.386 10.146l-9.388 9.446-4.228-4.227c-0.39-0.39-1.024-0.39-1.415 0s-0.391 1.023 0 1.414l4.95 4.95c0.39 0.39 1.024 0.39 1.415 0 0.045-0.045 0.084-0.094 0.119-0.145l9.962-10.024c0.39-0.39 0.39-1.024 0-1.415s-1.024-0.39-1.415 0z"></path> </g></svg>
                        </div>
                        <span class="p-TabLabel TabLabel">Pay Now</span>
                    </button>
                    <?php endif; ?>
                    <?php if(in_array('plan', $model->payment_options)): ?>
                    <button type="button" id="pay-plan" class="p-Tab Tab <?= $model->payment_options[0] == 'plan' ? 'Tab--selected' : '' ?>" onclick="updatePaymentOptionButton('plan')">
                        <div class="p-TabIconContainer">
<!--                            <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon  --><?php //= $model->payment_options[0] == 'plan' ? 'p-TabIcon--selected' : '' ?><!--" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g id="Calendar / Calendar_Check"> <path id="Vector" d="M4 8H20M4 8V16.8002C4 17.9203 4 18.4801 4.21799 18.9079C4.40973 19.2842 4.71547 19.5905 5.0918 19.7822C5.5192 20 6.07899 20 7.19691 20H16.8031C17.921 20 18.48 20 18.9074 19.7822C19.2837 19.5905 19.5905 19.2842 19.7822 18.9079C20 18.4805 20 17.9215 20 16.8036V8M4 8V7.2002C4 6.08009 4 5.51962 4.21799 5.0918C4.40973 4.71547 4.71547 4.40973 5.0918 4.21799C5.51962 4 6.08009 4 7.2002 4H8M20 8V7.19691C20 6.07899 20 5.5192 19.7822 5.0918C19.5905 4.71547 19.2837 4.40973 18.9074 4.21799C18.4796 4 17.9203 4 16.8002 4H16M8 4H16M8 4V2M16 4V2M15 12L11 16L9 14" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g> </g></svg>-->
                            <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon  <?= $model->payment_options[0] == 'plan' ? 'p-TabIcon--selected' : '' ?>" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" xml:space="preserve">
                                <g>
                                    <path d="M58.446,17.095c-0.828,0-1.5,0.671-1.5,1.5s0.672,1.5,1.5,1.5c16.491,0,29.907,13.415,29.907,29.905   c0,16.489-13.416,29.904-29.907,29.904c-12.403,0-23.431-7.698-27.856-19.052l1.994,0.887c0.758,0.338,1.644-0.005,1.98-0.762   s-0.004-1.644-0.761-1.98l-5.128-2.279c-0.739-0.327-1.603-0.013-1.958,0.713l-2.273,4.655c-0.363,0.744-0.054,1.643,0.69,2.006   c0.212,0.104,0.436,0.152,0.657,0.152c0.555,0,1.089-0.31,1.349-0.842l0.672-1.377c4.889,12.451,17.015,20.879,30.633,20.879   c18.146,0,32.907-14.761,32.907-32.904S76.592,17.095,58.446,17.095z"/>
                                    <path d="M46.653,42.604V23.506c0-0.829-0.671-1.5-1.5-1.5H10.145c-0.829,0-1.5,0.671-1.5,1.5v19.098c0,0.829,0.671,1.5,1.5,1.5   h35.008C45.981,44.104,46.653,43.433,46.653,42.604z M43.653,41.104H11.645V25.006h32.008V41.104z"/>
                                    <path d="M27.65,38.431c2.965,0,5.378-2.413,5.378-5.378s-2.413-5.378-5.378-5.378s-5.378,2.413-5.378,5.378   S24.685,38.431,27.65,38.431z M27.65,30.675c1.311,0,2.378,1.067,2.378,2.378s-1.067,2.378-2.378,2.378s-2.378-1.067-2.378-2.378   S26.339,30.675,27.65,30.675z"/>
                                    <path d="M42.327,66.188c0.293,0.293,0.677,0.439,1.061,0.439s0.768-0.146,1.061-0.439l14.756-14.766   c0.281-0.281,0.439-0.663,0.439-1.061V29.026c0-0.829-0.672-1.5-1.5-1.5s-1.5,0.671-1.5,1.5V49.74L42.326,64.066   C41.741,64.652,41.741,65.603,42.327,66.188z"/>
                                </g>
                            </svg>
                        </div>
                        <span class="p-TabLabel TabLabel">Pay in Installments</span>
                    </button>
                    <?php endif; ?>
                    <?php if(in_array('deposit', $model->payment_options)): ?>
                        <button type="button" id="pay-deposit" class="p-Tab Tab <?= $model->payment_options[0] == 'deposit' ? 'Tab--selected' : '' ?>" onclick="updatePaymentOptionButton('deposit')">
                            <div class="p-TabIconContainer">
                                <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon  <?= $model->payment_options[0] == 'deposit' ? 'p-TabIcon--selected' : '' ?>" fill="#000000" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M16 0c-8.836 0-16 7.163-16 16s7.163 16 16 16c8.837 0 16-7.163 16-16s-7.163-16-16-16zM16 30.032c-7.72 0-14-6.312-14-14.032s6.28-14 14-14 14 6.28 14 14-6.28 14.032-14 14.032zM22.386 10.146l-9.388 9.446-4.228-4.227c-0.39-0.39-1.024-0.39-1.415 0s-0.391 1.023 0 1.414l4.95 4.95c0.39 0.39 1.024 0.39 1.415 0 0.045-0.045 0.084-0.094 0.119-0.145l9.962-10.024c0.39-0.39 0.39-1.024 0-1.415s-1.024-0.39-1.415 0z"></path> </g></svg>
                            </div>
                            <span class="p-TabLabel TabLabel">Pay Deposit Only</span>
                        </button>
                    <?php endif; ?>
                </div>
            </div>

            <div id="payment-methods" style="margin-bottom:20px;padding:0px;">
                <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                    Select Payment Method
                </div>

                <div role="tablist" aria-label="Payment Methods" aria-orientation="horizontal" class="p-PaymentMethodSelector">
                    <?php if(in_array('ach', $model->payment_methods)): ?>
                    <button type="button" id="ach" class="p-Tab Tab <?= $model->payment_methods[0] == 'ach' ? 'Tab--selected' : '' ?>" onclick="updatePaymentMethodButton('ach')">
                        <div class="p-TabIconContainer">
                            <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon <?= $model->payment_methods[0] == 'ach' ? 'p-TabIcon--selected' : '' ?>"  viewBox="0 0 24 24" fill="var(--colorIcon)" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M3 21.0001H21M4 18.0001H20M6 18.0001V13.0001M10 18.0001V13.0001M14 18.0001V13.0001M18 18.0001V13.0001M12 7.00695L12.0074 7.00022M21 10.0001L14.126 3.88986C13.3737 3.2212 12.9976 2.88688 12.5732 2.75991C12.1992 2.64806 11.8008 2.64806 11.4268 2.75991C11.0024 2.88688 10.6263 3.2212 9.87404 3.88986L3 10.0001H21Z" stroke="var(--colorIcon)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                        </div>
                        <span class="p-TabLabel TabLabel">ACH Transfer</span>

                    </button>
                    <?php endif; ?>

                    <?php if(in_array('card', $model->payment_methods)): ?>
                    <button type="button" id="card" class="p-Tab Tab <?= $model->payment_methods[0] == 'card' ? 'Tab--selected' : '' ?>" onclick="updatePaymentMethodButton('card')">
                        <div class="p-TabIconContainer">
                            <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon <?= $model->payment_methods[0] == 'card' ? 'p-TabIcon--selected' : '' ?>" role="presentation" fill="var(--colorIcon)" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 4a2 2 0 012-2h12a2 2 0 012 2H0zm0 2v6a2 2 0 002 2h12a2 2 0 002-2V6H0zm3 5a1 1 0 011-1h1a1 1 0 110 2H4a1 1 0 01-1-1z"></path></svg>
                        </div>
                        <span class="p-TabLabel TabLabel TabLabel--selected">Card</span>
                    </button>
                    <?php endif; ?>

                </div>
            </div>

            <div id="checkout">
                <div class="checkout-title" style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                    Payment Details
                </div>
                <div id="full-ach" class="showSection">
                    <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                        <div id="ach-payment-element" class=""></div>
                        <div id="card-errors" class="help-block error-block"></div>
                    </div>
                </div>
                <div id="full-card">
                    <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                        <div id="payment-element" class=""></div>
                        <div id="card-errors" class="help-block error-block"></div>
                    </div>
                </div>
                <div id="subscribe-ach">
                    <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                        <div id="subscription-ach-payment-element" class=""></div>
                        <div id="card-errors" class="help-block error-block"></div>
                    </div>
                </div>
                <div id="subscribe-card">
                    <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                        <div id="subscription-payment-element" class=""></div>
                        <div id="card-errors" class="help-block error-block"></div>
                    </div>
                </div>
                <div>
                    <button id="submitPaymentButton" type="submit" class="btn btn-primary has-spinner" style="width:100%;">Submit Payment</button>
                    <button type="button" class="btn" style="width:100%;margin-top:20px;" onclick="showPaymentWarningModal()">Submit Registration without Payment</button>
                    <div id="paymentWarningModal" class="modal fade" style="max-height:unset !important;" tabindex="-1" role="dialog">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" style="font-size:1.2rem;">Payment Required</h5>
                                </div>
                                <div class="modal-body">
                                    <p style="font-size:0.9rem;margin:15px;">Please note that your registration is incomplete until payment is received.<br /><br />Do you wish to continue without payment?</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                    <button type="button" id="submitLaterButton" class="btn btn-primary has-spinner" onclick="submitWithoutPayment()">Continue</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
